/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.low.logic.miner;

import ic2.api.classic.item.IScannerItem;
import ic2.core.block.machine.low.TileEntityMiner;
import ic2.core.block.machine.low.logic.miner.FluidMiningTarget;
import ic2.core.block.machine.low.logic.miner.IMiningTarget;
import ic2.core.block.machine.low.logic.miner.NormalMiningTarget;
import ic2.core.util.helpers.AabbUtil;
import ic2.core.util.misc.FluidHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class MinerCache {
    LinkedList<IMiningTarget> targets = new LinkedList();
    final TileEntityMiner miner;

    public MinerCache(TileEntityMiner tile) {
        this.miner = tile;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (IMiningTarget target : this.targets) {
            NBTTagCompound data = target.save();
            data.func_74774_a("TypeID", target.getID());
            list.func_74742_a((NBTBase)data);
        }
        nbt.func_74782_a("CacheList", (NBTBase)list);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.targets.clear();
        NBTTagList list = nbt.func_150295_c("CacheList", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound data = list.func_150305_b(i);
            byte type = data.func_74771_c("TypeID");
            if (type == 0) continue;
            IMiningTarget read = type == 1 ? new NormalMiningTarget() : new FluidMiningTarget();
            read.loadFromNBT(data);
            this.addTarget(read);
        }
    }

    public boolean hasTargets() {
        return this.targets.size() > 0;
    }

    public IMiningTarget getTarget() {
        return this.targets.poll();
    }

    public void findTargets(BlockPos yTarget, IScannerItem scanner, ItemStack stack) {
        int radius = scanner.startLayerScan(stack);
        if (radius > 0) {
            World world = this.miner.func_145831_w();
            boolean hasPumps = this.miner.hasPumps();
            AabbUtil.BoundingBox box = new AabbUtil.BoundingBox(yTarget, radius);
            HashSet<BlockPos> visited = new HashSet<BlockPos>();
            LinkedList<BlockPos> work = new LinkedList<BlockPos>();
            visited.add(yTarget);
            work.addAll(this.getList(yTarget));
            while (work.size() > 0) {
                IFluidHandler handler;
                IBlockState state;
                BlockPos check = (BlockPos)work.remove();
                if (visited.contains(check) || !box.intersectsWith(check)) continue;
                visited.add(check);
                if (!world.func_175667_e(check) || !this.miner.canMine(check, state = world.func_180495_p(check))) continue;
                if (hasPumps && (handler = FluidHelper.getBlockHandler(state, world, check)) != null) {
                    IFluidTankProperties prop = handler.getTankProperties()[0];
                    FluidStack fluid = prop.getContents();
                    if (prop.canDrain() && fluid != null && this.miner.hasFluidPump(fluid)) {
                        this.addTarget(this.miner.createTarget(check));
                    }
                }
                if (scanner.isAdvancedScanner(stack) ? scanner.isValuableOre(stack, state, world, check) : scanner.isValuableOre(stack, state)) {
                    this.addTarget(this.miner.createTarget(check));
                }
                work.addAll(this.getList(check));
            }
        }
    }

    public List<BlockPos> getList(BlockPos pos) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            list.add(pos.func_177972_a(dir));
        }
        return list;
    }

    public void addTarget(IMiningTarget target) {
        this.targets.add(target);
    }

    public boolean canClear() {
        return this.targets.size() > 0;
    }

    public void clear() {
        this.targets.clear();
    }
}

