/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.med;

import com.google.common.base.Predicate;
import ic2.api.classic.network.INetworkFieldData;
import ic2.api.classic.network.adv.IBitLevelOverride;
import ic2.api.classic.network.adv.IInputBuffer;
import ic2.api.classic.network.adv.IOutputBuffer;
import ic2.api.classic.network.adv.NetworkField;
import ic2.core.IC2;
import ic2.core.block.base.tile.TileEntityElecMachine;
import ic2.core.entity.IC2DamageSource;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.item.armor.standart.ItemHazmatArmor;
import ic2.core.util.helpers.FilteredList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayerFactory;

public class TileEntityTeslaCoil
extends TileEntityElecMachine
implements ITickable,
IBitLevelOverride {
    public static Predicate<EntityLivingBase> shockPrediction = new EntityPredict();
    int ticker;
    @NetworkField(index=7)
    public ParticalContainer container = new ParticalContainer();

    public TileEntityTeslaCoil() {
        super(0, 128);
        this.maxEnergy = 50000;
        this.ticker = IC2.random.nextInt(50);
    }

    @Override
    public NetworkField.BitLevel getOverride(int fieldID, String fieldName) {
        return NetworkField.BitLevel.Bit24;
    }

    @Override
    public boolean hasOverride(int fieldID, String fieldName) {
        return fieldID == 3 || fieldID == 4;
    }

    @Override
    public InventoryHandler getHandler() {
        return null;
    }

    @Override
    public boolean supportsNotify() {
        return false;
    }

    @Override
    public boolean needsInitialRedstoneUpdate() {
        return true;
    }

    public void func_73660_a() {
        this.handleRedstone();
        if (this.isRedstonePowered()) {
            return;
        }
        if (this.ticker > 0) {
            --this.ticker;
        } else {
            if (this.energy < this.getCost()) {
                this.ticker = 32;
                return;
            }
            int damage = this.energy / this.getCost();
            this.useEnergy(1);
            if (this.shock(damage)) {
                this.useEnergy(this.energy);
            }
            this.ticker = 32;
        }
    }

    public boolean shock(int damage) {
        boolean shock = false;
        this.container.clear();
        this.container.setDamage(damage);
        IC2DamageSource source = IC2DamageSource.newShockDamage((Entity)FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)this.func_145831_w())));
        List list = this.field_145850_b.func_175647_a(EntityLivingBase.class, new AxisAlignedBB(this.func_174877_v()).func_186662_g(4.0), shockPrediction);
        for (int l = 0; l < list.size(); ++l) {
            EntityLivingBase victim = (EntityLivingBase)list.get(l);
            shock = true;
            victim.func_70097_a((DamageSource)source, (float)damage);
            this.container.addEntity((Entity)victim);
        }
        if (shock) {
            this.getNetwork().updateTileEntityField(this, "container");
        }
        return shock;
    }

    public int getCost() {
        return 400;
    }

    @Override
    public void onNetworkUpdate(String field) {
        super.onNetworkUpdate(field);
        if (field.equals("container")) {
            this.container.applyParticals(this.func_145831_w());
        }
    }

    public static class EntityPredict
    implements Predicate<EntityLivingBase> {
        public boolean apply(@Nullable EntityLivingBase input) {
            if (input == null) {
                return false;
            }
            if (input instanceof EntityPlayer && ((EntityPlayer)input).field_71075_bZ.field_75098_d) {
                return false;
            }
            if (!EntitySelectors.field_94557_a.apply((Object)input)) {
                return false;
            }
            if (!EntitySelectors.field_180132_d.apply((Object)input)) {
                return false;
            }
            return !ItemHazmatArmor.isFullHazmatSuit(input);
        }
    }

    public static class ParticalContainer
    implements INetworkFieldData {
        int damage;
        Set<Integer> toShock = new FilteredList<Integer>();

        @Override
        public void read(IInputBuffer buffer) {
            this.toShock.clear();
            if (!buffer.readBoolean()) {
                this.damage = -1;
                return;
            }
            this.damage = buffer.readInt();
            int amount = buffer.readInt();
            for (int i = 0; i < amount; ++i) {
                this.toShock.add(buffer.readInt());
            }
        }

        @Override
        public void write(IOutputBuffer buffer) {
            if (this.damage == -1) {
                buffer.writeBoolean(false);
                return;
            }
            buffer.writeBoolean(true);
            buffer.writeInt(this.damage);
            buffer.writeInt(this.toShock.size());
            for (Integer id : this.toShock) {
                buffer.writeInt(id);
            }
        }

        public void setDamage(int newDamage) {
            this.damage = newDamage;
        }

        public void addEntity(Entity entity) {
            this.toShock.add(entity.func_145782_y());
        }

        public void clear() {
            this.toShock.clear();
            this.damage = -1;
        }

        public void applyParticals(World world) {
            if (this.damage == -1 || this.toShock.size() == 0) {
                return;
            }
            for (Integer id : this.toShock) {
                Entity entity = world.func_73045_a(id.intValue());
                if (!(entity instanceof EntityLivingBase)) continue;
                for (int i = 0; i < this.damage; ++i) {
                    world.func_175688_a(EnumParticleTypes.REDSTONE, entity.field_70165_t - 0.5 + (double)world.field_73012_v.nextFloat(), entity.field_70163_u + (double)(world.field_73012_v.nextFloat() * 2.0f), entity.field_70161_v - 0.5 + (double)world.field_73012_v.nextFloat(), 0.0, 0.0, 1.0, new int[0]);
                }
            }
        }
    }
}

