/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring;

import ic2.core.block.base.BlockCommonContainer;
import ic2.core.block.misc.BlockFencePole;
import ic2.core.block.render.model.LuminatorModel;
import ic2.core.block.wiring.BlockCable;
import ic2.core.block.wiring.BlockMultipartLuminator;
import ic2.core.block.wiring.tile.TileEntityLuminator;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.player.PlayerHandler;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2States;
import ic2.core.platform.textures.models.BaseModel;
import ic2.core.platform.textures.obj.ICustomModeledBlock;
import ic2.core.util.helpers.BlockStateContainerIC2;
import ic2.core.util.helpers.ItemWithMeta;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.IBootable;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockLuminator
extends BlockCommonContainer
implements ICustomModeledBlock,
IBootable {
    public static PropertyDirection sides = PropertyDirection.func_177713_a((String)"side", Arrays.asList(EnumFacing.field_82609_l));
    public static PropertyBool active = PropertyBool.func_177716_a((String)"active");
    public static PropertyBool big = PropertyBool.func_177716_a((String)"big");

    public BlockLuminator() {
        super(Material.field_151592_s);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149711_c(0.3f);
        this.func_149752_b(0.5f);
        this.setUnlocalizedName(Ic2BlockLang.luminator);
        this.setHarvestLevel("pickaxe", 1);
    }

    public void func_190948_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        if (player == null) {
            return;
        }
        PlayerHandler handler = PlayerHandler.getClientPlayerHandler();
        if (handler.hasEUReader()) {
            tooltip.add(Ic2InfoLang.euReaderSinkInfo.getLocalizedFormatted(32));
        }
    }

    @Override
    public void onLoad() {
        Ic2Items.luminator = new ItemStack((Block)this);
        Ic2States.luminator = this.func_176223_P();
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityLuminator();
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public BlockFaceShape func_193383_a(IBlockAccess p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing p_193383_4_) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityLuminator && ((TileEntityLuminator)tile).getActive() && entityIn instanceof EntityMob) {
            entityIn.func_70015_d(entityIn instanceof EntityLivingBase && ((EntityLivingBase)entityIn).func_70668_bt() == EnumCreatureAttribute.UNDEAD ? 20 : 10);
        }
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityLuminator) {
            return ((TileEntityLuminator)tile).getActive() ? 15 : 0;
        }
        return 0;
    }

    @Deprecated
    public int func_149750_m(IBlockState state) {
        return 0;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        ItemStack item;
        Block block;
        TileEntityLuminator lumi;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityLuminator && (lumi = (TileEntityLuminator)tile).getGlass() != null && (block = Block.func_149634_a((Item)(item = lumi.getGlass()).func_77973_b())) != null) {
            return block.func_149638_a(exploder);
        }
        return super.getExplosionResistance(world, pos, exploder, explosion);
    }

    @Override
    public IBlockState getDefaultBlockState() {
        return this.func_176223_P().func_177226_a((IProperty)sides, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)active, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)big, (Comparable)Boolean.valueOf(false));
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Override
    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityLuminator) {
            ((TileEntityLuminator)tile).setSide((EnumFacing)state.func_177229_b((IProperty)sides));
        }
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)sides, (Comparable)facing);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{sides, active, big});
    }

    @Deprecated
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityLuminator) {
            TileEntityLuminator lumi = (TileEntityLuminator)tile;
            state = state.func_177226_a((IProperty)active, (Comparable)Boolean.valueOf(lumi.getActive())).func_177226_a((IProperty)sides, (Comparable)lumi.getFacing()).func_177226_a((IProperty)big, (Comparable)Boolean.valueOf(BlockLuminator.isSpecialSupporter(worldIn, pos.func_177972_a(lumi.getFacing().func_176734_d()))));
        }
        return state;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityLuminator) {
            TileEntityLuminator lumi = (TileEntityLuminator)tile;
            ItemStack stack = lumi.getGlass();
            if (stack.func_190926_b()) {
                return state;
            }
            return new BlockStateContainerIC2.IC2BlockState(state, new ItemWithMeta(stack));
        }
        return state;
    }

    @Override
    public List<IBlockState> getValidModelStates() {
        return this.func_176194_O().func_177619_a();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BaseModel getModelFromState(IBlockState state) {
        return new LuminatorModel(state, state == this.func_176223_P());
    }

    @Override
    public IBlockState getStateFromStack(ItemStack stack) {
        return this.func_176223_P();
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        if (!worldIn.func_175623_d(pos)) {
            return false;
        }
        return BlockLuminator.isSupportingBlock(worldIn, pos.func_177972_a(side.func_176734_d()));
    }

    public boolean canBlockStay(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof TileEntityLuminator)) {
            return false;
        }
        TileEntityLuminator lumi = (TileEntityLuminator)te;
        if (lumi.ignoreBlockStay) {
            return true;
        }
        return BlockLuminator.isSupportingBlock(world, pos.func_177972_a(lumi.getFacing().func_176734_d()));
    }

    @Override
    @Deprecated
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos origin) {
        if (!this.canBlockStay(worldIn, pos) && !BlockLuminator.isGlass((IBlockAccess)worldIn, pos)) {
            if (!worldIn.field_72995_K) {
                StackUtil.dropAsEntity(worldIn, pos, Ic2Items.luminator.func_77946_l());
            }
            worldIn.func_175698_g(pos);
        }
    }

    public static boolean isSupportingBlock(World world, BlockPos pos) {
        return !world.func_175623_d(pos) && (world.func_175677_d(pos, true) || BlockLuminator.isSpecialSupporter((IBlockAccess)world, pos));
    }

    public static boolean isSpecialSupporter(IBlockAccess world, BlockPos pos) {
        if (world.func_175623_d(pos)) {
            return false;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        return block instanceof BlockFence || block instanceof BlockFencePole || block instanceof BlockCable || block instanceof BlockMultipartLuminator || block == Ic2States.reinforcedGlass.func_177230_c() || block == Blocks.field_150359_w || block == Blocks.field_150399_cn;
    }

    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BlockLuminator.getCommonBox(source, pos);
    }

    public static AxisAlignedBB getCommonBox(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        EnumFacing dir = null;
        if (tile instanceof TileEntityLuminator) {
            TileEntityLuminator luma = (TileEntityLuminator)tile;
            ItemStack item = luma.getGlass();
            dir = luma.getFacing();
            if (item != null) {
                return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
            }
        }
        if (dir == null) {
            return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        }
        double px = 0.0625;
        boolean fullCover = BlockLuminator.isSpecialSupporter(world, pos.func_177972_a(dir.func_176734_d()));
        switch (dir.func_176745_a()) {
            case 1: {
                return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0 * px, 1.0);
            }
            case 2: {
                if (fullCover) {
                    return new AxisAlignedBB(0.0, 0.0, 15.0 * px, 1.0, 1.0, 1.0);
                }
                return new AxisAlignedBB(6.0 * px, 3.0 * px, 14.0 * px, 1.0 - 6.0 * px, 1.0 - 3.0 * px, 1.0);
            }
            case 3: {
                if (fullCover) {
                    return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0 * px);
                }
                return new AxisAlignedBB(6.0 * px, 3.0 * px, 0.0, 1.0 - 6.0 * px, 1.0 - 3.0 * px, 2.0 * px);
            }
            case 4: {
                if (fullCover) {
                    return new AxisAlignedBB(15.0 * px, 0.0, 0.0, 1.0, 1.0, 1.0);
                }
                return new AxisAlignedBB(14.0 * px, 3.0 * px, 6.0 * px, 1.0, 1.0 - 3.0 * px, 1.0 - 6.0 * px);
            }
            case 5: {
                if (fullCover) {
                    return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0 * px, 1.0, 1.0);
                }
                return new AxisAlignedBB(0.0, 3.0 * px, 6.0 * px, 2.0 * px, 1.0 - 3.0 * px, 1.0 - 6.0 * px);
            }
        }
        if (fullCover) {
            return new AxisAlignedBB(0.0, 15.0 * px, 0.0, 1.0, 1.0, 1.0);
        }
        return new AxisAlignedBB(4.0 * px, 13.0 * px, 4.0 * px, 1.0 - 4.0 * px, 1.0, 1.0 - 4.0 * px);
    }

    public static boolean isGlass(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityLuminator) {
            TileEntityLuminator luma = (TileEntityLuminator)tile;
            return luma.getGlass() != null;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @Override
    public boolean needsRedstoneUpdates(int meta) {
        return false;
    }
}

