/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.energy;

import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.core.energy.EnergyNetLocal;
import ic2.core.util.helpers.FilteredList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.math.BlockPos;

public class EnergyNetPathMap {
    EnergyNetLocal local;
    Map<IEnergySource, Set<EnergyNetLocal.EnergyPath>> sourcePaths = new HashMap<IEnergySource, Set<EnergyNetLocal.EnergyPath>>();
    Map<IEnergySink, Set<EnergyNetLocal.EnergyPath>> sinkPaths = new HashMap<IEnergySink, Set<EnergyNetLocal.EnergyPath>>();
    Set<EnergyNetLocal.EnergyPath> allPaths = new LinkedHashSet<EnergyNetLocal.EnergyPath>();

    public EnergyNetPathMap(EnergyNetLocal par1) {
        this.local = par1;
    }

    public void addSources(IEnergySource source, List<EnergyNetLocal.EnergyPath> paths) {
        Set<EnergyNetLocal.EnergyPath> list = this.sourcePaths.get(source);
        if (list == null) {
            this.sourcePaths.put(source, new LinkedHashSet<EnergyNetLocal.EnergyPath>(paths));
        } else {
            list.addAll(paths);
        }
        for (EnergyNetLocal.EnergyPath path : paths) {
            Set<EnergyNetLocal.EnergyPath> sinkList = this.sinkPaths.get(path.target);
            if (sinkList == null) {
                sinkList = new LinkedHashSet<EnergyNetLocal.EnergyPath>();
                this.sinkPaths.put(path.target, sinkList);
            }
            sinkList.add(path);
            this.allPaths.add(path);
        }
    }

    public void addSinks(IEnergySink sink, List<EnergyNetLocal.EnergyPath> paths) {
        Set<EnergyNetLocal.EnergyPath> list = this.sinkPaths.get(sink);
        if (list == null) {
            this.sinkPaths.put(sink, new LinkedHashSet<EnergyNetLocal.EnergyPath>(paths));
        } else {
            list.addAll(paths);
        }
        for (EnergyNetLocal.EnergyPath path : paths) {
            Set<EnergyNetLocal.EnergyPath> sourceList = this.sourcePaths.get(path.emitter);
            if (sourceList == null) {
                sourceList = new LinkedHashSet<EnergyNetLocal.EnergyPath>();
                this.sourcePaths.put(path.emitter, sourceList);
            }
            sourceList.add(path);
            this.allPaths.add(path);
        }
    }

    public void removeSource(IEnergySource source) {
        Set<EnergyNetLocal.EnergyPath> paths = this.sourcePaths.remove(source);
        if (paths != null) {
            for (EnergyNetLocal.EnergyPath path : paths) {
                this.sinkPaths.get(path.target).remove(path);
                this.allPaths.remove(path);
            }
        }
    }

    public void removeSink(IEnergySink sink) {
        Set<EnergyNetLocal.EnergyPath> paths = this.sinkPaths.remove(sink);
        if (paths != null) {
            for (EnergyNetLocal.EnergyPath path : paths) {
                this.sourcePaths.get(path.emitter).remove(path);
                this.allPaths.remove(path);
            }
        }
    }

    public void removePaths(Collection<EnergyNetLocal.EnergyPath> paths) {
        for (EnergyNetLocal.EnergyPath path : paths) {
            Set<EnergyNetLocal.EnergyPath> sink;
            Set<EnergyNetLocal.EnergyPath> source = this.sourcePaths.get(path.emitter);
            if (source != null) {
                source.remove(path);
            }
            if ((sink = this.sinkPaths.get(path.target)) != null) {
                sink.remove(path);
            }
            this.allPaths.remove(path);
        }
    }

    public Set<EnergyNetLocal.EnergyPath> get(IEnergySource source) {
        Set<EnergyNetLocal.EnergyPath> paths = this.sourcePaths.get(source);
        if (paths == null) {
            paths = new LinkedHashSet<EnergyNetLocal.EnergyPath>();
        }
        return paths;
    }

    public Set<EnergyNetLocal.EnergyPath> getReverse(IEnergySink sink) {
        Set<EnergyNetLocal.EnergyPath> paths = this.sinkPaths.get(sink);
        if (paths == null) {
            paths = new LinkedHashSet<EnergyNetLocal.EnergyPath>();
        }
        return paths;
    }

    public Set<EnergyNetLocal.EnergyPath> getAllPaths() {
        return this.allPaths;
    }

    public boolean containsKey(IEnergySource source) {
        Set<EnergyNetLocal.EnergyPath> paths = this.sourcePaths.get(source);
        return paths != null && paths.size() > 0;
    }

    public EnergyNetSubPathMap createSubList() {
        return new EnergyNetSubPathMap(this);
    }

    public void clear() {
        this.local = null;
        this.sinkPaths.clear();
        this.sourcePaths.clear();
        this.allPaths.clear();
    }

    public static class EnergyNetSubPathMap {
        EnergyNetPathMap map;
        Map<IEnergySource, Set<EnergyNetLocal.EnergyPath>> sourceSubPaths = new HashMap<IEnergySource, Set<EnergyNetLocal.EnergyPath>>();
        Map<IEnergySink, Set<EnergyNetLocal.EnergyPath>> sinkSubPaths = new HashMap<IEnergySink, Set<EnergyNetLocal.EnergyPath>>();
        Set<EnergyNetLocal.EnergyPath> allSubPaths = new LinkedHashSet<EnergyNetLocal.EnergyPath>();

        public EnergyNetSubPathMap(EnergyNetPathMap par1) {
            this.map = par1;
        }

        public void clear() {
            this.map = null;
            this.sourceSubPaths.clear();
            this.sinkSubPaths.clear();
            this.allSubPaths.clear();
        }

        public void resetPaths() {
            this.sourceSubPaths = new HashMap<IEnergySource, Set<EnergyNetLocal.EnergyPath>>();
            this.sinkSubPaths = new HashMap<IEnergySink, Set<EnergyNetLocal.EnergyPath>>();
            this.map.removePaths(this.allSubPaths);
            this.allSubPaths = new FilteredList<EnergyNetLocal.EnergyPath>();
        }

        public Set<EnergyNetLocal.EnergyPath> getSourcePaths(IEnergySource source) {
            Set<EnergyNetLocal.EnergyPath> path = this.sourceSubPaths.get(source);
            if (path == null) {
                path = new LinkedHashSet<EnergyNetLocal.EnergyPath>();
            }
            return path;
        }

        public Set<EnergyNetLocal.EnergyPath> getSinkPaths(IEnergySink sink) {
            Set<EnergyNetLocal.EnergyPath> path = this.sinkSubPaths.get(sink);
            if (path == null) {
                path = new LinkedHashSet<EnergyNetLocal.EnergyPath>();
            }
            return path;
        }

        public Set<EnergyNetLocal.EnergyPath> getPaths(Collection<IEnergySource> sources, Collection<IEnergySink> sinks) {
            Set<EnergyNetLocal.EnergyPath> set;
            LinkedHashSet<EnergyNetLocal.EnergyPath> sourcePaths = new LinkedHashSet<EnergyNetLocal.EnergyPath>();
            LinkedHashSet<EnergyNetLocal.EnergyPath> sinkPaths = new LinkedHashSet<EnergyNetLocal.EnergyPath>();
            for (IEnergySource source : sources) {
                set = this.sourceSubPaths.get(source);
                if (set == null) continue;
                sourcePaths.addAll(set);
            }
            for (IEnergySink sink : sinks) {
                set = this.sinkSubPaths.get(sink);
                if (set == null) continue;
                sinkPaths.addAll(set);
            }
            sourcePaths.retainAll(sinkPaths);
            return sourcePaths;
        }

        public void copyPaths(Set<EnergyNetLocal.EnergyPath> paths) {
            this.allSubPaths.addAll(paths);
            for (EnergyNetLocal.EnergyPath path : paths) {
                Set<EnergyNetLocal.EnergyPath> sourceList = this.sourceSubPaths.get(path.emitter);
                if (sourceList == null) {
                    sourceList = new LinkedHashSet<EnergyNetLocal.EnergyPath>();
                    this.sourceSubPaths.put(path.emitter, sourceList);
                }
                sourceList.add(path);
                Set<EnergyNetLocal.EnergyPath> sinkList = this.sinkSubPaths.get(path.target);
                if (sinkList == null) {
                    sinkList = new LinkedHashSet<EnergyNetLocal.EnergyPath>();
                    this.sinkSubPaths.put(path.target, sinkList);
                }
                sinkList.add(path);
            }
        }

        public void addAll(EnergyNetSubPathMap pathMap) {
            this.sourceSubPaths.putAll(pathMap.sourceSubPaths);
            this.sinkSubPaths.putAll(pathMap.sinkSubPaths);
            this.allSubPaths.addAll(pathMap.allSubPaths);
        }

        public void removePaths(Collection<EnergyNetLocal.EnergyPath> paths) {
            for (EnergyNetLocal.EnergyPath path : paths) {
                Set<EnergyNetLocal.EnergyPath> sink;
                Set<EnergyNetLocal.EnergyPath> source = this.sourceSubPaths.get(path.emitter);
                if (source != null) {
                    source.remove(path);
                }
                if ((sink = this.sinkSubPaths.get(path.target)) != null) {
                    sink.remove(path);
                }
                this.allSubPaths.remove(path);
            }
            this.map.removePaths(paths);
        }

        public void addSourcePaths(IEnergySource source, List<EnergyNetLocal.EnergyPath> paths) {
            this.allSubPaths.addAll(paths);
            this.addSources(source, paths);
        }

        public void addSinkPaths(IEnergySink sink, List<EnergyNetLocal.EnergyPath> paths) {
            this.allSubPaths.addAll(paths);
            this.addSinks(sink, paths);
        }

        private void addSinks(IEnergySink sink, List<EnergyNetLocal.EnergyPath> paths) {
            Set<EnergyNetLocal.EnergyPath> list = this.sinkSubPaths.get(sink);
            if (list == null) {
                this.sinkSubPaths.put(sink, new LinkedHashSet<EnergyNetLocal.EnergyPath>(paths));
            } else {
                list.addAll(paths);
            }
            for (EnergyNetLocal.EnergyPath path : paths) {
                Set<EnergyNetLocal.EnergyPath> sourceList = this.sourceSubPaths.get(path.emitter);
                if (sourceList == null) {
                    sourceList = new LinkedHashSet<EnergyNetLocal.EnergyPath>();
                    this.sourceSubPaths.put(path.emitter, sourceList);
                }
                sourceList.add(path);
            }
            this.map.addSinks(sink, paths);
        }

        private void addSources(IEnergySource source, List<EnergyNetLocal.EnergyPath> paths) {
            Set<EnergyNetLocal.EnergyPath> list = this.sourceSubPaths.get(source);
            if (list == null) {
                this.sourceSubPaths.put(source, new LinkedHashSet<EnergyNetLocal.EnergyPath>(paths));
            } else {
                list.addAll(paths);
            }
            for (EnergyNetLocal.EnergyPath path : paths) {
                Set<EnergyNetLocal.EnergyPath> sinkList = this.sinkSubPaths.get(path.target);
                if (sinkList == null) {
                    sinkList = new LinkedHashSet<EnergyNetLocal.EnergyPath>();
                    this.sinkSubPaths.put(path.target, sinkList);
                }
                sinkList.add(path);
            }
            this.map.addSources(source, paths);
        }

        public void removeSource(IEnergySource source) {
            Set<EnergyNetLocal.EnergyPath> paths = this.sourceSubPaths.remove(source);
            if (paths != null) {
                this.allSubPaths.removeAll(paths);
                for (EnergyNetLocal.EnergyPath path : paths) {
                    this.sinkSubPaths.get(path.target).remove(path);
                }
                this.map.removePaths(paths);
            }
        }

        public void removeSink(IEnergySink sink) {
            Set<EnergyNetLocal.EnergyPath> paths = this.sinkSubPaths.remove(sink);
            if (paths != null) {
                this.allSubPaths.removeAll(paths);
                for (EnergyNetLocal.EnergyPath path : paths) {
                    this.sourceSubPaths.get(path.emitter).remove(path);
                }
                this.map.removePaths(paths);
            }
        }

        public void removeConductor(IEnergyConductor conductor) {
            Set<EnergyNetLocal.EnergyPath> paths = this.getConductorPaths(conductor);
            if (paths.size() > 0) {
                this.allSubPaths.removeAll(paths);
                for (EnergyNetLocal.EnergyPath path : paths) {
                    this.sourceSubPaths.get(path.emitter).remove(path);
                    this.sinkSubPaths.get(path.target).remove(path);
                }
                this.map.removePaths(paths);
            }
        }

        public Set<EnergyNetLocal.EnergyPath> getConductorPaths(IEnergyConductor conductor) {
            LinkedHashSet<EnergyNetLocal.EnergyPath> paths = new LinkedHashSet<EnergyNetLocal.EnergyPath>();
            BlockPos pos = EnergyNetLocal.coords(conductor);
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            for (EnergyNetLocal.EnergyPath path : this.allSubPaths) {
                if (path.minX > x || path.maxX < x || path.minY > y || path.maxY < y || path.minZ > z || path.maxZ < z || !path.conductors.contains(conductor)) continue;
                paths.add(path);
            }
            return paths;
        }
    }
}

