/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.armor.standart;

import ic2.api.classic.item.IFuelableItem;
import ic2.core.item.armor.base.ItemArmorJetpackBase;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class ItemArmorFuelJetpack
extends ItemArmorJetpackBase
implements IFuelableItem {
    public ItemArmorFuelJetpack() {
        super(38, EntityEquipmentSlot.CHEST);
        this.func_77656_e(18002);
        this.setUnlocalizedName(Ic2ItemLang.jetpackFueled);
    }

    @Override
    public boolean canDoRocketMode(ItemStack stack) {
        return false;
    }

    @Override
    public boolean canDoAdvHoverMode(ItemStack stack) {
        return false;
    }

    @Override
    public boolean isElectricJetpack(ItemStack stack) {
        return false;
    }

    @Override
    public float getPower(ItemStack stack) {
        return 1.0f;
    }

    @Override
    public float getThruster(ItemStack stack, ItemArmorJetpackBase.HoverMode mode) {
        return mode == ItemArmorJetpackBase.HoverMode.Basic ? 0.5f : 0.15f;
    }

    @Override
    public float getDropPercentage(ItemStack stack) {
        return 0.5f;
    }

    @Override
    public int getMaxHeight(ItemStack stack, int worldHeight) {
        return worldHeight;
    }

    @Override
    public int getFuel(ItemStack stack) {
        int left = stack.func_77958_k() - stack.func_77952_i() - 1;
        return left < 0 ? 0 : left;
    }

    @Override
    public int getMaxFuel(ItemStack stack) {
        return stack.func_77958_k();
    }

    @Override
    public int getMaxRocketCharge(ItemStack stack) {
        return 0;
    }

    @Override
    public int getFuelCost(ItemStack stack, ItemArmorJetpackBase.HoverMode mode) {
        return mode == ItemArmorJetpackBase.HoverMode.Basic ? 6 : 9;
    }

    @Override
    public void useEnergy(EntityPlayer player, ItemStack stack, int amount) {
        int newValue = stack.func_77952_i() + amount;
        if (newValue > stack.func_77958_k() - 1) {
            newValue = stack.func_77958_k() - 1;
        }
        stack.func_77964_b(newValue);
    }

    @Override
    public String getTexture() {
        return "ic2:textures/models/armor/jetpack_fuel";
    }

    @Override
    public ItemStack fill(ItemStack emptyItem, int amount) {
        int damage = emptyItem.func_77952_i() - amount;
        if (damage < 1) {
            damage = 1;
        }
        emptyItem.func_77964_b(damage);
        return emptyItem;
    }

    @Override
    public boolean canFill(ItemStack stack) {
        return stack.func_77952_i() > 1;
    }

    @Override
    public boolean hasFuel(ItemStack stack) {
        return false;
    }

    @Override
    public int getFuel(ItemStack stack, int requested, boolean doDrain) {
        return 0;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        subItems.add((Object)new ItemStack((Item)this, 1, 18001));
        subItems.add((Object)new ItemStack((Item)this, 1, 1));
    }
}

