/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.reactor.uranTypes;

import ic2.core.item.reactor.uranTypes.IUranium;
import ic2.core.item.reactor.uranTypes.UranBaseType;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.util.misc.StackUtil;
import java.awt.Color;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class BlazeUranium
extends UranBaseType {
    public BlazeUranium() {
        this.loadDefaults();
    }

    @Override
    public int getMaxDurability() {
        return 10000;
    }

    @Override
    public float getEUPerPulse() {
        return 1.0f;
    }

    @Override
    public int getPulsesPerTick() {
        return 1;
    }

    @Override
    public int getPulsesForConnection() {
        return 1;
    }

    @Override
    public float getHeatModifier() {
        return 4.0f;
    }

    @Override
    public float getExplosionEffectModifier() {
        return 6.0f;
    }

    @Override
    public ItemStack getUraniumIngot() {
        return Ic2Items.blazeUraniumIngot.func_77946_l();
    }

    @Override
    public ItemStack getRodType(IUranium.RodType type) {
        switch (type) {
            case SingleRod: {
                return Ic2Items.reactorBlazeUraniumRodSingle.func_77946_l();
            }
            case DualRod: {
                return Ic2Items.reactorBlazeUraniumRodDual.func_77946_l();
            }
            case QuadRod: {
                return Ic2Items.reactorBlazeUraniumRodQuad.func_77946_l();
            }
            case NearDepletedRod: {
                return Ic2Items.reactorNearDepletedBlazeUraniumRod.func_77946_l();
            }
            case IsotopicRod: {
                return Ic2Items.reactorBlazeUraniumIsotopicRod.func_77946_l();
            }
            case ReEnrichedRod: {
                return Ic2Items.reactorReEnrichedBlazeUraniumRod.func_77946_l();
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack getNewIsotopicRod() {
        return StackUtil.copyWithDamage(this.getRodType(IUranium.RodType.IsotopicRod), this.getMaxDurability() - 1);
    }

    @Override
    public short getRodID(IUranium.RodType type) {
        switch (type) {
            case SingleRod: {
                return 6;
            }
            case DualRod: {
                return 7;
            }
            case QuadRod: {
                return 8;
            }
            case IsotopicRod: {
                return 44;
            }
        }
        return 0;
    }

    @Override
    public LocaleComp getName(IUranium.RodType type) {
        switch (type) {
            case SingleRod: {
                return Ic2ItemLang.uranRodBlazeSingle;
            }
            case DualRod: {
                return Ic2ItemLang.uranRodBlazeDouble;
            }
            case QuadRod: {
                return Ic2ItemLang.uranRodBlazeQuad;
            }
            case NearDepletedRod: {
                return Ic2ItemLang.uranRodBlazeNearDeplete;
            }
            case IsotopicRod: {
                return Ic2ItemLang.uranRodBlazeIsotopic;
            }
            case ReEnrichedRod: {
                return Ic2ItemLang.uranRodBlazeReEnriched;
            }
        }
        return Ic2Lang.nullKey;
    }

    @Override
    public boolean isReEnrichedUran() {
        return true;
    }

    @Override
    public Color getReEnrichedColor() {
        return new Color(15244039);
    }

    @Override
    public ItemStack getIngridient() {
        return new ItemStack(Items.field_151072_bj);
    }

    @Override
    public int getIngrientPoints() {
        return 200;
    }

    @Override
    public int getRow() {
        return 2;
    }

    @Override
    public int getIngridientCost() {
        return 20;
    }
}

