/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.block.info;

import com.raoulvdberge.refinedstorage.block.info.IBlockInfo;
import com.raoulvdberge.refinedstorage.tile.TileBase;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.util.ResourceLocation;

public class BlockInfo
implements IBlockInfo {
    private final Material material;
    private final SoundType soundType;
    private final float hardness;
    private final ResourceLocation id;
    private final Object modObject;
    @Nullable
    private final Supplier<TileBase> tileSupplier;

    public BlockInfo(Material material, SoundType soundType, float hardness, String id, String modId, Object modObject, Supplier<TileBase> tileSupplier) {
        this.material = material;
        this.soundType = soundType;
        this.hardness = hardness;
        this.id = new ResourceLocation(modId, id);
        this.modObject = modObject;
        this.tileSupplier = tileSupplier;
    }

    @Override
    public Material getMaterial() {
        return this.material;
    }

    @Override
    public SoundType getSoundType() {
        return this.soundType;
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public Object getModObject() {
        return this.modObject;
    }

    @Override
    public float getHardness() {
        return this.hardness;
    }

    @Override
    @Nullable
    public TileBase createTileEntity() {
        return this.tileSupplier.get();
    }

    @Override
    public boolean hasTileEntity() {
        return this.tileSupplier != null;
    }
}

