/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.control;

import net.malisis.core.client.gui.Anchor;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.container.UIContainer;
import net.malisis.core.client.gui.component.control.IControlComponent;
import net.malisis.core.renderer.icon.provider.GuiIconProvider;
import net.malisis.core.util.MouseButton;

public class UIResizeHandle
extends UIComponent<UIResizeHandle>
implements IControlComponent {
    private Type type;

    public UIResizeHandle(MalisisGui gui, UIComponent<?> parent, Type type) {
        super(gui);
        this.type = type != null ? type : Type.BOTH;
        int x = -1;
        int y = -1;
        if (parent instanceof UIContainer) {
            x += ((UIContainer)parent).getRightPadding();
            y += ((UIContainer)parent).getBottomPadding();
        }
        this.setPosition(x, y, Anchor.BOTTOM | Anchor.RIGHT);
        this.setSize(5, 5);
        this.register(this);
        parent.addControlComponent(this);
        this.iconProvider = new GuiIconProvider(gui.getGuiTexture().getIcon(268, 0, 15, 15));
    }

    public UIResizeHandle(MalisisGui gui, UIComponent<?> parent) {
        this(gui, parent, Type.BOTH);
    }

    @Override
    public boolean onDrag(int lastX, int lastY, int x, int y, MouseButton button) {
        if (button != MouseButton.LEFT) {
            return super.onDrag(lastX, lastY, x, y, button);
        }
        UIComponent<?> p = this.getParent();
        if (p.getAnchor() != Anchor.NONE) {
            p.setPosition(p.parentX(), p.parentY(), Anchor.NONE);
        }
        int w = this.parent.getWidth();
        int h = this.parent.getHeight();
        if (this.type == Type.BOTH || this.type == Type.HORIZONTAL) {
            w += x - lastX;
        }
        if (this.type == Type.BOTH || this.type == Type.VERTICAL) {
            h += y - lastY;
        }
        if (w < 10) {
            w = 10;
        }
        if (h < 10) {
            h = 10;
        }
        this.getParent().setSize(w, h);
        return true;
    }

    @Override
    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
    }

    @Override
    public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        renderer.drawShape(this.shape, this.rp);
    }

    public static enum Type {
        BOTH,
        HORIZONTAL,
        VERTICAL;

    }
}

