/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.guis.buttons;

import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import vswe.stevescarts.computer.ComputerProg;
import vswe.stevescarts.computer.ComputerTask;
import vswe.stevescarts.guis.buttons.ButtonAssembly;
import vswe.stevescarts.guis.buttons.ButtonBase;
import vswe.stevescarts.modules.workers.ModuleComputer;

public class ButtonTask
extends ButtonAssembly {
    private int id;

    public ButtonTask(ModuleComputer module, ButtonBase.LOCATION loc, int id) {
        super(module, loc);
        this.id = id;
    }

    @Override
    public String toString() {
        ComputerTask task = this.getTask();
        if (task == null) {
            return "Something went wrong";
        }
        return task.toString();
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.getTask() != null;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public int borderID() {
        ComputerTask task = this.getTask();
        if (task != null) {
            ComputerProg program;
            boolean selected = task.getIsActivated();
            boolean running = false;
            if (this.module instanceof ModuleComputer && (program = ((ModuleComputer)this.module).getActiveProgram()) != null) {
                boolean bl = running = program.getActiveId() == this.id;
            }
            if (running && selected) {
                return 2;
            }
            if (running) {
                return 1;
            }
            if (selected) {
                return 0;
            }
        }
        return super.borderID();
    }

    @Override
    public int ColorCode() {
        ComputerTask task = this.getTask();
        if (task != null) {
            return task.getType();
        }
        return 0;
    }

    @Override
    public int texture() {
        ComputerTask task = this.getTask();
        if (task != null) {
            return task.getImage();
        }
        return super.texture();
    }

    @Override
    public void onServerClick(EntityPlayer player, int mousebutton, boolean ctrlKey, boolean shiftKey) {
        ComputerProg program;
        ComputerTask task = this.getTask();
        if (!ctrlKey && this.module instanceof ModuleComputer && (program = ((ModuleComputer)this.module).getCurrentProg()) != null) {
            for (ComputerTask t : program.getTasks()) {
                if (t == task) continue;
                t.setIsActivated(false);
            }
        }
        task.setIsActivated(!task.getIsActivated());
    }

    private ComputerTask getTask() {
        ComputerProg program = ((ModuleComputer)this.module).getCurrentProg();
        if (program == null) {
            return null;
        }
        ArrayList<ComputerTask> tasks = program.getTasks();
        if (this.id >= 0 && this.id < tasks.size()) {
            return tasks.get(this.id);
        }
        return null;
    }
}

