/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.network.packet;

import asmodeuscore.core.astronomy.dimension.world.worldengine.WE_WorldProvider;
import galaxyspace.api.item.IModificationItem;
import galaxyspace.api.tile.ITileEffects;
import galaxyspace.core.events.GSEventHandler;
import galaxyspace.core.handler.capabilities.GSStatsCapability;
import galaxyspace.core.handler.capabilities.GSStatsCapabilityClient;
import galaxyspace.core.handler.capabilities.StatsCapability;
import galaxyspace.core.handler.capabilities.StatsCapabilityClient;
import galaxyspace.core.prefab.items.modules.ItemModule;
import galaxyspace.systems.SolarSystem.planets.overworld.items.armor.ItemSpaceSuit;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityGravitationModule;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityLiquidSeparator;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityModificationTable;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStatsClient;
import micdoodle8.mods.galacticraft.core.network.NetworkUtil;
import micdoodle8.mods.galacticraft.core.network.PacketBase;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.INetHandler;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GSPacketSimple
extends PacketBase
implements Packet<INetHandler> {
    private GSEnumSimplePacket type;
    private List<Object> data;
    private static String spamCheckString;

    public GSPacketSimple() {
    }

    public GSPacketSimple(GSEnumSimplePacket packetType, int dimID, Object ... data) {
        this(packetType, dimID, Arrays.asList(data));
    }

    public GSPacketSimple(GSEnumSimplePacket packetType, World world, Object[] data) {
        this(packetType, GCCoreUtil.getDimensionID((World)world), Arrays.asList(data));
    }

    public GSPacketSimple(GSEnumSimplePacket packetType, int dimID, List<Object> data) {
        super(dimID);
        if (packetType.getDecodeClasses().length != data.size()) {
            GCLog.info((String)"Simple Packet Core found data length different than packet type");
            new RuntimeException().printStackTrace();
        }
        this.type = packetType;
        this.data = data;
    }

    public void encodeInto(ByteBuf buffer) {
        super.encodeInto(buffer);
        buffer.writeInt(this.type.ordinal());
        try {
            NetworkUtil.encodeData((ByteBuf)buffer, this.data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void decodeInto(ByteBuf buffer) {
        super.decodeInto(buffer);
        this.type = GSEnumSimplePacket.values()[buffer.readInt()];
        try {
            if (this.type.getDecodeClasses().length > 0) {
                this.data = NetworkUtil.decodeData((Class[])this.type.getDecodeClasses(), (ByteBuf)buffer);
            }
            if (buffer.readableBytes() > 0) {
                GCLog.severe((String)("Galacticraft packet length problem for packet type " + this.type.toString()));
            }
        }
        catch (Exception e) {
            System.err.println("[Galacticraft] Error handling simple packet type: " + this.type.toString() + " " + buffer.toString());
            e.printStackTrace();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer player) {
        EntityPlayerSP playerBaseClient = null;
        GCPlayerStatsClient stats = null;
        StatsCapability gs_stats = null;
        StatsCapabilityClient gs_stats_client = null;
        if (player instanceof EntityPlayerSP) {
            playerBaseClient = (EntityPlayerSP)player;
            stats = GCPlayerStatsClient.get((Entity)playerBaseClient);
            gs_stats = GSStatsCapability.get((Entity)player);
            gs_stats_client = GSStatsCapabilityClient.get((Entity)playerBaseClient);
        }
        switch (this.type) {
            case C_GLOW_BLOCK: {
                BlockVec3 block = (BlockVec3)this.data.get(0);
                int level = (Integer)this.data.get(1);
                GlStateManager.func_179094_E();
                FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(new ResourceLocation("galacticraftplanets", "textures/misc/gradient.png"));
                GlStateManager.func_179140_f();
                GlStateManager.func_179129_p();
                GlStateManager.func_179118_c();
                GlStateManager.func_179132_a((boolean)false);
                GlStateManager.func_179112_b((int)770, (int)1);
                GlStateManager.func_179147_l();
                GlStateManager.func_179109_b((float)block.x, (float)block.y, (float)block.z);
                Tessellator tess = Tessellator.func_178181_a();
                BufferBuilder worldRenderer = tess.func_178180_c();
                GlStateManager.func_179131_c((float)1.0f, (float)0.7f, (float)0.7f, (float)(0.016667f * (float)(12 - level)));
                float cA = -0.01f;
                float cB = 1.01f;
                worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                worldRenderer.func_181662_b((double)cA, (double)cB, (double)cA).func_187315_a(0.0, 1.0).func_181675_d();
                worldRenderer.func_181662_b((double)cB, (double)cB, (double)cA).func_187315_a(1.0, 1.0).func_181675_d();
                worldRenderer.func_181662_b((double)cB, (double)cB, (double)cB).func_187315_a(1.0, 0.0).func_181675_d();
                worldRenderer.func_181662_b((double)cA, (double)cB, (double)cB).func_187315_a(0.0, 0.0).func_181675_d();
                tess.func_78381_a();
                worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                worldRenderer.func_181662_b((double)cA, (double)cA, (double)cA).func_187315_a(0.0, 0.0).func_181675_d();
                worldRenderer.func_181662_b((double)cA, (double)cA, (double)cB).func_187315_a(0.0, 1.0).func_181675_d();
                worldRenderer.func_181662_b((double)cB, (double)cA, (double)cB).func_187315_a(1.0, 1.0).func_181675_d();
                worldRenderer.func_181662_b((double)cB, (double)cA, (double)cA).func_187315_a(1.0, 0.0).func_181675_d();
                tess.func_78381_a();
                worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                worldRenderer.func_181662_b((double)cA, (double)cA, (double)cA).func_187315_a(1.0, 0.0).func_181675_d();
                worldRenderer.func_181662_b((double)cA, (double)cB, (double)cA).func_187315_a(0.0, 0.0).func_181675_d();
                worldRenderer.func_181662_b((double)cA, (double)cB, (double)cB).func_187315_a(0.0, 1.0).func_181675_d();
                worldRenderer.func_181662_b((double)cA, (double)cA, (double)cB).func_187315_a(1.0, 1.0).func_181675_d();
                tess.func_78381_a();
                worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                worldRenderer.func_181662_b((double)cB, (double)cA, (double)cA).func_187315_a(1.0, 1.0).func_181675_d();
                worldRenderer.func_181662_b((double)cB, (double)cA, (double)cB).func_187315_a(1.0, 0.0).func_181675_d();
                worldRenderer.func_181662_b((double)cB, (double)cB, (double)cB).func_187315_a(0.0, 0.0).func_181675_d();
                worldRenderer.func_181662_b((double)cB, (double)cB, (double)cA).func_187315_a(0.0, 1.0).func_181675_d();
                tess.func_78381_a();
                worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                worldRenderer.func_181662_b((double)cA, (double)cA, (double)cA).func_187315_a(1.0, 0.0).func_181675_d();
                worldRenderer.func_181662_b(1.0, (double)cA, (double)cA).func_187315_a(0.0, 0.0).func_181675_d();
                worldRenderer.func_181662_b(1.0, 1.0, (double)cA).func_187315_a(0.0, 1.0).func_181675_d();
                worldRenderer.func_181662_b((double)cA, 1.0, (double)cA).func_187315_a(1.0, 1.0).func_181675_d();
                tess.func_78381_a();
                worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                worldRenderer.func_181662_b(1.0, (double)cA, 1.0).func_187315_a(1.0, 1.0).func_181675_d();
                worldRenderer.func_181662_b((double)cA, (double)cA, 1.0).func_187315_a(1.0, 0.0).func_181675_d();
                worldRenderer.func_181662_b((double)cA, 1.0, 1.0).func_187315_a(0.0, 0.0).func_181675_d();
                worldRenderer.func_181662_b(1.0, 1.0, 1.0).func_187315_a(0.0, 1.0).func_181675_d();
                tess.func_78381_a();
                GlStateManager.func_179121_F();
                break;
            }
            case C_UPDATE_WORLD: {
                WorldServer world;
                MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
                if (server == null || playerBaseClient == null || (world = server.func_71218_a(this.getDimensionID())) == null || playerBaseClient.field_70170_p == null || !(playerBaseClient.field_70170_p.field_73011_w instanceof WE_WorldProvider) || world.field_73011_w == null || !(world.field_73011_w instanceof WE_WorldProvider)) break;
                ((WE_WorldProvider)playerBaseClient.field_70170_p.field_73011_w).chunk_provider = ((WE_WorldProvider)world.field_73011_w).chunk_provider;
                break;
            }
            case C_UPDATE_RESEARCHES: {
                if (gs_stats_client == null) break;
                int i = 0;
                for (Object o : this.data) {
                    gs_stats_client.setKnowledgeResearch(i++, (Integer)o);
                }
                break;
            }
            case C_UPDATE_RESEARCH: {
                int id = (Integer)this.data.get(0);
                int count = (Integer)this.data.get(1);
                if (gs_stats_client == null) break;
                gs_stats_client.setKnowledgeResearch(id, count);
                break;
            }
        }
    }

    public void handleServerSide(EntityPlayer player) {
        EntityPlayerMP playerBase = PlayerUtil.getPlayerBaseServerFromPlayer((EntityPlayer)player, (boolean)false);
        if (playerBase == null) {
            return;
        }
        GCPlayerStats stats = GCPlayerStats.get((Entity)playerBase);
        switch (this.type) {
            case S_CHANGE_FLIGHT_STATE: {
                boolean state = (Boolean)this.data.get(0);
                GSEventHandler.enableFlight(player, state);
                break;
            }
            case S_GRAVITY_RADIUS: {
                BlockVec3 pos = (BlockVec3)this.data.get(0);
                int strength = (Integer)this.data.get(1);
                TileEntity tileEntity = pos.getTileEntity((IBlockAccess)playerBase.field_70170_p);
                if (!(tileEntity instanceof TileEntityGravitationModule)) break;
                ((TileEntityGravitationModule)tileEntity).setGravityRadius(strength);
                tileEntity.func_70296_d();
                break;
            }
            case S_ON_ADVANCED_GUI_CLICKED_INT: {
                TileEntity tile1 = player.field_70170_p.func_175625_s(new BlockPos(((Integer)this.data.get(1)).intValue(), ((Integer)this.data.get(2)).intValue(), ((Integer)this.data.get(3)).intValue()));
                switch ((Integer)this.data.get(0)) {
                    case 6: {
                        if (!(tile1 instanceof ITileEffects)) break;
                        ITileEffects distributor = (ITileEffects)tile1;
                        distributor.setEffectsVisible((Integer)this.data.get(4) == 1);
                    }
                }
                break;
            }
            case S_REVERSE_SEPATATOR: {
                BlockVec3 posSep = (BlockVec3)this.data.get(0);
                TileEntity tileEntity = posSep.getTileEntity((IBlockAccess)playerBase.field_70170_p);
                if (!(tileEntity instanceof TileEntityLiquidSeparator)) break;
                ((TileEntityLiquidSeparator)tileEntity).setReverse(!((TileEntityLiquidSeparator)tileEntity).getReverse());
                tileEntity.func_70296_d();
                playerBase.field_70170_p.func_184138_a(tileEntity.func_174877_v(), tileEntity.func_145838_q().func_176223_P(), tileEntity.func_145838_q().func_176223_P(), 0);
                break;
            }
            case S_UPDATE_NBT_ITEM_ON_GUI: {
                ItemStack[] copied;
                BlockVec3 position = (BlockVec3)this.data.get(0);
                String tag = (String)this.data.get(1);
                boolean turn = false;
                boolean consumed = false;
                TileEntity tileEntity = position.getTileEntity((IBlockAccess)playerBase.field_70170_p);
                if (!(tileEntity instanceof TileEntityModificationTable)) break;
                ItemStack[] stack = ((TileEntityModificationTable)tileEntity).func_70301_a(0);
                boolean check = true;
                ItemModule get_module = null;
                if (stack.func_77973_b() instanceof IModificationItem) {
                    for (ItemModule module : ((IModificationItem)stack.func_77973_b()).getAvailableModules()) {
                        if (!module.getName().equals(tag)) continue;
                        get_module = module;
                        break;
                    }
                }
                if (get_module == null) break;
                if (get_module.getForrbidenModules() != null) {
                    for (ItemModule forb_module : get_module.getForrbidenModules()) {
                        if (!stack.func_77978_p().func_74764_b(forb_module.getName())) continue;
                        check = false;
                        break;
                    }
                }
                if (!stack.func_77978_p().func_74764_b(tag) || !stack.func_77978_p().func_74767_n(tag)) {
                    turn = true;
                } else if (stack.func_77978_p().func_74764_b(tag)) {
                    turn = false;
                }
                if (turn) {
                    if (!check || stack.func_77978_p().func_74762_e(ItemSpaceSuit.mod_count) <= 0) break;
                    for (Object con : get_module.getItemsForModule()) {
                        consumed = GSEventHandler.consumeItemStack((IInventory)playerBase.field_71071_by, con);
                    }
                    if (!consumed && !playerBase.field_71075_bZ.field_75098_d) break;
                    copied = stack;
                    copied.func_77978_p().func_74757_a(tag, true);
                    copied.func_77978_p().func_74768_a(ItemSpaceSuit.mod_count, copied.func_77978_p().func_74762_e(ItemSpaceSuit.mod_count) - 1);
                    ((TileEntityModificationTable)tileEntity).func_70299_a(0, (ItemStack)copied);
                    tileEntity.func_70296_d();
                    playerBase.field_70170_p.func_175684_a(tileEntity.func_174877_v(), tileEntity.func_145838_q(), 0);
                    break;
                }
                if (!playerBase.field_71075_bZ.field_75098_d) {
                    for (Object con : get_module.getItemsForModule()) {
                        playerBase.func_191521_c(con);
                    }
                }
                copied = stack;
                copied.func_77978_p().func_82580_o(tag);
                copied.func_77978_p().func_74768_a(ItemSpaceSuit.mod_count, copied.func_77978_p().func_74762_e(ItemSpaceSuit.mod_count) + 1);
                ((TileEntityModificationTable)tileEntity).func_70299_a(0, (ItemStack)copied);
                tileEntity.func_70296_d();
                playerBase.field_70170_p.func_175684_a(tileEntity.func_174877_v(), tileEntity.func_145838_q(), 0);
                break;
            }
            case S_UPDATE_NBT_ITEM_IN_ARMOR: {
                int armor_slot = (Integer)this.data.get(0);
                String tag = (String)this.data.get(1);
                ItemStack armor = (ItemStack)playerBase.field_71071_by.field_70460_b.get(armor_slot);
                if (armor == ItemStack.field_190927_a || !(armor.func_77973_b() instanceof ItemSpaceSuit)) break;
                ItemStack copied = armor;
                copied.func_77978_p().func_74757_a(tag, !copied.func_77978_p().func_74767_n(tag));
                playerBase.field_71071_by.field_70460_b.set(armor_slot, (Object)copied);
                break;
            }
        }
    }

    public void func_148837_a(PacketBuffer var1) {
        this.decodeInto((ByteBuf)var1);
    }

    public void func_148840_b(PacketBuffer var1) {
        this.encodeInto((ByteBuf)var1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_148833_a(INetHandler var1) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            this.handleClientSide((EntityPlayer)FMLClientHandler.instance().getClientPlayerEntity());
        }
    }

    public static enum GSEnumSimplePacket {
        S_GRAVITY_RADIUS(Side.SERVER, BlockVec3.class, Integer.class),
        S_ON_ADVANCED_GUI_CLICKED_INT(Side.SERVER, Integer.class, Integer.class, Integer.class, Integer.class, Integer.class),
        S_CHANGE_FLIGHT_STATE(Side.SERVER, Boolean.class),
        S_REVERSE_SEPATATOR(Side.SERVER, BlockVec3.class),
        S_UPDATE_NBT_ITEM_ON_GUI(Side.SERVER, BlockVec3.class, String.class),
        S_UPDATE_NBT_ITEM_IN_ARMOR(Side.SERVER, Integer.class, String.class),
        C_UPDATE_WORLD(Side.CLIENT, new Class[0]),
        C_UPDATE_RESEARCHES(Side.CLIENT, Integer[].class),
        C_UPDATE_RESEARCH(Side.CLIENT, Integer.class, Integer.class),
        C_GLOW_BLOCK(Side.CLIENT, BlockVec3.class, Integer.class);

        private Side targetSide;
        private Class<?>[] decodeAs;

        private GSEnumSimplePacket(Side targetSide, Class<?> ... decodeAs) {
            this.targetSide = targetSide;
            this.decodeAs = decodeAs;
        }

        public Side getTargetSide() {
            return this.targetSide;
        }

        public Class<?>[] getDecodeClasses() {
            return this.decodeAs;
        }
    }
}

