/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.core.data;

import WayofTime.bloodmagic.core.data.BMWorldSavedData;
import WayofTime.bloodmagic.core.data.SoulTicket;
import WayofTime.bloodmagic.event.SoulNetworkEvent;
import WayofTime.bloodmagic.util.BMLog;
import WayofTime.bloodmagic.util.BooleanResult;
import WayofTime.bloodmagic.util.DamageSourceBloodMagic;
import WayofTime.bloodmagic.util.helper.PlayerHelper;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.common.eventhandler.Event;

public class SoulNetwork
implements INBTSerializable<NBTTagCompound> {
    private final Queue<SoulTicket> ticketHistory = EvictingQueue.create((int)16);
    private BMWorldSavedData parent;
    private EntityPlayer cachedPlayer;
    private UUID playerId;
    private int currentEssence;
    private int orbTier;

    private SoulNetwork() {
    }

    public void clear() {
        this.ticketHistory.clear();
    }

    public int add(SoulTicket ticket, int maximum) {
        SoulNetworkEvent.Fill event = new SoulNetworkEvent.Fill(this, ticket, maximum);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return 0;
        }
        int currEss = this.getCurrentEssence();
        if (currEss >= event.getMaximum()) {
            return 0;
        }
        int newEss = Math.min(event.getMaximum(), currEss + event.getTicket().getAmount());
        this.setCurrentEssence(newEss);
        if (this.ticketHistory.contains(ticket)) {
            this.ticketHistory.remove(ticket);
        }
        this.ticketHistory.add(ticket);
        return newEss - currEss;
    }

    @Deprecated
    public int add(int toAdd, int maximum) {
        return this.add(new SoulTicket(toAdd), maximum);
    }

    @Deprecated
    public int addLifeEssence(int toAdd, int maximum) {
        return this.add(toAdd, maximum);
    }

    public int syphon(SoulTicket ticket) {
        return this.syphon(ticket, false);
    }

    public int syphon(SoulTicket ticket, boolean skipEvent) {
        SoulNetworkEvent.Syphon event = new SoulNetworkEvent.Syphon(this, ticket);
        if (!skipEvent && MinecraftForge.EVENT_BUS.post((Event)event)) {
            return 0;
        }
        int syphon = event.getTicket().getAmount();
        if (this.getCurrentEssence() >= syphon) {
            this.setCurrentEssence(this.getCurrentEssence() - syphon);
            if (this.ticketHistory.contains(ticket)) {
                this.ticketHistory.remove(ticket);
            }
            this.ticketHistory.add(ticket);
            return syphon;
        }
        return 0;
    }

    @Deprecated
    public int syphon(int amount) {
        return this.syphon(new SoulTicket(amount));
    }

    public BooleanResult<Integer> syphonAndDamage(EntityPlayer user, SoulTicket ticket) {
        if (user.func_130014_f_().field_72995_K) {
            return BooleanResult.newResult(false, 0);
        }
        SoulNetworkEvent.Syphon.User event = new SoulNetworkEvent.Syphon.User(this, ticket, user);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return BooleanResult.newResult(false, 0);
        }
        int drainAmount = this.syphon(event.getTicket(), true);
        if (drainAmount <= 0 || event.shouldDamage()) {
            this.hurtPlayer(user, event.getTicket().getAmount());
        }
        if (this.ticketHistory.contains(ticket)) {
            this.ticketHistory.remove(ticket);
        }
        this.ticketHistory.add(ticket);
        return BooleanResult.newResult(true, event.getTicket().getAmount());
    }

    @Deprecated
    public boolean syphonAndDamage(EntityPlayer user, int amount) {
        return this.syphonAndDamage(user, new SoulTicket(amount)).isSuccess();
    }

    public void causeNausea() {
        if (this.getPlayer() != null) {
            this.getPlayer().func_70690_d(new PotionEffect(MobEffects.field_76431_k, 99));
        }
    }

    @Deprecated
    public void causeNauseaToPlayer() {
        this.causeNausea();
    }

    public void hurtPlayer(EntityPlayer user, float syphon) {
        if (user != null) {
            if (syphon < 100.0f && syphon > 0.0f) {
                if (!user.field_71075_bZ.field_75098_d) {
                    user.field_70172_ad = 0;
                    user.func_70097_a((DamageSource)DamageSourceBloodMagic.INSTANCE, 1.0f);
                }
            } else if (syphon >= 100.0f && !user.field_71075_bZ.field_75098_d) {
                int i = 0;
                while ((float)i < (syphon + 99.0f) / 100.0f) {
                    user.field_70172_ad = 0;
                    user.func_70097_a((DamageSource)DamageSourceBloodMagic.INSTANCE, 1.0f);
                    ++i;
                }
            }
        }
    }

    private void markDirty() {
        if (this.getParent() != null) {
            this.getParent().func_76185_a();
        } else {
            BMLog.DEFAULT.error("A SoulNetwork was created, but a parent was not set to allow saving.", new Object[0]);
        }
    }

    @Nullable
    public EntityPlayer getPlayer() {
        if (this.cachedPlayer == null) {
            this.cachedPlayer = PlayerHelper.getPlayerFromUUID(this.playerId);
        }
        return this.cachedPlayer;
    }

    public BMWorldSavedData getParent() {
        return this.parent;
    }

    public SoulNetwork setParent(BMWorldSavedData parent) {
        this.parent = parent;
        this.markDirty();
        return this;
    }

    public EntityPlayer getCachedPlayer() {
        return this.cachedPlayer;
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public int getCurrentEssence() {
        return this.currentEssence;
    }

    public SoulNetwork setCurrentEssence(int currentEssence) {
        this.currentEssence = currentEssence;
        this.markDirty();
        return this;
    }

    public int getOrbTier() {
        return this.orbTier;
    }

    public SoulNetwork setOrbTier(int orbTier) {
        this.orbTier = orbTier;
        this.markDirty();
        return this;
    }

    public List<SoulTicket> getTicketHistory() {
        return ImmutableList.copyOf(this.ticketHistory);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74778_a("playerId", this.getPlayerId().toString());
        tagCompound.func_74768_a("currentEssence", this.getCurrentEssence());
        tagCompound.func_74768_a("orbTier", this.getOrbTier());
        return tagCompound;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.playerId = UUID.fromString(nbt.func_74779_i("playerId"));
        this.currentEssence = nbt.func_74762_e("currentEssence");
        this.orbTier = nbt.func_74762_e("orbTier");
    }

    public static SoulNetwork fromNBT(NBTTagCompound tagCompound) {
        SoulNetwork soulNetwork = new SoulNetwork();
        soulNetwork.deserializeNBT(tagCompound);
        return soulNetwork;
    }

    public static SoulNetwork newEmpty(UUID uuid) {
        SoulNetwork network = new SoulNetwork();
        network.playerId = uuid;
        return network;
    }
}

