/*
 * Decompiled with CFR 0.152.
 */
package nc.gui.element;

import javax.annotation.Nonnull;
import nc.gui.element.GuiItemRenderer;
import nc.gui.element.NCButton;
import nc.tile.ITile;
import nc.tile.fluid.ITileFluid;
import nc.tile.internal.fluid.TankOutputSetting;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public abstract class NCToggleButton
extends NCButton {
    public NCToggleButton(int id, int x, int y, int width, int height, boolean pressed) {
        super(id, x, y, width, height);
        this.isButtonPressed = pressed;
    }

    @Override
    public boolean mousePressed(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        boolean clicked;
        boolean bl = clicked = mouseButton == 0 && this.field_146124_l && this.field_146125_m && mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
        if (clicked) {
            this.isButtonPressed = !this.isButtonPressed;
        }
        return clicked;
    }

    @Override
    public void func_146118_a(int mouseX, int mouseY) {
    }

    @SideOnly(value=Side.CLIENT)
    public static class RedstoneControl
    extends Image {
        public RedstoneControl(int id, int x, int y, ITile machine) {
            super(id, x, y, 72, 0, 18, 18, machine.getRedstoneControl());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class AlternateComparator
    extends Image {
        public AlternateComparator(int id, int x, int y, ITile machine) {
            super(id, x, y, 54, 0, 18, 18, machine.getAlternateComparator());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class VoidExcessFluidOutput
    extends Image {
        public VoidExcessFluidOutput(int id, int x, int y, ITileFluid machine, int tankNumber) {
            super(id, x, y, 36, 0, 18, 18, machine.getTankOutputSetting(tankNumber) != TankOutputSetting.DEFAULT);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class VoidUnusableFluidInput
    extends Image {
        public VoidUnusableFluidInput(int id, int x, int y, ITileFluid machine, int tankNumber) {
            super(id, x, y, 18, 0, 18, 18, machine.getVoidUnusableFluidInput(tankNumber));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class InputTanksSeparated
    extends Image {
        public InputTanksSeparated(int id, int x, int y, ITileFluid machine) {
            super(id, x, y, 0, 0, 18, 18, machine.getInputTanksSeparated());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class Item
    extends NCToggleButton {
        protected int field_146120_f;
        protected int field_146121_g;
        protected GuiItemRenderer unpressedItemRenderer;
        protected GuiItemRenderer pressedItemRenderer;

        public Item(int id, int x, int y, int width, int height, float unpressedAlph, @Nonnull net.minecraft.item.Item unpressedItem, int unpressedItemMeta, float pressedAlph, @Nonnull net.minecraft.item.Item pressedItem, int pressedItemMeta, boolean pressed) {
            super(id, x, y, width, height, pressed);
            this.field_146120_f = width;
            this.field_146121_g = height;
            this.unpressedItemRenderer = new GuiItemRenderer(x + (width - 16) / 2, y + (height - 16) / 2, unpressedAlph, unpressedItem, unpressedItemMeta);
            this.pressedItemRenderer = new GuiItemRenderer(x + (width - 16) / 2, y + (height - 16) / 2, pressedAlph, pressedItem, pressedItemMeta);
        }

        public GuiItemRenderer getItemRenderer() {
            if (this.isButtonPressed) {
                return this.pressedItemRenderer;
            }
            return this.unpressedItemRenderer;
        }

        public void func_191745_a(Minecraft minecraft, int x, int y, float partialTicks) {
            if (this.field_146125_m) {
                this.field_146123_n = x >= this.field_146128_h && y >= this.field_146129_i && x < this.field_146128_h + this.field_146120_f && y < this.field_146129_i + this.field_146121_g;
                this.getItemRenderer().draw();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static abstract class Image
    extends NCToggleButton {
        public final ResourceLocation unpressedTexture = new ResourceLocation("nuclearcraft:textures/gui/buttons/off.png");
        public final ResourceLocation pressedTexture = new ResourceLocation("nuclearcraft:textures/gui/buttons/on.png");
        protected int textureX;
        protected int textureY;
        protected int textureWidth;
        protected int textureHeight;

        public Image(int id, int x, int y, int textureX, int textureY, int textureWidth, int textureHeight, boolean pressed) {
            super(id, x, y, textureWidth, textureHeight, pressed);
            this.textureX = textureX;
            this.textureY = textureY;
            this.textureWidth = textureWidth;
            this.textureHeight = textureHeight;
        }

        public void func_191745_a(Minecraft minecraft, int x, int y, float partialTicks) {
            if (this.field_146125_m) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146123_n = x >= this.field_146128_h && y >= this.field_146129_i && x < this.field_146128_h + this.field_146120_f && y < this.field_146129_i + this.field_146121_g;
                minecraft.func_110434_K().func_110577_a(this.getTexture());
                this.func_73729_b(this.field_146128_h, this.field_146129_i, this.textureX, this.textureY, this.textureWidth, this.textureHeight);
            }
        }

        public ResourceLocation getTexture() {
            if (this.isButtonPressed) {
                return this.pressedTexture;
            }
            return this.unpressedTexture;
        }
    }
}

