/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.turbine;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import nc.config.NCConfig;
import nc.handler.SoundHandler;
import nc.init.NCSounds;
import nc.multiblock.IMultiblockFluid;
import nc.multiblock.IMultiblockPart;
import nc.multiblock.MultiblockBase;
import nc.multiblock.TileBeefBase;
import nc.multiblock.container.ContainerTurbineController;
import nc.multiblock.cuboidal.CuboidalMultiblockBase;
import nc.multiblock.network.TurbineRenderPacket;
import nc.multiblock.network.TurbineUpdatePacket;
import nc.multiblock.turbine.TurbineRotorBladeUtil;
import nc.multiblock.turbine.block.BlockTurbineRotorShaft;
import nc.multiblock.turbine.tile.TileTurbineController;
import nc.multiblock.turbine.tile.TileTurbineDynamoCoil;
import nc.multiblock.turbine.tile.TileTurbineInlet;
import nc.multiblock.turbine.tile.TileTurbineOutlet;
import nc.multiblock.turbine.tile.TileTurbinePartBase;
import nc.multiblock.turbine.tile.TileTurbineRotorBearing;
import nc.multiblock.turbine.tile.TileTurbineRotorBlade;
import nc.multiblock.turbine.tile.TileTurbineRotorShaft;
import nc.multiblock.turbine.tile.TileTurbineRotorStator;
import nc.multiblock.validation.IMultiblockValidator;
import nc.network.PacketHandler;
import nc.recipe.NCRecipes;
import nc.recipe.ProcessorRecipe;
import nc.recipe.ProcessorRecipeHandler;
import nc.recipe.RecipeInfo;
import nc.recipe.ingredient.IFluidIngredient;
import nc.tile.internal.energy.EnergyStorage;
import nc.tile.internal.fluid.Tank;
import nc.util.MaterialHelper;
import nc.util.NCUtil;
import nc.util.SoundHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Turbine
extends CuboidalMultiblockBase<TurbineUpdatePacket>
implements IMultiblockFluid {
    protected Set<TileTurbineController> controllers;
    protected Set<TileTurbineRotorShaft> rotorShafts;
    protected Set<TileTurbineRotorBlade> rotorBlades;
    protected Set<TileTurbineRotorStator> rotorStators;
    protected Set<TileTurbineRotorBearing> rotorBearings;
    protected Set<TileTurbineDynamoCoil> dynamoCoils;
    protected Set<TileTurbineInlet> inlets;
    protected Set<TileTurbineOutlet> outlets;
    protected TileTurbineController controller;
    public final EnergyStorage energyStorage;
    public final List<Tank> tanks;
    protected static final int BASE_MAX_ENERGY = 64000;
    protected static final int BASE_MAX_INPUT = 4000;
    protected static final int BASE_MAX_OUTPUT = 16000;
    public static final ProcessorRecipeHandler RECIPE_HANDLER = NCRecipes.turbine;
    protected RecipeInfo<ProcessorRecipe> recipeInfo;
    protected int updateCount = 0;
    public boolean isTurbineOn;
    public boolean computerActivated;
    public boolean isProcessing;
    public double power = 0.0;
    public double rawConductivity = 0.0;
    protected double rawPower = 0.0;
    public EnumFacing flowDir = null;
    public int shaftWidth = 0;
    public int inertia = 0;
    public int bladeLength = 0;
    public int noBladeSets = 0;
    public int recipeRate = 0;
    public double totalExpansionLevel = 1.0;
    public double idealTotalExpansionLevel = 1.0;
    public double basePowerPerMB = 0.0;
    public List<Double> expansionLevels = new ArrayList<Double>();
    public List<Double> rawBladeEfficiencies = new ArrayList<Double>();
    protected int dynamoCoilCheckCount = 0;
    @SideOnly(value=Side.CLIENT)
    protected List<SoundHandler.SoundInfo> activeSounds;
    protected int soundCount = this.rand.nextInt(20);
    protected boolean refreshSoundInfo = true;
    protected float prevAngVel = 0.0f;
    public float angVel = 0.0f;
    public float rotorAngle = 0.0f;
    public long prevRenderTime = 0L;
    protected Iterable<BlockPos.MutableBlockPos>[] inputPlane = new Iterable[4];
    private static final ArrayList<String> STAGE_0_COILS = Lists.newArrayList((Object[])new String[]{"magnesium"});
    private static final ArrayList<String> STAGE_1_COILS = Lists.newArrayList((Object[])new String[]{"beryllium"});
    private static final ArrayList<String> STAGE_2_COILS = Lists.newArrayList((Object[])new String[]{"gold"});
    private static final ArrayList<String> STAGE_3_COILS = Lists.newArrayList((Object[])new String[]{"copper", "silver"});
    private static final ArrayList<String> STAGE_4_COILS = Lists.newArrayList((Object[])new String[]{"aluminum"});

    public Turbine(World world) {
        super(world);
        this.controllers = new ObjectOpenHashSet();
        this.rotorShafts = new ObjectOpenHashSet();
        this.rotorBlades = new ObjectOpenHashSet();
        this.rotorStators = new ObjectOpenHashSet();
        this.rotorBearings = new ObjectOpenHashSet();
        this.dynamoCoils = new ObjectOpenHashSet();
        this.inlets = new ObjectOpenHashSet();
        this.outlets = new ObjectOpenHashSet();
        this.energyStorage = new EnergyStorage(64000);
        this.tanks = Lists.newArrayList((Object[])new Tank[]{new Tank(4000, NCRecipes.turbine_valid_fluids.get(0)), new Tank(16000, null)});
    }

    public Set<TileTurbineController> getControllers() {
        return this.controllers;
    }

    public Set<TileTurbineRotorShaft> getRotorShafts() {
        return this.rotorShafts;
    }

    public Set<TileTurbineRotorBlade> getRotorBlades() {
        return this.rotorBlades;
    }

    public Set<TileTurbineRotorStator> getRotorStators() {
        return this.rotorStators;
    }

    public Set<TileTurbineRotorBearing> getRotorBearings() {
        return this.rotorBearings;
    }

    public Set<TileTurbineDynamoCoil> getDynamoCoils() {
        return this.dynamoCoils;
    }

    public Set<TileTurbineInlet> getInlets() {
        return this.inlets;
    }

    public Set<TileTurbineOutlet> getOutlets() {
        return this.outlets;
    }

    @Override
    protected int getMinimumInteriorLength() {
        return NCConfig.turbine_min_size;
    }

    @Override
    protected int getMaximumInteriorLength() {
        return NCConfig.turbine_max_size;
    }

    @Override
    public void onAttachedPartWithMultiblockData(IMultiblockPart part, NBTTagCompound data) {
        this.syncDataFrom(data, TileBeefBase.SyncReason.FullSync);
    }

    @Override
    protected void onBlockAdded(IMultiblockPart newPart) {
        if (newPart instanceof TileTurbineController) {
            this.controllers.add((TileTurbineController)newPart);
        }
        if (newPart instanceof TileTurbineRotorShaft) {
            this.rotorShafts.add((TileTurbineRotorShaft)newPart);
        }
        if (newPart instanceof TileTurbineRotorBlade) {
            this.rotorBlades.add((TileTurbineRotorBlade)newPart);
        }
        if (newPart instanceof TileTurbineRotorStator) {
            this.rotorStators.add((TileTurbineRotorStator)newPart);
        }
        if (newPart instanceof TileTurbineRotorBearing) {
            this.rotorBearings.add((TileTurbineRotorBearing)newPart);
        }
        if (newPart instanceof TileTurbineDynamoCoil) {
            this.dynamoCoils.add((TileTurbineDynamoCoil)newPart);
        }
        if (newPart instanceof TileTurbineInlet) {
            this.inlets.add((TileTurbineInlet)newPart);
        }
        if (newPart instanceof TileTurbineOutlet) {
            this.outlets.add((TileTurbineOutlet)newPart);
        }
    }

    @Override
    protected void onBlockRemoved(IMultiblockPart oldPart) {
        if (oldPart instanceof TileTurbineController) {
            this.controllers.remove(oldPart);
        }
        if (oldPart instanceof TileTurbineRotorShaft) {
            this.rotorShafts.remove(oldPart);
        }
        if (oldPart instanceof TileTurbineRotorBlade) {
            this.rotorBlades.remove(oldPart);
        }
        if (oldPart instanceof TileTurbineRotorStator) {
            this.rotorStators.remove(oldPart);
        }
        if (oldPart instanceof TileTurbineRotorBearing) {
            this.rotorBearings.remove(oldPart);
        }
        if (oldPart instanceof TileTurbineDynamoCoil) {
            this.dynamoCoils.remove(oldPart);
        }
        if (oldPart instanceof TileTurbineInlet) {
            this.inlets.remove(oldPart);
        }
        if (oldPart instanceof TileTurbineOutlet) {
            this.outlets.remove(oldPart);
        }
    }

    @Override
    protected void onMachineAssembled() {
        Iterator<TileTurbineController> iterator = this.controllers.iterator();
        while (iterator.hasNext()) {
            TileTurbineController contr;
            this.controller = contr = iterator.next();
        }
        this.onTurbineFormed();
    }

    @Override
    protected void onMachineRestored() {
        this.onTurbineFormed();
    }

    protected void onTurbineFormed() {
        IBlockState state;
        BlockPos pos;
        this.setIsTurbineOn();
        this.energyStorage.setStorageCapacity(64000 * this.getNumConnectedBlocks());
        this.energyStorage.setMaxTransfer(64000 * this.getNumConnectedBlocks());
        this.tanks.get(0).setCapacity(4000 * this.getNumConnectedBlocks());
        this.tanks.get(1).setCapacity(16000 * this.getNumConnectedBlocks());
        this.inputPlane[0] = this.getInteriorPlane(this.flowDir.func_176734_d(), 0, 0, 0, this.bladeLength, this.shaftWidth + this.bladeLength);
        this.inputPlane[1] = this.getInteriorPlane(this.flowDir.func_176734_d(), 0, this.shaftWidth + this.bladeLength, 0, 0, this.bladeLength);
        this.inputPlane[2] = this.getInteriorPlane(this.flowDir.func_176734_d(), 0, this.bladeLength, this.shaftWidth + this.bladeLength, 0, 0);
        this.inputPlane[3] = this.getInteriorPlane(this.flowDir.func_176734_d(), 0, 0, this.bladeLength, this.shaftWidth + this.bladeLength, 0);
        this.doDynamoCoilPlacementChecks();
        for (TileTurbineRotorShaft rotorShaft : this.rotorShafts) {
            pos = rotorShaft.func_174877_v();
            state = this.WORLD.func_180495_p(pos);
            if (!(state.func_177230_c() instanceof BlockTurbineRotorShaft)) continue;
            this.WORLD.func_175656_a(pos, state.func_177226_a(TurbineRotorBladeUtil.DIR, (Comparable)((Object)TurbineRotorBladeUtil.TurbinePartDir.INVISIBLE)));
        }
        for (TileTurbineRotorBlade rotorBlade : this.rotorBlades) {
            pos = rotorBlade.bladePos();
            state = this.WORLD.func_180495_p(pos);
            if (!(state.func_177230_c() instanceof TurbineRotorBladeUtil.IBlockRotorBlade)) continue;
            this.WORLD.func_175656_a(pos, state.func_177226_a(TurbineRotorBladeUtil.DIR, (Comparable)((Object)TurbineRotorBladeUtil.TurbinePartDir.INVISIBLE)));
        }
        for (TileTurbineRotorStator rotorStator : this.rotorStators) {
            pos = rotorStator.bladePos();
            state = this.WORLD.func_180495_p(pos);
            if (!(state.func_177230_c() instanceof TurbineRotorBladeUtil.IBlockRotorBlade)) continue;
            this.WORLD.func_175656_a(pos, state.func_177226_a(TurbineRotorBladeUtil.DIR, (Comparable)((Object)TurbineRotorBladeUtil.TurbinePartDir.INVISIBLE)));
        }
    }

    protected void doDynamoCoilPlacementChecks() {
        if (this.dynamoCoils.size() < 1) {
            this.rawConductivity = 0.0;
        }
        for (TileTurbineDynamoCoil dynamoCoil : this.dynamoCoils) {
            dynamoCoil.isInValidPosition = false;
            dynamoCoil.checked = false;
        }
        double newConductivity = 0.0;
        for (int i = 0; i <= 4; ++i) {
            for (TileTurbineDynamoCoil dynamoCoil : this.dynamoCoils) {
                this.dynamoCoilCheckCount = i;
                if (dynamoCoil.checked) continue;
                newConductivity += dynamoCoil.contributeConductivity(this.dynamoCoilCheckCount);
            }
        }
        this.rawConductivity = newConductivity / (double)this.dynamoCoils.size();
    }

    @Override
    protected void onMachinePaused() {
    }

    @Override
    protected void onMachineDisassembled() {
        if (this.flowDir != null) {
            IBlockState state;
            BlockPos pos;
            TurbineRotorBladeUtil.TurbinePartDir shaftDir = this.getShaftDir();
            for (TileTurbineRotorShaft rotorShaft : this.rotorShafts) {
                pos = rotorShaft.func_174877_v();
                state = this.WORLD.func_180495_p(pos);
                if (!(state.func_177230_c() instanceof BlockTurbineRotorShaft)) continue;
                this.WORLD.func_175656_a(pos, state.func_177226_a(TurbineRotorBladeUtil.DIR, (Comparable)((Object)shaftDir)));
            }
            for (TileTurbineRotorBlade rotorBlade : this.rotorBlades) {
                pos = rotorBlade.bladePos();
                state = this.WORLD.func_180495_p(pos);
                if (!(state.func_177230_c() instanceof TurbineRotorBladeUtil.IBlockRotorBlade)) continue;
                this.WORLD.func_175656_a(pos, state.func_177226_a(TurbineRotorBladeUtil.DIR, (Comparable)((Object)rotorBlade.getDir())));
            }
            for (TileTurbineRotorStator rotorStator : this.rotorStators) {
                pos = rotorStator.bladePos();
                state = this.WORLD.func_180495_p(pos);
                if (!(state.func_177230_c() instanceof TurbineRotorBladeUtil.IBlockRotorBlade)) continue;
                this.WORLD.func_175656_a(pos, state.func_177226_a(TurbineRotorBladeUtil.DIR, (Comparable)((Object)rotorStator.getDir())));
            }
        }
        this.isProcessing = false;
        this.isTurbineOn = false;
        if (this.controller != null) {
            this.controller.updateBlockState(false);
        }
        this.rawConductivity = 0.0;
        this.rawPower = 0.0;
        this.power = 0.0;
        this.rotorAngle = 0.0f;
        this.angVel = 0.0f;
        this.flowDir = null;
        this.recipeRate = 0;
        this.noBladeSets = 0;
        this.bladeLength = 0;
        this.inertia = 0;
        this.shaftWidth = 0;
        this.idealTotalExpansionLevel = 1.0;
        this.totalExpansionLevel = 1.0;
        this.basePowerPerMB = 0.0;
        this.expansionLevels = new ArrayList<Double>();
        this.rawBladeEfficiencies = new ArrayList<Double>();
        this.inputPlane[3] = null;
        this.inputPlane[2] = null;
        this.inputPlane[1] = null;
        this.inputPlane[0] = null;
        if (this.WORLD.field_72995_K) {
            this.updateSounds();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean isMachineWhole(IMultiblockValidator validatorCallback) {
        void var21_35;
        void var21_33;
        Object pos;
        if (this.controllers.size() == 0) {
            validatorCallback.setLastError("nuclearcraft.multiblock_validation.no_controller", null, new Object[0]);
            return false;
        }
        if (this.controllers.size() > 1) {
            validatorCallback.setLastError("nuclearcraft.multiblock_validation.too_many_controllers", null, new Object[0]);
            return false;
        }
        if (!super.isMachineWhole(validatorCallback)) {
            return false;
        }
        int minX = this.getMinX();
        int minY = this.getMinY();
        int minZ = this.getMinZ();
        int maxX = this.getMaxX();
        int maxY = this.getMaxY();
        int maxZ = this.getMaxZ();
        boolean dirMinX = false;
        boolean dirMaxX = false;
        boolean dirMinY = false;
        boolean dirMaxY = false;
        boolean dirMinZ = false;
        boolean dirMaxZ = false;
        EnumFacing.Axis axis = null;
        boolean tooManyAxes = false;
        boolean notInAWall = false;
        for (TileTurbineRotorBearing rotorBearing : this.rotorBearings) {
            BlockPos pos2 = rotorBearing.func_174877_v();
            if (pos2.func_177958_n() == minX) {
                dirMinX = true;
                continue;
            }
            if (pos2.func_177958_n() == maxX) {
                dirMaxX = true;
                continue;
            }
            if (pos2.func_177956_o() == minY) {
                dirMinY = true;
                continue;
            }
            if (pos2.func_177956_o() == maxY) {
                dirMaxY = true;
                continue;
            }
            if (pos2.func_177952_p() == minZ) {
                dirMinZ = true;
                continue;
            }
            if (pos2.func_177952_p() == maxZ) {
                dirMaxZ = true;
                continue;
            }
            notInAWall = true;
        }
        if (dirMinX && dirMaxX) {
            axis = EnumFacing.Axis.X;
        }
        if (dirMinY && dirMaxY) {
            if (axis != null) {
                tooManyAxes = true;
            } else {
                axis = EnumFacing.Axis.Y;
            }
        }
        if (dirMinZ && dirMaxZ) {
            if (axis != null) {
                tooManyAxes = true;
            } else {
                axis = EnumFacing.Axis.Z;
            }
        }
        if (axis == null) {
            validatorCallback.setLastError("nuclearcraft.multiblock_validation.turbine.need_bearings", null, new Object[0]);
            return false;
        }
        if (axis == EnumFacing.Axis.X && this.getInteriorLengthY() != this.getInteriorLengthZ() || axis == EnumFacing.Axis.Y && this.getInteriorLengthZ() != this.getInteriorLengthX() || axis == EnumFacing.Axis.Z && this.getInteriorLengthX() != this.getInteriorLengthY() || tooManyAxes || notInAWall) {
            validatorCallback.setLastError("nuclearcraft.multiblock_validation.turbine.bearings_side_square", null, new Object[0]);
            return false;
        }
        int internalDiameter = axis == EnumFacing.Axis.X ? this.getInteriorLengthY() : (axis == EnumFacing.Axis.Y ? this.getInteriorLengthZ() : this.getInteriorLengthX());
        boolean isEvenDiameter = internalDiameter % 2 == 0;
        boolean validAmountOfBearings = false;
        int n = this.shaftWidth = isEvenDiameter ? 2 : 1;
        while (this.shaftWidth <= internalDiameter - 2) {
            if (this.rotorBearings.size() == 2 * this.shaftWidth * this.shaftWidth) {
                validAmountOfBearings = true;
                break;
            }
            this.shaftWidth += 2;
        }
        if (!validAmountOfBearings) {
            validatorCallback.setLastError("nuclearcraft.multiblock_validation.turbine.bearings_centre_and_square", null, new Object[0]);
            return false;
        }
        this.bladeLength = (internalDiameter - this.shaftWidth) / 2;
        for (BlockPos blockPos : this.getInteriorPlane(EnumFacing.func_181076_a((EnumFacing.AxisDirection)EnumFacing.AxisDirection.NEGATIVE, (EnumFacing.Axis)axis), -1, this.bladeLength, this.bladeLength, this.bladeLength, this.bladeLength)) {
            if (this.WORLD.func_175625_s(blockPos) instanceof TileTurbineRotorBearing) continue;
            validatorCallback.setLastError("nuclearcraft.multiblock_validation.turbine.bearings_centre_and_square", blockPos, new Object[0]);
            return false;
        }
        for (BlockPos blockPos : this.getInteriorPlane(EnumFacing.func_181076_a((EnumFacing.AxisDirection)EnumFacing.AxisDirection.POSITIVE, (EnumFacing.Axis)axis), -1, this.bladeLength, this.bladeLength, this.bladeLength, this.bladeLength)) {
            if (this.WORLD.func_175625_s(blockPos) instanceof TileTurbineRotorBearing) continue;
            validatorCallback.setLastError("nuclearcraft.multiblock_validation.turbine.bearings_centre_and_square", blockPos, new Object[0]);
            return false;
        }
        this.flowDir = null;
        if (this.inlets.size() == 0 || this.outlets.size() == 0) {
            validatorCallback.setLastError("nuclearcraft.multiblock_validation.turbine.valve_wrong_wall", null, new Object[0]);
            return false;
        }
        for (TileTurbineInlet tileTurbineInlet : this.inlets) {
            pos = tileTurbineInlet.func_174877_v();
            if (this.isInMinWall(axis, (BlockPos)pos)) {
                EnumFacing enumFacing = EnumFacing.func_181076_a((EnumFacing.AxisDirection)EnumFacing.AxisDirection.POSITIVE, (EnumFacing.Axis)axis);
                if (this.flowDir != null && this.flowDir != enumFacing) {
                    validatorCallback.setLastError("nuclearcraft.multiblock_validation.turbine.valve_wrong_wall", (BlockPos)pos, new Object[0]);
                    return false;
                }
                this.flowDir = enumFacing;
                continue;
            }
            if (this.isInMaxWall(axis, (BlockPos)pos)) {
                EnumFacing enumFacing = EnumFacing.func_181076_a((EnumFacing.AxisDirection)EnumFacing.AxisDirection.NEGATIVE, (EnumFacing.Axis)axis);
                if (this.flowDir != null && this.flowDir != enumFacing) {
                    validatorCallback.setLastError("nuclearcraft.multiblock_validation.turbine.valve_wrong_wall", (BlockPos)pos, new Object[0]);
                    return false;
                }
                this.flowDir = enumFacing;
                continue;
            }
            validatorCallback.setLastError("nuclearcraft.multiblock_validation.turbine.valve_wrong_wall", (BlockPos)pos, new Object[0]);
            return false;
        }
        if (this.flowDir == null) {
            validatorCallback.setLastError("nuclearcraft.multiblock_validation.turbine.valve_wrong_wall", null, new Object[0]);
            return false;
        }
        for (TileTurbineOutlet tileTurbineOutlet : this.outlets) {
            pos = tileTurbineOutlet.func_174877_v();
            if (this.isInWall(this.flowDir, (BlockPos)pos)) continue;
            validatorCallback.setLastError("nuclearcraft.multiblock_validation.turbine.valve_wrong_wall", (BlockPos)pos, new Object[0]);
            return false;
        }
        int flowLength = this.getFlowLength();
        boolean bl = false;
        while (var21_33 < flowLength) {
            for (BlockPos blockPos : this.getInteriorPlane(EnumFacing.func_181076_a((EnumFacing.AxisDirection)EnumFacing.AxisDirection.POSITIVE, (EnumFacing.Axis)axis), (int)var21_33, this.bladeLength, this.bladeLength, this.bladeLength, this.bladeLength)) {
                TileEntity tileEntity = this.WORLD.func_175625_s(blockPos);
                if (tileEntity instanceof TileTurbineRotorShaft) {
                    ((TileTurbineRotorShaft)tileEntity).render = true;
                    ((TileTurbineRotorShaft)tileEntity).depth = var21_33;
                    continue;
                }
                validatorCallback.setLastError("nuclearcraft.multiblock_validation.turbine.shaft_centre", blockPos, new Object[0]);
                return false;
            }
            ++var21_33;
        }
        this.inertia = this.shaftWidth * (this.shaftWidth + 4 * this.bladeLength) * flowLength;
        this.noBladeSets = 0;
        this.totalExpansionLevel = 1.0;
        this.expansionLevels = new ArrayList<Double>();
        this.rawBladeEfficiencies = new ArrayList<Double>();
        boolean bl2 = false;
        while (var21_35 < flowLength) {
            TurbineRotorBladeUtil.IRotorBladeType thisBladeType;
            TurbineRotorBladeUtil.ITurbineRotorBlade thisBlade;
            for (BlockPos blockPos : this.getInteriorPlane(this.flowDir, (int)var21_35, 0, 0, this.shaftWidth + this.bladeLength, this.shaftWidth + this.bladeLength)) {
                if (!MaterialHelper.isReplaceable(this.WORLD.func_180495_p(blockPos).func_185904_a())) {
                    validatorCallback.setLastError("nuclearcraft.multiblock_validation.turbine.space_between_blades", blockPos, new Object[0]);
                    return false;
                }
                this.WORLD.func_175656_a(blockPos, Blocks.field_150350_a.func_176223_P());
            }
            for (BlockPos blockPos : this.getInteriorPlane(this.flowDir, (int)var21_35, this.shaftWidth + this.bladeLength, 0, 0, this.shaftWidth + this.bladeLength)) {
                if (!MaterialHelper.isReplaceable(this.WORLD.func_180495_p(blockPos).func_185904_a())) {
                    validatorCallback.setLastError("nuclearcraft.multiblock_validation.turbine.space_between_blades", blockPos, new Object[0]);
                    return false;
                }
                this.WORLD.func_175656_a(blockPos, Blocks.field_150350_a.func_176223_P());
            }
            for (BlockPos blockPos : this.getInteriorPlane(this.flowDir, (int)var21_35, 0, this.shaftWidth + this.bladeLength, this.shaftWidth + this.bladeLength, 0)) {
                if (!MaterialHelper.isReplaceable(this.WORLD.func_180495_p(blockPos).func_185904_a())) {
                    validatorCallback.setLastError("nuclearcraft.multiblock_validation.turbine.space_between_blades", blockPos, new Object[0]);
                    return false;
                }
                this.WORLD.func_175656_a(blockPos, Blocks.field_150350_a.func_176223_P());
            }
            for (BlockPos blockPos : this.getInteriorPlane(this.flowDir, (int)var21_35, this.shaftWidth + this.bladeLength, this.shaftWidth + this.bladeLength, 0, 0)) {
                if (!MaterialHelper.isReplaceable(this.WORLD.func_180495_p(blockPos).func_185904_a())) {
                    validatorCallback.setLastError("nuclearcraft.multiblock_validation.turbine.space_between_blades", blockPos, new Object[0]);
                    return false;
                }
                this.WORLD.func_175656_a(blockPos, Blocks.field_150350_a.func_176223_P());
            }
            TurbineRotorBladeUtil.IRotorBladeType currentBladeType = null;
            for (BlockPos blockPos : this.getInteriorPlane(this.flowDir.func_176734_d(), (int)var21_35, this.bladeLength, 0, this.bladeLength, this.shaftWidth + this.bladeLength)) {
                thisBlade = this.getBlade(blockPos);
                TurbineRotorBladeUtil.IRotorBladeType iRotorBladeType = thisBladeType = thisBlade == null ? null : thisBlade.getBladeType();
                if (thisBladeType == null) {
                    validatorCallback.setLastError("nuclearcraft.multiblock_validation.turbine.missing_blades", blockPos, new Object[0]);
                    return false;
                }
                if (currentBladeType == null) {
                    currentBladeType = thisBladeType;
                } else if (currentBladeType != thisBladeType) {
                    validatorCallback.setLastError("nuclearcraft.multiblock_validation.turbine.different_type_blades", blockPos, new Object[0]);
                    return false;
                }
                thisBlade.setDir(this.getBladeDir(PlaneDir.V));
                thisBlade.setDepth((int)var21_35);
                thisBlade.setRenderRotation(45.0f);
            }
            for (BlockPos blockPos : this.getInteriorPlane(this.flowDir.func_176734_d(), (int)var21_35, 0, this.bladeLength, this.shaftWidth + this.bladeLength, this.bladeLength)) {
                thisBlade = this.getBlade(blockPos);
                TurbineRotorBladeUtil.IRotorBladeType iRotorBladeType = thisBladeType = thisBlade == null ? null : thisBlade.getBladeType();
                if (thisBladeType == null) {
                    validatorCallback.setLastError("nuclearcraft.multiblock_validation.turbine.missing_blades", blockPos, new Object[0]);
                    return false;
                }
                if (currentBladeType != thisBladeType) {
                    validatorCallback.setLastError("nuclearcraft.multiblock_validation.turbine.different_type_blades", blockPos, new Object[0]);
                    return false;
                }
                thisBlade.setDir(this.getBladeDir(PlaneDir.U));
                thisBlade.setDepth((int)var21_35);
                thisBlade.setRenderRotation(this.flowDir.func_176740_k() == EnumFacing.Axis.Z ? -45.0f : 45.0f);
            }
            for (BlockPos blockPos : this.getInteriorPlane(this.flowDir.func_176734_d(), (int)var21_35, this.shaftWidth + this.bladeLength, this.bladeLength, 0, this.bladeLength)) {
                thisBlade = this.getBlade(blockPos);
                TurbineRotorBladeUtil.IRotorBladeType iRotorBladeType = thisBladeType = thisBlade == null ? null : thisBlade.getBladeType();
                if (thisBladeType == null) {
                    validatorCallback.setLastError("nuclearcraft.multiblock_validation.turbine.missing_blades", blockPos, new Object[0]);
                    return false;
                }
                if (currentBladeType != thisBladeType) {
                    validatorCallback.setLastError("nuclearcraft.multiblock_validation.turbine.different_type_blades", blockPos, new Object[0]);
                    return false;
                }
                thisBlade.setDir(this.getBladeDir(PlaneDir.U));
                thisBlade.setDepth((int)var21_35);
                thisBlade.setRenderRotation(this.flowDir.func_176740_k() == EnumFacing.Axis.Z ? 45.0f : -45.0f);
            }
            for (BlockPos blockPos : this.getInteriorPlane(this.flowDir.func_176734_d(), (int)var21_35, this.bladeLength, this.shaftWidth + this.bladeLength, this.bladeLength, 0)) {
                thisBlade = this.getBlade(blockPos);
                TurbineRotorBladeUtil.IRotorBladeType iRotorBladeType = thisBladeType = thisBlade == null ? null : thisBlade.getBladeType();
                if (thisBladeType == null) {
                    validatorCallback.setLastError("nuclearcraft.multiblock_validation.turbine.missing_blades", blockPos, new Object[0]);
                    return false;
                }
                if (currentBladeType != thisBladeType) {
                    validatorCallback.setLastError("nuclearcraft.multiblock_validation.turbine.different_type_blades", blockPos, new Object[0]);
                    return false;
                }
                thisBlade.setDir(this.getBladeDir(PlaneDir.V));
                thisBlade.setDepth((int)var21_35);
                thisBlade.setRenderRotation(-45.0f);
            }
            if (currentBladeType == null) {
                validatorCallback.setLastError("nuclearcraft.multiblock_validation.turbine.missing_blades", null, new Object[0]);
                return false;
            }
            double d = this.totalExpansionLevel;
            if (currentBladeType == TurbineRotorBladeUtil.TurbineRotorStatorType.STATOR) {
                this.totalExpansionLevel *= NCConfig.turbine_stator_expansion;
                this.expansionLevels.add((d + this.totalExpansionLevel) / 2.0);
                this.rawBladeEfficiencies.add(0.0);
            } else if (currentBladeType instanceof TurbineRotorBladeUtil.TurbineRotorBladeType) {
                this.totalExpansionLevel *= ((TurbineRotorBladeUtil.TurbineRotorBladeType)currentBladeType).getExpansionCoefficient();
                this.expansionLevels.add((d + this.totalExpansionLevel) / 2.0);
                this.rawBladeEfficiencies.add(((TurbineRotorBladeUtil.TurbineRotorBladeType)currentBladeType).getEfficiency());
                ++this.noBladeSets;
            }
            ++var21_35;
        }
        if (!NCUtil.areEqual(this.getFlowLength(), this.expansionLevels.size(), this.rawBladeEfficiencies.size())) {
            validatorCallback.setLastError("nuclearcraft.multiblock_validation.turbine.missing_blades", null, new Object[0]);
            return false;
        }
        for (TileTurbineController controller : this.controllers) {
            controller.isRenderer = false;
        }
        Iterator<TileTurbineController> iterator = this.controllers.iterator();
        if (iterator.hasNext()) {
            TileTurbineController controller;
            controller = iterator.next();
            controller.isRenderer = true;
        }
        if (this.shaftWidth > 2) {
            void var21_39;
            boolean bl3 = false;
            while (var21_39 < flowLength) {
                for (BlockPos blockPos : this.getInteriorPlane(this.flowDir, (int)var21_39, this.bladeLength + 1, this.bladeLength + 1, this.bladeLength + 1, this.bladeLength + 1)) {
                    TileEntity tileEntity = this.WORLD.func_175625_s(blockPos);
                    if (!(tileEntity instanceof TileTurbineRotorShaft)) continue;
                    ((TileTurbineRotorShaft)tileEntity).render = false;
                }
                ++var21_39;
            }
        }
        return true;
    }

    protected TurbineRotorBladeUtil.ITurbineRotorBlade getBlade(BlockPos pos) {
        TileEntity tile = this.WORLD.func_175625_s(pos);
        return tile instanceof TurbineRotorBladeUtil.ITurbineRotorBlade ? (TurbineRotorBladeUtil.ITurbineRotorBlade)tile : null;
    }

    public TurbineRotorBladeUtil.TurbinePartDir getShaftDir() {
        switch (this.flowDir.func_176740_k()) {
            case Y: {
                return TurbineRotorBladeUtil.TurbinePartDir.Y;
            }
            case Z: {
                return TurbineRotorBladeUtil.TurbinePartDir.Z;
            }
            case X: {
                return TurbineRotorBladeUtil.TurbinePartDir.X;
            }
        }
        return TurbineRotorBladeUtil.TurbinePartDir.Y;
    }

    protected TurbineRotorBladeUtil.TurbinePartDir getBladeDir(PlaneDir planeDir) {
        switch (this.flowDir.func_176740_k()) {
            case Y: {
                switch (planeDir) {
                    case U: {
                        return TurbineRotorBladeUtil.TurbinePartDir.Z;
                    }
                    case V: {
                        return TurbineRotorBladeUtil.TurbinePartDir.X;
                    }
                }
            }
            case Z: {
                switch (planeDir) {
                    case U: {
                        return TurbineRotorBladeUtil.TurbinePartDir.X;
                    }
                    case V: {
                        return TurbineRotorBladeUtil.TurbinePartDir.Y;
                    }
                }
            }
            case X: {
                switch (planeDir) {
                    case U: {
                        return TurbineRotorBladeUtil.TurbinePartDir.Y;
                    }
                    case V: {
                        return TurbineRotorBladeUtil.TurbinePartDir.Z;
                    }
                }
            }
        }
        return TurbineRotorBladeUtil.TurbinePartDir.Y;
    }

    public int getFlowLength() {
        return this.getInteriorLength(this.flowDir);
    }

    protected int getBladeVolume() {
        return 4 * this.shaftWidth * this.bladeLength * this.noBladeSets;
    }

    public double getRotorRadius() {
        return (double)this.bladeLength + (double)this.shaftWidth / 2.0;
    }

    @Override
    protected void onAssimilate(MultiblockBase assimilated) {
    }

    @Override
    protected void onAssimilated(MultiblockBase assimilator) {
    }

    @Override
    protected boolean updateServer() {
        this.updateTurbine();
        if (this.shouldUpdate()) {
            this.sendUpdateToListeningPlayers();
        }
        this.incrementUpdateCount();
        return true;
    }

    public void setIsTurbineOn() {
        boolean oldIsTurbineOn = this.isTurbineOn;
        boolean bl = this.isTurbineOn = (this.isRedstonePowered() || this.computerActivated) && this.isAssembled();
        if (this.isTurbineOn != oldIsTurbineOn) {
            if (this.controller != null) {
                this.controller.updateBlockState(this.isTurbineOn);
            }
            this.sendUpdateToAllPlayers();
        }
    }

    protected boolean isRedstonePowered() {
        return this.controller != null && this.controller.checkIsRedstonePowered(this.WORLD, this.controller.func_174877_v());
    }

    protected void updateTurbine() {
        if (this.shouldUpdate()) {
            boolean wasProcessing = this.isProcessing;
            this.refreshRecipe();
            double previousRawPower = this.rawPower;
            double rawMaxPower = this.getRawMaxProcessPower();
            if (this.canProcessInputs()) {
                this.isProcessing = true;
                this.produceProducts();
                this.rawPower = this.getNewRawProcessPower(previousRawPower, rawMaxPower, true);
            } else {
                this.isProcessing = false;
                this.rawPower = this.getNewRawProcessPower(previousRawPower, rawMaxPower, false);
            }
            this.power = this.rawPower * this.getEffectiveConductivity();
            float f = this.angVel = rawMaxPower == 0.0 ? 0.0f : (float)(0.5 * this.rawPower / rawMaxPower);
            if (wasProcessing != this.isProcessing) {
                this.sendUpdateToAllPlayers();
            }
        }
        this.energyStorage.changeEnergyStored((int)this.power);
        PacketHandler.instance.sendToAll((IMessage)this.getRenderPacket());
    }

    protected void refreshRecipe() {
        this.recipeInfo = RECIPE_HANDLER.getRecipeInfoFromInputs(new ArrayList<ItemStack>(), this.tanks.subList(0, 1));
    }

    protected boolean canProcessInputs() {
        if (!this.isTurbineOn || !this.setRecipeStats()) {
            return false;
        }
        return this.canProduceProducts();
    }

    protected boolean setRecipeStats() {
        if (this.recipeInfo == null) {
            this.recipeRate = 0;
            this.basePowerPerMB = 0.0;
            this.idealTotalExpansionLevel = 1.0;
            return false;
        }
        this.basePowerPerMB = this.recipeInfo.getRecipe().getTurbinePowerPerMB();
        this.idealTotalExpansionLevel = this.recipeInfo.getRecipe().getTurbineExpansionLevel();
        return true;
    }

    protected boolean canProduceProducts() {
        IFluidIngredient fluidProduct = this.recipeInfo.getRecipe().fluidProducts().get(0);
        if (fluidProduct.getMaxStackSize(0) <= 0 || fluidProduct.getStack() == null) {
            return false;
        }
        this.recipeRate = Math.min(this.tanks.get(0).getFluidAmount(), this.getMaxRecipeRateMultiplier() * Turbine.updateTime());
        if (!this.tanks.get(1).isEmpty()) {
            if (!this.tanks.get(1).getFluid().isFluidEqual((FluidStack)fluidProduct.getStack())) {
                return false;
            }
            if (this.tanks.get(1).getFluidAmount() + fluidProduct.getMaxStackSize(0) * this.recipeRate > this.tanks.get(1).getCapacity()) {
                return false;
            }
        }
        return true;
    }

    public void produceProducts() {
        IFluidIngredient fluidProduct;
        int fluidIngredientStackSize = this.recipeInfo.getRecipe().fluidIngredients().get(0).getMaxStackSize(this.recipeInfo.getFluidIngredientNumbers().get(0)) * this.recipeRate;
        if (fluidIngredientStackSize > 0) {
            this.tanks.get(0).changeFluidAmount(-fluidIngredientStackSize);
        }
        if (this.tanks.get(0).getFluidAmount() <= 0) {
            this.tanks.get(0).setFluidStored(null);
        }
        if ((fluidProduct = this.recipeInfo.getRecipe().fluidProducts().get(0)).getMaxStackSize(0) <= 0) {
            return;
        }
        if (this.tanks.get(1).isEmpty()) {
            this.tanks.get(1).setFluidStored(fluidProduct.getNextStack(0));
            this.tanks.get(1).setFluidAmount(this.tanks.get(1).getFluidAmount() * this.recipeRate);
        } else if (this.tanks.get(1).getFluid().isFluidEqual((FluidStack)fluidProduct.getStack())) {
            this.tanks.get(1).changeFluidAmount(fluidProduct.getNextStackSize(0) * this.recipeRate);
        }
    }

    public int getMaxRecipeRateMultiplier() {
        return this.getBladeVolume() * NCConfig.turbine_mb_per_blade;
    }

    protected double getNewRawProcessPower(double previousRawPower, double maxRawPower, boolean increasing) {
        if (increasing) {
            return ((double)this.inertia * previousRawPower + maxRawPower) / ((double)this.inertia + 1.0);
        }
        return (double)this.inertia * previousRawPower / ((double)this.inertia + 2.0);
    }

    protected double getRawMaxProcessPower() {
        if (this.noBladeSets == 0) {
            return 0.0;
        }
        double bladeMultiplier = 0.0;
        for (int depth = 0; depth < this.getFlowLength(); ++depth) {
            if (this.rawBladeEfficiencies.get(depth) <= 0.0) continue;
            bladeMultiplier += this.rawBladeEfficiencies.get(depth) * Turbine.getExpansionIdealityMultiplier(this.getIdealExpansionLevel(depth), this.expansionLevels.get(depth));
        }
        return (bladeMultiplier /= (double)this.noBladeSets) * Turbine.getExpansionIdealityMultiplier(this.idealTotalExpansionLevel, this.totalExpansionLevel) * ((double)this.recipeRate / (double)Turbine.updateTime()) * this.basePowerPerMB;
    }

    protected static double getExpansionIdealityMultiplier(double ideal, double actual) {
        if (ideal <= 0.0 || actual <= 0.0) {
            return 0.0;
        }
        return ideal < actual ? ideal / actual : actual / ideal;
    }

    protected double getIdealExpansionLevel(int depth) {
        return Math.pow(this.idealTotalExpansionLevel, ((double)depth + 0.5) / (double)this.getFlowLength());
    }

    public List<Double> getIdealExpansionLevels() {
        ArrayList<Double> levels = new ArrayList<Double>();
        if (this.flowDir == null) {
            return levels;
        }
        for (int depth = 0; depth < this.getFlowLength(); ++depth) {
            levels.add(this.getIdealExpansionLevel(depth));
        }
        return levels;
    }

    public double getEffectiveConductivity() {
        if (this.rotorBearings.size() == 0 || this.dynamoCoils.size() == 0) {
            return 0.0;
        }
        return this.dynamoCoils.size() >= this.rotorBearings.size() ? this.rawConductivity : this.rawConductivity * (double)this.dynamoCoils.size() / (double)this.rotorBearings.size();
    }

    public int getActualInputRate() {
        return Math.round((float)this.recipeRate / (float)Turbine.updateTime());
    }

    protected void incrementUpdateCount() {
        ++this.updateCount;
        this.updateCount %= Turbine.updateTime();
    }

    protected static int updateTime() {
        return NCConfig.machine_update_rate / 4;
    }

    protected boolean shouldUpdate() {
        return this.updateCount == 0;
    }

    @Override
    protected void updateClient() {
        this.updateParticles();
        this.updateSounds();
    }

    @SideOnly(value=Side.CLIENT)
    private void updateParticles() {
        if (this.isProcessing && this.isAssembled() && !Minecraft.func_71410_x().func_147113_T()) {
            double speedY;
            double speedX;
            double flowSpeed = (double)this.getFlowLength() / 23.2;
            double offsetX = this.particleSpeedOffest();
            double offsetY = this.particleSpeedOffest();
            double offsetZ = this.particleSpeedOffest();
            double d = this.flowDir == EnumFacing.WEST ? -flowSpeed : (speedX = this.flowDir == EnumFacing.EAST ? flowSpeed : offsetX);
            double d2 = this.flowDir == EnumFacing.DOWN ? -flowSpeed : (speedY = this.flowDir == EnumFacing.UP ? flowSpeed : offsetY);
            double speedZ = this.flowDir == EnumFacing.NORTH ? -flowSpeed : (this.flowDir == EnumFacing.SOUTH ? flowSpeed : offsetZ);
            for (Iterable<BlockPos.MutableBlockPos> iter : this.inputPlane) {
                if (iter == null) continue;
                for (BlockPos blockPos : iter) {
                    double[] spawnPos;
                    if (!(this.rand.nextDouble() < 0.075 * (double)this.recipeRate / (double)(this.getMaxRecipeRateMultiplier() * Turbine.updateTime())) || (spawnPos = this.particleSpawnPos(blockPos)) == null) continue;
                    this.WORLD.func_175682_a(EnumParticleTypes.CLOUD, false, spawnPos[0], spawnPos[1], spawnPos[2], speedX, speedY, speedZ, new int[0]);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected double particleSpeedOffest() {
        return (this.rand.nextDouble() - 0.5) / (double)this.getFlowLength();
    }

    @SideOnly(value=Side.CLIENT)
    protected double[] particleSpawnPos(BlockPos pos) {
        double offsetU = 0.5 + (this.rand.nextDouble() - 0.5) / 2.0;
        double offsetV = 0.5 + (this.rand.nextDouble() - 0.5) / 2.0;
        switch (this.flowDir) {
            case DOWN: {
                return new double[]{(double)pos.func_177958_n() + offsetV, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + offsetU};
            }
            case UP: {
                return new double[]{(double)pos.func_177958_n() + offsetV, pos.func_177956_o(), (double)pos.func_177952_p() + offsetU};
            }
            case NORTH: {
                return new double[]{(double)pos.func_177958_n() + offsetU, (double)pos.func_177956_o() + offsetV, (double)pos.func_177952_p() + 1.0};
            }
            case SOUTH: {
                return new double[]{(double)pos.func_177958_n() + offsetU, (double)pos.func_177956_o() + offsetV, pos.func_177952_p()};
            }
            case WEST: {
                return new double[]{(double)pos.func_177958_n() + 1.0, (double)pos.func_177956_o() + offsetU, (double)pos.func_177952_p() + offsetV};
            }
            case EAST: {
                return new double[]{pos.func_177958_n(), (double)pos.func_177956_o() + offsetU, (double)pos.func_177952_p() + offsetV};
            }
        }
        return new double[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()};
    }

    @SideOnly(value=Side.CLIENT)
    private void updateSounds() {
        if (!NCConfig.turbine_enable_sound) {
            return;
        }
        if (this.activeSounds == null) {
            this.activeSounds = new ArrayList<SoundHandler.SoundInfo>();
        }
        if (this.isProcessing && this.isAssembled()) {
            this.refreshSoundInfo = this.refreshSoundInfo || Math.abs(this.angVel - this.prevAngVel) > 0.025f;
            if (--this.soundCount > (this.refreshSoundInfo ? 93 : 0)) {
                return;
            }
            if (this.refreshSoundInfo) {
                int i;
                this.stopSounds();
                this.activeSounds.clear();
                int _x = 1 + this.getExteriorLengthX() / 8;
                int _y = 1 + this.getExteriorLengthY() / 8;
                int _z = 1 + this.getExteriorLengthZ() / 8;
                int[] xList = new int[_x];
                int[] yList = new int[_y];
                int[] zList = new int[_z];
                for (i = 0; i < _x; ++i) {
                    xList[i] = this.getMinimumCoord().func_177958_n() + (i + 1) * this.getExteriorLengthX() / (_x + 1);
                }
                for (int j = 0; j < _y; ++j) {
                    yList[j] = this.getMinimumCoord().func_177956_o() + (j + 1) * this.getExteriorLengthY() / (_y + 1);
                }
                for (int k = 0; k < _z; ++k) {
                    zList[k] = this.getMinimumCoord().func_177952_p() + (k + 1) * this.getExteriorLengthZ() / (_z + 1);
                }
                for (i = 0; i < _x; ++i) {
                    for (int j = 0; j < _y; ++j) {
                        for (int k = 0; k < _z; ++k) {
                            if (i != 0 && i != _x - 1 && j != 0 && j != _y - 1 && k != 0 && k != _z - 1) continue;
                            this.activeSounds.add(new SoundHandler.SoundInfo(null, new BlockPos(xList[i], yList[j], zList[k])));
                        }
                    }
                }
                this.refreshSoundInfo = false;
            }
            for (SoundHandler.SoundInfo activeSound : this.activeSounds) {
                if (activeSound == null || activeSound.sound != null && Minecraft.func_71410_x().func_147118_V().func_147692_c(activeSound.sound)) continue;
                NCUtil.getLogger().info((Object)Float.valueOf(this.angVel));
                activeSound.sound = SoundHandler.startTileSound(NCSounds.turbine_run, activeSound.pos, 0.125f + this.angVel * 0.5f, SoundHelper.getPitch(6.0f * this.angVel - 2.0f));
            }
            this.soundCount = 186;
            this.prevAngVel = this.angVel;
        } else {
            this.stopSounds();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void stopSounds() {
        for (SoundHandler.SoundInfo activeSound : this.activeSounds) {
            if (activeSound == null) continue;
            SoundHandler.stopTileSound(activeSound.pos);
            activeSound.sound = null;
        }
        this.soundCount = 0;
    }

    @Override
    protected void syncDataTo(NBTTagCompound data, TileBeefBase.SyncReason syncReason) {
        int i;
        this.energyStorage.writeToNBT(data);
        this.writeTanks(data);
        data.func_74757_a("isTurbineOn", this.isTurbineOn);
        data.func_74757_a("computerActivated", this.computerActivated);
        data.func_74780_a("power", this.power);
        data.func_74780_a("rawPower", this.rawPower);
        data.func_74780_a("rawConductivity", this.rawConductivity);
        data.func_74776_a("angVel", this.angVel);
        data.func_74768_a("flowDir", this.flowDir == null ? -1 : this.flowDir.func_176745_a());
        data.func_74768_a("shaftWidth", this.shaftWidth);
        data.func_74768_a("shaftVolume", this.inertia);
        data.func_74768_a("bladeLength", this.bladeLength);
        data.func_74768_a("noBladeSets", this.noBladeSets);
        data.func_74768_a("recipeRate", this.recipeRate);
        data.func_74780_a("totalExpansionLevel", this.totalExpansionLevel);
        data.func_74780_a("idealTotalExpansionLevel", this.idealTotalExpansionLevel);
        data.func_74780_a("basePowerPerMB", this.basePowerPerMB);
        data.func_74768_a("expansionLevelsSize", this.expansionLevels.size());
        for (i = 0; i < this.expansionLevels.size(); ++i) {
            data.func_74780_a("expansionLevels" + i, this.expansionLevels.get(i).doubleValue());
        }
        data.func_74768_a("rawBladeEfficienciesSize", this.rawBladeEfficiencies.size());
        for (i = 0; i < this.rawBladeEfficiencies.size(); ++i) {
            data.func_74780_a("rawBladeEfficiencies" + i, this.rawBladeEfficiencies.get(i).doubleValue());
        }
        data.func_74757_a("isProcessing", this.isProcessing);
    }

    @Override
    protected void syncDataFrom(NBTTagCompound data, TileBeefBase.SyncReason syncReason) {
        int i;
        this.energyStorage.readFromNBT(data);
        this.readTanks(data);
        this.isTurbineOn = data.func_74767_n("isTurbineOn");
        this.computerActivated = data.func_74767_n("computerActivated");
        this.power = data.func_74769_h("power");
        this.rawPower = data.func_74769_h("rawPower");
        this.rawConductivity = data.func_74769_h("rawConductivity");
        this.angVel = data.func_74760_g("angVel");
        this.flowDir = data.func_74762_e("flowDir") < 0 ? null : EnumFacing.field_82609_l[data.func_74762_e("flowDir")];
        this.shaftWidth = data.func_74762_e("shaftWidth");
        this.inertia = data.func_74762_e("shaftVolume");
        this.bladeLength = data.func_74762_e("bladeLength");
        this.noBladeSets = data.func_74762_e("noBladeSets");
        this.recipeRate = data.func_74762_e("recipeRate");
        this.totalExpansionLevel = data.func_74769_h("totalExpansionLevel");
        this.idealTotalExpansionLevel = data.func_74769_h("idealTotalExpansionLevel");
        this.basePowerPerMB = data.func_74769_h("basePowerPerMB");
        this.expansionLevels = new ArrayList<Double>();
        if (data.func_74764_b("expansionLevelsSize")) {
            for (i = 0; i < data.func_74762_e("expansionLevelsSize"); ++i) {
                this.expansionLevels.add(data.func_74769_h("expansionLevels" + i));
            }
        }
        this.rawBladeEfficiencies = new ArrayList<Double>();
        if (data.func_74764_b("rawBladeEfficienciesSize")) {
            for (i = 0; i < data.func_74762_e("rawBladeEfficienciesSize"); ++i) {
                this.rawBladeEfficiencies.add(data.func_74769_h("rawBladeEfficiencies" + i));
            }
        }
        this.isProcessing = data.func_74767_n("isProcessing");
    }

    protected NBTTagCompound writeTanks(NBTTagCompound nbt) {
        if (!this.tanks.isEmpty()) {
            for (int i = 0; i < this.tanks.size(); ++i) {
                nbt.func_74768_a("fluidAmount" + i, this.tanks.get(i).getFluidAmount());
                nbt.func_74778_a("fluidName" + i, this.tanks.get(i).getFluidName());
            }
        }
        return nbt;
    }

    protected void readTanks(NBTTagCompound nbt) {
        if (!this.tanks.isEmpty()) {
            for (int i = 0; i < this.tanks.size(); ++i) {
                if (nbt.func_74779_i("fluidName" + i).equals("nullFluid") || nbt.func_74762_e("fluidAmount" + i) == 0) {
                    this.tanks.get(i).setFluidStored(null);
                    continue;
                }
                this.tanks.get(i).setFluidStored(FluidRegistry.getFluid((String)nbt.func_74779_i("fluidName" + i)), nbt.func_74762_e("fluidAmount" + i));
            }
        }
    }

    @Override
    protected TurbineUpdatePacket getUpdatePacket() {
        return new TurbineUpdatePacket(this.controller.func_174877_v(), this.isTurbineOn, this.power, this.rawPower, this.rawConductivity, this.totalExpansionLevel, this.idealTotalExpansionLevel, this.shaftWidth, this.bladeLength, this.noBladeSets, this.energyStorage.getMaxEnergyStored(), this.energyStorage.getEnergyStored());
    }

    @Override
    public void onPacket(TurbineUpdatePacket message) {
        this.isTurbineOn = message.isTurbineOn;
        this.power = message.power;
        this.rawPower = message.rawPower;
        this.rawConductivity = message.rawConductivity;
        this.totalExpansionLevel = message.totalExpansionLevel;
        this.idealTotalExpansionLevel = message.idealTotalExpansionLevel;
        this.shaftWidth = message.shaftWidth;
        this.bladeLength = message.bladeLength;
        this.noBladeSets = message.noBladeSets;
        this.energyStorage.setStorageCapacity(message.capacity);
        this.energyStorage.setMaxTransfer(message.capacity);
        this.energyStorage.setEnergyStored(message.energy);
    }

    protected TurbineRenderPacket getRenderPacket() {
        return new TurbineRenderPacket(this.controller.func_174877_v(), this.angVel, this.isProcessing, this.recipeRate);
    }

    public void onRenderPacket(TurbineRenderPacket message) {
        this.angVel = message.angVel;
        boolean wasProcessing = this.isProcessing;
        this.isProcessing = message.isProcessing;
        this.refreshSoundInfo = this.refreshSoundInfo || wasProcessing != this.isProcessing;
        this.recipeRate = message.recipeRate;
    }

    public Container getContainer(EntityPlayer player) {
        return new ContainerTurbineController(player, this.controller);
    }

    @Override
    public void clearAllFluids() {
        for (Tank tank : this.tanks) {
            tank.setFluidStored(null);
        }
    }

    @Override
    protected boolean isBlockGoodForInterior(World world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        BlockPos pos = new BlockPos(x, y, z);
        if (MaterialHelper.isReplaceable(world.func_180495_p(pos).func_185904_a()) || world.func_175625_s(pos) instanceof TileTurbinePartBase) {
            return true;
        }
        return this.standardLastError(x, y, z, validatorCallback);
    }

    protected static enum PlaneDir {
        U,
        V;

    }
}

