/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.ingredient;

import java.util.ArrayList;
import java.util.List;
import nc.config.NCConfig;
import nc.recipe.IngredientMatchResult;
import nc.recipe.IngredientSorption;
import nc.recipe.ingredient.IItemIngredient;
import nc.util.NCMath;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;

public class ChanceItemIngredient
implements IItemIngredient {
    public IItemIngredient ingredient;
    public int chancePercent;
    public int minStackSize;
    public double meanStackSize;

    public ChanceItemIngredient(IItemIngredient ingredient, int chancePercent) {
        this(ingredient, chancePercent, 0);
    }

    public ChanceItemIngredient(IItemIngredient ingredient, int chancePercent, int minStackSize) {
        this.ingredient = ingredient;
        this.chancePercent = MathHelper.func_76125_a((int)chancePercent, (int)0, (int)100);
        this.minStackSize = MathHelper.func_76125_a((int)minStackSize, (int)0, (int)ingredient.getMaxStackSize(0));
        this.meanStackSize = (double)this.minStackSize + (double)(this.ingredient.getMaxStackSize(0) - this.minStackSize) * (double)this.chancePercent / 100.0;
    }

    @Override
    public ItemStack getStack() {
        return (ItemStack)this.ingredient.getStack();
    }

    @Override
    public String getIngredientName() {
        return this.ingredient.getIngredientName() + " [ " + this.chancePercent + "%, min: " + this.minStackSize + " ]";
    }

    @Override
    public String getIngredientNamesConcat() {
        return this.ingredient.getIngredientNamesConcat() + " [ " + this.chancePercent + "%, min: " + this.minStackSize + " ]";
    }

    @Override
    public int getMaxStackSize(int ingredientNumber) {
        return this.ingredient.getMaxStackSize(0);
    }

    @Override
    public void setMaxStackSize(int stackSize) {
        this.ingredient.setMaxStackSize(stackSize);
    }

    @Override
    public int getNextStackSize(int ingredientNumber) {
        return this.minStackSize + NCMath.getBinomial(this.getMaxStackSize(0) - this.minStackSize, this.chancePercent);
    }

    @Override
    public List<ItemStack> getInputStackList() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        for (ItemStack stack : this.ingredient.getInputStackList()) {
            for (int i = this.minStackSize; i <= this.getMaxStackSize(0); ++i) {
                if (i <= 0) continue;
                ItemStack newStack = stack.func_77946_l();
                newStack.func_190920_e(i);
                stackList.add(newStack);
            }
        }
        return stackList;
    }

    @Override
    public List<ItemStack> getOutputStackList() {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        for (int i = this.minStackSize; i <= this.getMaxStackSize(0); ++i) {
            if (i == 0) {
                if (!NCConfig.jei_chance_items_include_null) continue;
                stackList.add(null);
                continue;
            }
            ItemStack newStack = this.getStack().func_77946_l();
            newStack.func_190920_e(i);
            stackList.add(newStack);
        }
        return stackList;
    }

    @Override
    public IngredientMatchResult match(Object object, IngredientSorption sorption) {
        return this.ingredient.match(object, sorption);
    }

    @Override
    public boolean isValid() {
        return this.ingredient.isValid();
    }
}

