/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.render;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import it.zerono.mods.zerocore.lib.client.render.IVertexSource;
import it.zerono.mods.zerocore.lib.client.render.Vertex;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class Shape
implements IVertexSource {
    private final List<Vertex> _vertices;

    public Shape() {
        this(4);
    }

    public Shape(int initialSize) {
        this._vertices = Lists.newArrayListWithCapacity((int)initialSize);
    }

    public void addVertex(@Nonnull Vertex vertex) {
        this._vertices.add(vertex);
    }

    @Nonnull
    public ImmutableList<Vertex> getVertices() {
        return ImmutableList.copyOf(this._vertices);
    }

    public int getVerticesCount() {
        return this._vertices.size();
    }

    @Override
    public void uploadVertexData(@Nonnull BufferBuilder buffer) {
        for (Vertex vertex : this._vertices) {
            vertex.uploadVertexData(buffer);
        }
    }
}

