/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.jei.elventrade;

import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import vazkii.botania.client.core.handler.MiscellaneousIcons;
import vazkii.botania.client.integration.jei.elventrade.ElvenTradeRecipeWrapper;

public class ElvenTradeRecipeCategory
implements IRecipeCategory<ElvenTradeRecipeWrapper> {
    public static final String UID = "botania.elvenTrade";
    private final String localizedName = I18n.func_135052_a((String)"botania.nei.elvenTrade", (Object[])new Object[0]);
    private final IDrawable background;
    private final IDrawable overlay;

    public ElvenTradeRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(145, 95);
        this.overlay = guiHelper.createDrawable(new ResourceLocation("botania", "textures/gui/elvenTradeOverlay.png"), 0, 15, 140, 90);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        this.overlay.draw(minecraft, 0, 4);
        GlStateManager.func_179084_k();
        GlStateManager.func_179118_c();
        minecraft.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        TextureAtlasSprite sprite = MiscellaneousIcons.INSTANCE.alfPortalTex;
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder wr = tess.func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        int startX = 22;
        int startY = 25;
        int stopX = 70;
        int stopY = 73;
        wr.func_181662_b((double)startX, (double)startY, 0.0).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94206_g()).func_181675_d();
        wr.func_181662_b((double)startX, (double)stopY, 0.0).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94210_h()).func_181675_d();
        wr.func_181662_b((double)stopX, (double)stopY, 0.0).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94210_h()).func_181675_d();
        wr.func_181662_b((double)stopX, (double)startY, 0.0).func_187315_a((double)sprite.func_94212_f(), (double)sprite.func_94206_g()).func_181675_d();
        tess.func_78381_a();
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull ElvenTradeRecipeWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        int index = 0;
        int posX = 42;
        for (List o : ingredients.getInputs(VanillaTypes.ITEM)) {
            recipeLayout.getItemStacks().init(index, true, posX, 0);
            recipeLayout.getItemStacks().set(index, o);
            ++index;
            posX += 18;
        }
        for (int i = 0; i < ingredients.getOutputs(VanillaTypes.ITEM).size(); ++i) {
            List stacks = (List)ingredients.getOutputs(VanillaTypes.ITEM).get(i);
            recipeLayout.getItemStacks().init(index + i, false, 93 + i % 2 * 20, 41 + i / 2 * 20);
            recipeLayout.getItemStacks().set(index + i, stacks);
        }
    }

    @Nonnull
    public String getModName() {
        return "Botania";
    }
}

