/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.api.recipe.RecipeRuneAltar;
import vazkii.botania.client.core.handler.HUDHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileAltar;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.item.ModItems;

public class TileRuneAltar
extends TileSimpleInventory
implements IManaReceiver,
ITickable {
    private static final String TAG_MANA = "mana";
    private static final String TAG_MANA_TO_GET = "manaToGet";
    private static final int SET_KEEP_TICKS_EVENT = 0;
    private static final int SET_COOLDOWN_EVENT = 1;
    private static final int CRAFT_EFFECT_EVENT = 2;
    RecipeRuneAltar currentRecipe;
    public int manaToGet = 0;
    int mana = 0;
    int cooldown = 0;
    public int signal = 0;
    List<ItemStack> lastRecipe = null;
    int recipeKeepTicks = 0;

    public boolean addItem(@Nullable EntityPlayer player, ItemStack stack, @Nullable EnumHand hand) {
        if (this.cooldown > 0 || stack.func_77973_b() == ModItems.twigWand || stack.func_77973_b() == ModItems.lexicon) {
            return false;
        }
        if (stack.func_77973_b() == Item.func_150898_a((Block)ModBlocks.livingrock) && stack.func_77952_i() == 0) {
            if (!this.field_145850_b.field_72995_K) {
                ItemStack toSpawn = player != null && player.field_71075_bZ.field_75098_d ? stack.func_77946_l().func_77979_a(1) : stack.func_77979_a(1);
                EntityItem item = new EntityItem(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.5, (double)(this.func_174877_v().func_177956_o() + 1), (double)this.func_174877_v().func_177952_p() + 0.5, toSpawn);
                item.func_174867_a(40);
                item.field_70179_y = 0.0;
                item.field_70181_x = 0.0;
                item.field_70159_w = 0.0;
                this.field_145850_b.func_72838_d((Entity)item);
            }
            return true;
        }
        if (this.manaToGet != 0) {
            return false;
        }
        boolean did = false;
        for (int i = 0; i < this.getSizeInventory(); ++i) {
            if (!this.itemHandler.getStackInSlot(i).func_190926_b()) continue;
            did = true;
            ItemStack stackToAdd = stack.func_77946_l();
            stackToAdd.func_190920_e(1);
            this.itemHandler.setStackInSlot(i, stackToAdd);
            if (player != null && player.field_71075_bZ.field_75098_d) break;
            stack.func_190918_g(1);
            break;
        }
        if (did) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this.field_145850_b, this.field_174879_c);
        }
        return true;
    }

    public boolean func_145842_c(int id, int param) {
        switch (id) {
            case 0: {
                this.recipeKeepTicks = param;
                return true;
            }
            case 1: {
                this.cooldown = param;
                return true;
            }
            case 2: {
                if (this.field_145850_b.field_72995_K) {
                    for (int i = 0; i < 25; ++i) {
                        float red = (float)Math.random();
                        float green = (float)Math.random();
                        float blue = (float)Math.random();
                        Botania.proxy.sparkleFX((double)this.field_174879_c.func_177958_n() + 0.5 + Math.random() * 0.4 - 0.2, this.field_174879_c.func_177956_o() + 1, (double)this.field_174879_c.func_177952_p() + 0.5 + Math.random() * 0.4 - 0.2, red, green, blue, (float)Math.random(), 10);
                    }
                    this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), ModSounds.runeAltarCraft, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                }
                return true;
            }
        }
        return super.func_145842_c(id, param);
    }

    public void func_73660_a() {
        this.recieveMana(0);
        if (!this.field_145850_b.field_72995_K) {
            if (this.manaToGet == 0) {
                List items = this.field_145850_b.func_72872_a(EntityItem.class, new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 1, 1)));
                for (EntityItem item : items) {
                    if (item.field_70128_L || item.func_92059_d().func_190926_b() || item.func_92059_d().func_77973_b() == Item.func_150898_a((Block)ModBlocks.livingrock)) continue;
                    ItemStack stack = item.func_92059_d();
                    this.addItem(null, stack, null);
                }
            }
            int newSignal = 0;
            if (this.manaToGet > 0) {
                ++newSignal;
                if (this.mana >= this.manaToGet) {
                    ++newSignal;
                }
            }
            if (newSignal != this.signal) {
                this.signal = newSignal;
                this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c());
            }
            this.updateRecipe();
        } else {
            if (this.manaToGet > 0 && this.mana >= this.manaToGet && this.field_145850_b.field_73012_v.nextInt(20) == 0) {
                Vector3 vec = Vector3.fromTileEntityCenter(this);
                Vector3 endVec = vec.add(0.0, 2.5, 0.0);
                Botania.proxy.lightningFX(vec, endVec, 2.0f, 38027, 58583);
            }
            if (this.cooldown > 0) {
                Botania.proxy.wispFX((double)this.field_174879_c.func_177958_n() + Math.random(), (double)this.field_174879_c.func_177956_o() + 0.8, (double)this.field_174879_c.func_177952_p() + Math.random(), 0.2f, 0.2f, 0.2f, 0.2f, -0.025f);
            }
        }
        if (this.cooldown > 0) {
            --this.cooldown;
        }
        if (this.recipeKeepTicks > 0) {
            --this.recipeKeepTicks;
        } else {
            this.lastRecipe = null;
        }
    }

    public void updateRecipe() {
        int manaToGet;
        block4: {
            manaToGet = this.manaToGet;
            if (this.currentRecipe != null) {
                this.manaToGet = this.currentRecipe.getManaUsage();
            } else {
                for (RecipeRuneAltar recipe : BotaniaAPI.runeAltarRecipes) {
                    if (!recipe.matches((IItemHandler)this.itemHandler)) continue;
                    this.manaToGet = recipe.getManaUsage();
                    break block4;
                }
                this.manaToGet = 0;
            }
        }
        if (manaToGet != this.manaToGet) {
            this.field_145850_b.func_184133_a(null, this.field_174879_c, ModSounds.runeAltarStart, SoundCategory.BLOCKS, 1.0f, 1.0f);
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this.field_145850_b, this.field_174879_c);
        }
    }

    public void saveLastRecipe() {
        ItemStack stack;
        this.lastRecipe = new ArrayList<ItemStack>();
        for (int i = 0; i < this.getSizeInventory() && !(stack = this.itemHandler.getStackInSlot(i)).func_190926_b(); ++i) {
            this.lastRecipe.add(stack.func_77946_l());
        }
        this.recipeKeepTicks = 400;
        this.field_145850_b.func_175641_c(this.func_174877_v(), ModBlocks.runeAltar, 0, 400);
    }

    public void trySetLastRecipe(EntityPlayer player) {
        TileAltar.tryToSetLastRecipe(player, (IItemHandlerModifiable)this.itemHandler, this.lastRecipe);
        if (!this.isEmpty()) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this.field_145850_b, this.field_174879_c);
        }
    }

    public boolean hasValidRecipe() {
        for (RecipeRuneAltar recipe : BotaniaAPI.runeAltarRecipes) {
            if (!recipe.matches((IItemHandler)this.itemHandler)) continue;
            return true;
        }
        return false;
    }

    public void onWanded(EntityPlayer player, ItemStack wand) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        RecipeRuneAltar recipe = null;
        if (this.currentRecipe != null) {
            recipe = this.currentRecipe;
        } else {
            for (RecipeRuneAltar recipe_ : BotaniaAPI.runeAltarRecipes) {
                if (!recipe_.matches((IItemHandler)this.itemHandler)) continue;
                recipe = recipe_;
                break;
            }
        }
        if (this.manaToGet > 0 && this.mana >= this.manaToGet) {
            List items = this.field_145850_b.func_72872_a(EntityItem.class, new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 1, 1)));
            EntityItem livingrock = null;
            for (EntityItem item : items) {
                if (item.field_70128_L || item.func_92059_d().func_190926_b() || item.func_92059_d().func_77973_b() != Item.func_150898_a((Block)ModBlocks.livingrock)) continue;
                livingrock = item;
                break;
            }
            if (livingrock != null) {
                int mana = recipe.getManaUsage();
                this.recieveMana(-mana);
                ItemStack output = recipe.getOutput().func_77946_l();
                EntityItem outputItem = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.5, (double)this.field_174879_c.func_177952_p() + 0.5, output);
                this.field_145850_b.func_72838_d((Entity)outputItem);
                this.currentRecipe = null;
                this.field_145850_b.func_175641_c(this.func_174877_v(), ModBlocks.runeAltar, 1, 60);
                this.field_145850_b.func_175641_c(this.func_174877_v(), ModBlocks.runeAltar, 2, 0);
                this.saveLastRecipe();
                for (int i = 0; i < this.getSizeInventory(); ++i) {
                    ItemStack stack = this.itemHandler.getStackInSlot(i);
                    if (stack.func_190926_b()) continue;
                    if (!(stack.func_77973_b() != ModItems.rune || player != null && player.field_71075_bZ.field_75098_d)) {
                        EntityItem outputRune = new EntityItem(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 1.5, (double)this.func_174877_v().func_177952_p() + 0.5, stack.func_77946_l());
                        this.field_145850_b.func_72838_d((Entity)outputRune);
                    }
                    this.itemHandler.setStackInSlot(i, ItemStack.field_190927_a);
                }
                livingrock.func_92059_d().func_190918_g(1);
            }
        }
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.getSizeInventory(); ++i) {
            if (this.itemHandler.getStackInSlot(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void writePacketNBT(NBTTagCompound par1nbtTagCompound) {
        super.writePacketNBT(par1nbtTagCompound);
        par1nbtTagCompound.func_74768_a(TAG_MANA, this.mana);
        par1nbtTagCompound.func_74768_a(TAG_MANA_TO_GET, this.manaToGet);
    }

    @Override
    public void readPacketNBT(NBTTagCompound par1nbtTagCompound) {
        super.readPacketNBT(par1nbtTagCompound);
        this.mana = par1nbtTagCompound.func_74762_e(TAG_MANA);
        this.manaToGet = par1nbtTagCompound.func_74762_e(TAG_MANA_TO_GET);
    }

    @Override
    public int getSizeInventory() {
        return 16;
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    protected TileSimpleInventory.SimpleItemStackHandler createItemHandler() {
        return new TileSimpleInventory.SimpleItemStackHandler(this, false){

            protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
                return 1;
            }
        };
    }

    @Override
    public int getCurrentMana() {
        return this.mana;
    }

    @Override
    public boolean isFull() {
        return this.mana >= this.manaToGet;
    }

    @Override
    public void recieveMana(int mana) {
        this.mana = Math.min(this.mana + mana, this.manaToGet);
    }

    @Override
    public boolean canRecieveManaFromBursts() {
        return !this.isFull();
    }

    public void renderHUD(Minecraft mc, ScaledResolution res) {
        int xc = res.func_78326_a() / 2;
        int yc = res.func_78328_b() / 2;
        float angle = -90.0f;
        int radius = 24;
        int amt = 0;
        for (int i = 0; i < this.getSizeInventory() && !this.itemHandler.getStackInSlot(i).func_190926_b(); ++i) {
            ++amt;
        }
        if (amt > 0) {
            float anglePer = 360.0f / (float)amt;
            for (RecipeRuneAltar recipe : BotaniaAPI.runeAltarRecipes) {
                if (!recipe.matches((IItemHandler)this.itemHandler)) continue;
                GlStateManager.func_179147_l();
                GlStateManager.func_179091_B();
                GlStateManager.func_179112_b((int)770, (int)771);
                recipe.getOutput();
                float progress = (float)this.mana / (float)this.manaToGet;
                mc.field_71446_o.func_110577_a(HUDHandler.manaBar);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderHelper.drawTexturedModalRect(xc + radius + 9, yc - 8, 0.0f, progress == 1.0f ? 0 : 22, 8, 22, 15);
                net.minecraft.client.renderer.RenderHelper.func_74520_c();
                if (progress == 1.0f) {
                    mc.func_175599_af().func_175042_a(new ItemStack(ModBlocks.livingrock), xc + radius + 16, yc + 8);
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)100.0f);
                    mc.func_175599_af().func_175042_a(new ItemStack(ModItems.twigWand), xc + radius + 24, yc + 8);
                    GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-100.0f);
                }
                RenderHelper.renderProgressPie(xc + radius + 32, yc - 8, progress, recipe.getOutput());
                net.minecraft.client.renderer.RenderHelper.func_74518_a();
                if (progress != 1.0f) continue;
                mc.field_71466_p.func_175063_a("+", (float)(xc + radius + 14), (float)(yc + 12), 0xFFFFFF);
            }
            net.minecraft.client.renderer.RenderHelper.func_74520_c();
            for (int i = 0; i < amt; ++i) {
                double xPos = (double)xc + Math.cos((double)angle * Math.PI / 180.0) * (double)radius - 8.0;
                double yPos = (double)yc + Math.sin((double)angle * Math.PI / 180.0) * (double)radius - 8.0;
                GlStateManager.func_179137_b((double)xPos, (double)yPos, (double)0.0);
                mc.func_175599_af().func_175042_a(this.itemHandler.getStackInSlot(i), 0, 0);
                GlStateManager.func_179137_b((double)(-xPos), (double)(-yPos), (double)0.0);
                angle += anglePer;
            }
            net.minecraft.client.renderer.RenderHelper.func_74518_a();
        } else if (this.recipeKeepTicks > 0) {
            String s = I18n.func_135052_a((String)"botaniamisc.altarRefill0", (Object[])new Object[0]);
            mc.field_71466_p.func_175063_a(s, (float)(xc - mc.field_71466_p.func_78256_a(s) / 2), (float)(yc + 10), 0xFFFFFF);
            s = I18n.func_135052_a((String)"botaniamisc.altarRefill1", (Object[])new Object[0]);
            mc.field_71466_p.func_175063_a(s, (float)(xc - mc.field_71466_p.func_78256_a(s) / 2), (float)(yc + 20), 0xFFFFFF);
        }
    }

    public int getTargetMana() {
        return this.manaToGet;
    }
}

