/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.api;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.squiddev.plethora.api.IWorldLocation;
import org.squiddev.plethora.api.reference.ConstantReference;

public final class WorldLocation
implements ConstantReference<IWorldLocation>,
IWorldLocation {
    private final World world;
    private final BlockPos pos;
    private final Vec3d loc;
    private AxisAlignedBB bounds;

    public WorldLocation(@Nonnull World world, @Nonnull BlockPos pos) {
        Objects.requireNonNull(world, "world cannot be null");
        Objects.requireNonNull(pos, "pos cannot be null");
        this.world = world;
        this.pos = pos.func_185334_h();
        this.loc = new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
    }

    public WorldLocation(@Nonnull World world, @Nonnull Vec3d pos) {
        Objects.requireNonNull(world, "world cannot be null");
        Objects.requireNonNull(pos, "pos cannot be null");
        this.world = world;
        this.pos = new BlockPos(pos.field_72450_a, pos.field_72448_b + 0.5, pos.field_72449_c);
        this.loc = pos;
    }

    public WorldLocation(@Nonnull World world, int x, int y, int z) {
        this(world, new BlockPos(x, y, z));
    }

    @Override
    @Nonnull
    public World getWorld() {
        return this.world;
    }

    @Override
    @Nonnull
    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    @Nonnull
    public Vec3d getLoc() {
        return this.loc;
    }

    @Override
    @Nonnull
    public AxisAlignedBB getBounds() {
        return this.bounds != null ? this.bounds : new AxisAlignedBB((double)this.pos.func_177958_n(), (double)this.pos.func_177956_o(), (double)this.pos.func_177952_p(), (double)(this.pos.func_177958_n() + 1), (double)(this.pos.func_177956_o() + 1), (double)(this.pos.func_177952_p() + 1));
    }

    @Override
    @Nonnull
    public IWorldLocation get() {
        return this;
    }

    @Override
    @Nonnull
    public IWorldLocation safeGet() {
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WorldLocation)) {
            return false;
        }
        WorldLocation other = (WorldLocation)obj;
        return this.world.equals(other.world) && this.pos.equals((Object)other.pos);
    }

    public int hashCode() {
        return this.world.hashCode() * 31 + this.pos.hashCode();
    }
}

