/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.core.docdump;

import com.google.common.base.Strings;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class DocumentedItem<T>
implements Comparable<DocumentedItem<T>> {
    private static final char[] TERMINATORS = new char[]{'!', '.', '?', '\r', '\n'};
    private final T object;
    private final String id;
    private final String name;
    private final String synopsis;
    private final String detail;

    DocumentedItem(@Nonnull T object, @Nonnull String id, @Nonnull String name, @Nullable String doc) {
        this.object = object;
        this.id = id;
        this.name = name;
        if (doc != null) {
            String detail;
            String synopsis;
            int position = -1;
            for (char chr : TERMINATORS) {
                int newPos = doc.indexOf(chr);
                if (position != -1 && (newPos <= -1 || newPos >= position)) continue;
                position = newPos;
            }
            if (position > -1) {
                synopsis = doc.substring(0, position + 1).trim();
                detail = doc.substring(position + 1).trim();
            } else if (doc.length() > 80) {
                synopsis = doc.substring(0, 77).trim() + "...";
                detail = doc;
            } else {
                synopsis = doc;
                detail = "";
            }
            this.synopsis = Strings.isNullOrEmpty((String)synopsis) ? null : synopsis;
            this.detail = Strings.isNullOrEmpty((String)detail) ? null : detail;
        } else {
            this.synopsis = null;
            this.detail = null;
        }
    }

    @Nonnull
    public T getObject() {
        return this.object;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    @Nonnull
    public String getFriendlyName() {
        return this.name;
    }

    @Nullable
    public String getSynopsis() {
        return this.synopsis;
    }

    @Nullable
    public String getDetail() {
        return this.detail;
    }

    @Override
    public int compareTo(@Nonnull DocumentedItem<T> o) {
        return this.name.compareTo(o.name);
    }
}

