/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.gameplay.modules.methods;

import dan200.computercraft.api.lua.LuaException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.squiddev.plethora.api.IWorldLocation;
import org.squiddev.plethora.api.method.wrapper.FromContext;
import org.squiddev.plethora.api.method.wrapper.Optional;
import org.squiddev.plethora.api.method.wrapper.PlethoraMethod;
import org.squiddev.plethora.gameplay.modules.ChatListener;
import org.squiddev.plethora.gameplay.modules.methods.MethodsChat;

public final class MethodsChatCreative {
    private MethodsChatCreative() {
    }

    @PlethoraMethod(module={"plethora:chat_creative"}, doc="-- Send a message to everyone")
    public static void say(@Optional @FromContext(value={"origin"}) IWorldLocation location, String message) throws LuaException {
        MethodsChat.validateMessage(message);
        ITextComponent formatted = ForgeHooks.newChatWithLinks((String)message);
        MinecraftServer server = null;
        if (location != null) {
            server = location.getWorld().func_73046_m();
        }
        if (server == null) {
            server = FMLCommonHandler.instance().getMinecraftServerInstance();
        }
        server.func_184103_al().func_148544_a(formatted, false);
    }

    @PlethoraMethod(module={"plethora:chat_creative"}, worldThread=false, doc="-- Capture all chat messages matching a Lua pattern, preventing them from being said.")
    public static void capture(@FromContext(value={"plethora:chat_creative"}) ChatListener.Listener listener, String pattern) {
        listener.addPattern(pattern);
    }

    @PlethoraMethod(module={"plethora:chat_creative"}, worldThread=false, doc="-- Remove a capture added by capture(pattern).")
    public static boolean uncapture(@FromContext(value={"plethora:chat_creative"}) ChatListener.Listener listener, String pattern) {
        return listener.removePattern(pattern);
    }

    @PlethoraMethod(module={"plethora:chat_creative"}, worldThread=false, doc="-- Remove all listeners added by capture().")
    public static void clearCaptures(@FromContext(value={"plethora:chat_creative"}) ChatListener.Listener listener) {
        listener.clearPatterns();
    }
}

