/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.astralsorcery;

import hellfirepvp.astralsorcery.common.constellation.IConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMajorConstellation;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.enchantment.amulet.AmuletEnchantment;
import hellfirepvp.astralsorcery.common.enchantment.dynamic.DynamicEnchantment;
import hellfirepvp.astralsorcery.common.item.crystal.CrystalProperties;
import hellfirepvp.astralsorcery.common.item.crystal.CrystalPropertyItem;
import hellfirepvp.astralsorcery.common.lib.Constellations;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.squiddev.plethora.api.Injects;
import org.squiddev.plethora.api.converter.ConstantConverter;
import org.squiddev.plethora.api.meta.BaseMetaProvider;
import org.squiddev.plethora.api.meta.BasicMetaProvider;
import org.squiddev.plethora.api.meta.IMetaProvider;
import org.squiddev.plethora.api.method.IPartialContext;
import org.squiddev.plethora.utils.Helpers;

@Injects(value="astralsorcery")
public final class IntegrationAstralSorcery {
    public static final ConstantConverter<ItemStack, CrystalProperties> ITEM_STACK_TO_CRYSTAL_PROPERTIES = stack -> {
        Item item = stack.func_77973_b();
        if (item instanceof CrystalPropertyItem) {
            return ((CrystalPropertyItem)item).provideCurrentPropertiesOrNull(stack);
        }
        return NBTHelper.hasPersistentData((ItemStack)stack) ? CrystalProperties.getCrystalProperties((ItemStack)stack) : null;
    };
    public static final IMetaProvider<CrystalProperties> META_CRYSTAL_PROPERTY = new BasicMetaProvider<CrystalProperties>("Provides the cutting, size, purity, and fracturing from this CrystalProperties"){

        @Override
        @Nonnull
        public Map<String, ?> getMeta(@Nonnull CrystalProperties props) {
            HashMap<String, Integer> out = new HashMap<String, Integer>(4);
            out.put("cutting", props.getCollectiveCapability());
            out.put("size", props.getSize());
            out.put("purity", props.getPurity());
            out.put("fracture", props.getFracturation());
            return Collections.singletonMap("crystalProperties", out);
        }

        @Override
        @Nullable
        public CrystalProperties getExample() {
            return CrystalProperties.getMaxRockProperties();
        }
    };
    public static final IMetaProvider<IConstellation> META_I_CONSTELLATION = new BasicMetaProvider<IConstellation>("Provides the name, colors, and tier of an IConstellation"){

        @Override
        @Nonnull
        public Map<String, ?> getMeta(@Nonnull IConstellation context) {
            HashMap<String, Object> out = new HashMap<String, Object>(8);
            String translationKey = context.getUnlocalizedName();
            out.put("name", translationKey);
            out.put("simpleName", context.getSimpleName());
            out.put("displayName", Helpers.translateToLocal(translationKey));
            out.put("color", context.getConstellationColor().getRGB());
            out.put("colour", context.getConstellationColor().getRGB());
            out.put("tierColor", context.getTierRenderColor().getRGB());
            out.put("tierColour", context.getTierRenderColor().getRGB());
            out.put("tier", IntegrationAstralSorcery.getConstellationTier(context));
            return out;
        }

        @Override
        @Nullable
        public IConstellation getExample() {
            return Constellations.discidia;
        }
    };
    public static final IMetaProvider<AmuletEnchantment> META_AMULET_ENCHANTMENT = new BaseMetaProvider<AmuletEnchantment>("Provides the type, level, and boosted enchantment (if applicable) of this Amulet Enchantment.\nFor examples, see META_RESPLENDENT_PRISM"){

        @Override
        @Nonnull
        public Map<String, ?> getMeta(@Nonnull IPartialContext<AmuletEnchantment> context) {
            HashMap<String, Object> out = new HashMap<String, Object>(4);
            AmuletEnchantment target = context.getTarget();
            DynamicEnchantment.Type enchantType = target.getType();
            out.put("bonusType", enchantType.toString());
            Enchantment enchant = target.getEnchantment();
            if (enchantType.hasEnchantmentTag() && enchant != null) {
                out.put("boostedEnchant", enchant.func_77320_a());
                out.put("boostedEnchantFullName", enchant.func_77316_c(1));
            } else {
                out.put("boostedEnchant", "all");
            }
            out.put("bonusLevel", target.getLevelAddition());
            return out;
        }
    };

    private IntegrationAstralSorcery() {
    }

    @Nonnull
    private static String getConstellationTier(IConstellation constellation) {
        if (constellation instanceof IMinorConstellation) {
            return "minor";
        }
        if (constellation instanceof IMajorConstellation) {
            return "major";
        }
        return "weak";
    }
}

