/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.mcmultipart;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import mcmultipart.api.container.IMultipartContainer;
import mcmultipart.api.container.IPartInfo;
import mcmultipart.api.slot.IPartSlot;
import org.squiddev.plethora.api.meta.TypedMeta;
import org.squiddev.plethora.api.method.IContext;
import org.squiddev.plethora.api.method.LuaList;
import org.squiddev.plethora.api.method.TypedLuaObject;
import org.squiddev.plethora.api.method.wrapper.FromTarget;
import org.squiddev.plethora.api.method.wrapper.Optional;
import org.squiddev.plethora.api.method.wrapper.PlethoraMethod;
import org.squiddev.plethora.integration.mcmultipart.IntegrationMcMultipart;
import org.squiddev.plethora.integration.mcmultipart.ReferenceMultipart;

public final class MethodsMultipart {
    private MethodsMultipart() {
    }

    @PlethoraMethod(modId="mcmultipart", doc="-- Get a list of all parts in the multipart.")
    public static Map<Integer, ?> listParts(@FromTarget IMultipartContainer container) {
        return LuaList.of(container.getParts().values(), IntegrationMcMultipart::getBasicMeta).asMap();
    }

    @PlethoraMethod(modId="mcmultipart", doc="-- Get a lookup of slot to parts.")
    public static Map<String, ?> listSlottedParts(@FromTarget IMultipartContainer container) {
        HashMap parts = new HashMap();
        for (Map.Entry slot : container.getParts().entrySet()) {
            parts.put(((IPartSlot)slot.getKey()).getRegistryName().toString().toLowerCase(Locale.ENGLISH), IntegrationMcMultipart.getBasicMeta((IPartInfo)slot.getValue()));
        }
        return parts;
    }

    @Optional
    @PlethoraMethod(modId="mcmultipart", doc="-- Get a reference to the part in the specified slot.")
    public static TypedLuaObject<IPartInfo> getSlottedPart(IContext<IMultipartContainer> context, IPartSlot slot) {
        IMultipartContainer container = (IMultipartContainer)context.getTarget();
        IPartInfo part = container.get(slot).orElse(null);
        return part == null ? null : context.makeChild(part, new ReferenceMultipart(container, part)).getObject();
    }

    @Optional
    @PlethoraMethod(modId="mcmultipart", doc="-- Get the metadata of the part in the specified slot.")
    public static TypedMeta<IPartInfo, ?> getSlottedPartMeta(IContext<IMultipartContainer> context, IPartSlot slot) {
        IMultipartContainer container = (IMultipartContainer)context.getTarget();
        IPartInfo part = container.get(slot).orElse(null);
        return part == null ? null : context.makePartialChild(part).getMeta();
    }
}

