/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.integration.vanilla.meta;

import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import org.squiddev.plethora.api.Injects;
import org.squiddev.plethora.api.meta.BaseMetaProvider;
import org.squiddev.plethora.api.method.IPartialContext;
import org.squiddev.plethora.api.method.LuaList;

@Injects
public final class MetaFluidHandler
extends BaseMetaProvider<IFluidHandler> {
    @Override
    @Nonnull
    public Map<String, ?> getMeta(@Nonnull IPartialContext<IFluidHandler> context) {
        IFluidHandler handler = context.getTarget();
        LuaList tanks = new LuaList();
        for (IFluidTankProperties tank : handler.getTankProperties()) {
            if (handler.equals(tank)) continue;
            tanks.add(context.makePartialChild(tank).getMeta());
        }
        return tanks.isEmpty() ? Collections.emptyMap() : Collections.singletonMap("tanks", tanks.asMap());
    }

    @Override
    @Nonnull
    public IFluidHandler getExample() {
        return new FluidHandlerItemStack(new ItemStack(Items.field_151131_as), 1000){
            final FluidStack stack;
            {
                this.stack = FluidRegistry.getFluidStack((String)"water", (int)525);
            }

            @Nullable
            public FluidStack getFluid() {
                return this.stack;
            }
        };
    }
}

