/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.inventory.container;

import codechicken.lib.inventory.container.ContainerExtended;
import codechicken.lib.inventory.container.IContainerSyncVar;
import codechicken.lib.packet.PacketCustom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public abstract class ContainerSynchronised
extends ContainerExtended {
    private ArrayList<IContainerSyncVar> syncVars = new ArrayList();

    public abstract PacketCustom createSyncPacket();

    public final void func_75142_b() {
        super.func_75142_b();
        for (int i = 0; i < this.syncVars.size(); ++i) {
            IContainerSyncVar var = this.syncVars.get(i);
            if (!var.changed()) continue;
            PacketCustom packet = this.createSyncPacket();
            packet.writeByte(i);
            var.writeChange(packet);
            this.sendContainerPacket(packet);
            var.reset();
        }
    }

    @Override
    public void sendContainerAndContentsToPlayer(Container container, NonNullList<ItemStack> list, List<EntityPlayerMP> playerCrafters) {
        super.sendContainerAndContentsToPlayer(container, list, playerCrafters);
        for (int i = 0; i < this.syncVars.size(); ++i) {
            IContainerSyncVar var = this.syncVars.get(i);
            PacketCustom packet = this.createSyncPacket();
            packet.writeByte(i);
            var.writeChange(packet);
            var.reset();
            for (EntityPlayerMP player : playerCrafters) {
                packet.sendToPlayer((EntityPlayer)player);
            }
        }
    }

    public void addSyncVar(IContainerSyncVar var) {
        this.syncVars.add(var);
    }

    @Override
    public final void handleOutputPacket(PacketCustom packet) {
        this.syncVars.get(packet.readUByte()).readChange(packet);
    }

    public List<IContainerSyncVar> getSyncedVars() {
        return Collections.unmodifiableList(this.syncVars);
    }
}

