/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.crop.crops;

import ic2.api.crops.CropProperties;
import ic2.api.crops.ICropTile;
import ic2.core.IC2;
import ic2.core.block.crop.crops.CropSeedDropBase;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CropRedWheat
extends CropSeedDropBase {
    public CropRedWheat() {
        super(new CropProperties(6, 3, 0, 0, 2, 0));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int state) {
        if (state == 7) {
            return this.getSprite("bc")[27];
        }
        return this.getSprite("bc")[1 + state];
    }

    @Override
    public String getId() {
        return "Redwheat";
    }

    @Override
    public int getWeightInfluences(ICropTile crop, int humidity, int nutrients, int air) {
        if (air >= 2) {
            return humidity + (int)((double)nutrients * 1.3) + (10 - air);
        }
        return humidity + (int)((double)nutrients * 1.3) + (10 - air) * 2;
    }

    @Override
    public String getDiscoveredBy() {
        return "raa1337";
    }

    @Override
    public String[] getAttributes() {
        return new String[]{"Red", "Redstone", "Wheat"};
    }

    @Override
    public boolean canGrow(ICropTile cropTile) {
        int light = cropTile.getLightLevel();
        return cropTile.getCurrentSize() < 7 && light <= 12 && light >= 5;
    }

    @Override
    public boolean canBeHarvested(ICropTile cropTile) {
        return cropTile.getCurrentSize() == 7;
    }

    @Override
    public double dropGainChance() {
        return 0.5;
    }

    @Override
    public int getMaxSize() {
        return 7;
    }

    @Override
    public ItemStack getGain(ICropTile crop) {
        if (this.getWorld(crop).func_175640_z(crop.getLocation()) || IC2.random.nextBoolean()) {
            return new ItemStack(Items.field_151137_ax);
        }
        return new ItemStack(Items.field_151015_O);
    }

    @Override
    public ItemStack getSeed(ICropTile tile) {
        return new ItemStack(Items.field_151014_N);
    }

    @Override
    public int getEmittedRedstoneSignal(ICropTile cropTile) {
        return cropTile.getCurrentSize() == 7 ? 15 : 0;
    }

    @Override
    public boolean isRedstoneSignalEmitter(ICropTile cropTile) {
        return cropTile.getCurrentSize() == 7;
    }

    @Override
    public int getEmittedLight(ICropTile crop) {
        return crop.getCurrentSize() == 7 ? 7 : 0;
    }

    @Override
    public int getGrowthDuration(ICropTile cropTile) {
        return 600;
    }

    @Override
    public int getSizeAfterHarvest(ICropTile cropTile) {
        return 2;
    }

    @Override
    public int getOptimalHarvestSize(ICropTile cropTile) {
        return 7;
    }
}

