/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.low;

import ic2.api.classic.item.IFoamProvider;
import ic2.api.classic.item.IFuelableItem;
import ic2.api.classic.item.IMachineUpgradeItem;
import ic2.api.classic.network.adv.NetworkField;
import ic2.api.classic.recipe.ClassicRecipes;
import ic2.api.classic.recipe.machine.ICannerRegistry;
import ic2.api.classic.tile.machine.IProgressMachine;
import ic2.api.energy.EnergyNet;
import ic2.api.item.ICustomDamageItem;
import ic2.api.recipe.IRecipeInput;
import ic2.core.IC2;
import ic2.core.RotationList;
import ic2.core.block.base.tile.TileEntityElecMachine;
import ic2.core.block.base.util.comparator.ComparatorManager;
import ic2.core.block.base.util.comparator.comparators.ComparatorProgress;
import ic2.core.block.base.util.info.ProgressInfo;
import ic2.core.block.machine.low.container.ContainerCanner;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.base.IHasInventory;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.filters.ArrayFilter;
import ic2.core.inventory.filters.BasicItemFilter;
import ic2.core.inventory.filters.CannerFilter;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.inventory.filters.IFilter;
import ic2.core.inventory.gui.custom.MachineGui;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.inventory.management.SlotType;
import ic2.core.inventory.transport.wrapper.RangedInventoryWrapper;
import ic2.core.item.reactor.ItemReactorUraniumRod;
import ic2.core.item.reactor.uranTypes.IUranium;
import ic2.core.item.recipe.entry.RecipeInputItemStack;
import ic2.core.item.recipe.entry.RecipeInputOreDict;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.IOutputMachine;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemSoup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEntityCanner
extends TileEntityElecMachine
implements ITickable,
IProgressMachine,
IHasGui,
IOutputMachine {
    @NetworkField(index=7)
    public int energyConsumtion = 1;
    public float recipeSpeed = 1.0f;
    public int step = 0;
    @NetworkField(index=8)
    public float progress = 0.0f;
    public int fuelQuality = 0;
    public IFilter filter;

    public TileEntityCanner() {
        super(8, 32);
        this.setFuelSlot(1);
        this.maxEnergy = 631;
        this.addGuiFields("progress", "energyConsumtion");
        this.addInfos(new ProgressInfo(this));
    }

    @Override
    protected void addSlots(InventoryHandler handler) {
        this.filter = new CannerFilter(this);
        handler.registerDefaultSideAccess(AccessRule.Both, RotationList.ALL);
        handler.registerDefaultSlotAccess(AccessRule.Import, 0, 3);
        handler.registerDefaultSlotAccess(AccessRule.Export, 2);
        handler.registerDefaultSlotAccess(AccessRule.Both, 1);
        handler.registerDefaultSlotsForSide(RotationList.UP, 0);
        handler.registerDefaultSlotsForSide(RotationList.DOWN, 1);
        handler.registerDefaultSlotsForSide(RotationList.HORIZONTAL, 2);
        handler.registerDefaultSlotsForSide(RotationList.EAST, 3);
        handler.registerInputFilter(this.filter, 0);
        handler.registerInputFilter(new ArrayFilter(CommonFilters.DischargeEU, new BasicItemFilter(Items.field_151137_ax), new BasicItemFilter(Ic2Items.suBattery)), 1);
        handler.registerOutputFilter(CommonFilters.NotDischargeEU, 1);
        handler.registerInputFilter(CommonFilters.CannerInput, 3);
        handler.registerSlotType(SlotType.Input, 0);
        handler.registerSlotType(SlotType.Discharge, 1);
        handler.registerSlotType(SlotType.Output, 2);
        handler.registerSlotType(SlotType.SecondInput, 3);
    }

    @Override
    protected void addComparators(ComparatorManager manager) {
        super.addComparators(manager);
        manager.addComparatorMode(new ComparatorProgress(this));
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.fuelQuality = nbt.func_74762_e("fuelQuality");
        this.progress = nbt.func_74760_g("progress");
        this.step = nbt.func_74762_e("Step");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("fuelQuality", this.fuelQuality);
        nbt.func_74776_a("progress", this.progress);
        nbt.func_74768_a("Step", this.step);
        return nbt;
    }

    public static void init() {
        ICannerRegistry canner = ClassicRecipes.canningMachine;
        canner.addRepairRecipe((ICustomDamageItem)Ic2Items.reactorReflectorIridium.func_77973_b(), 2, new RecipeInputOreDict("dustCoal", 4), -10000);
        canner.addRepairRecipe((ICustomDamageItem)Ic2Items.reactorReflectorIridium.func_77973_b(), 2, new RecipeInputOreDict("dustCharcoal", 4), -5000);
        canner.addRepairRecipe((ICustomDamageItem)Ic2Items.reactorCondensator.func_77973_b(), Ic2Items.reactorCondensator.func_77960_j(), new RecipeInputOreDict("dustRedstone"), -10000);
        canner.addRepairRecipe((ICustomDamageItem)Ic2Items.reactorCondensatorLap.func_77973_b(), Ic2Items.reactorCondensatorLap.func_77960_j(), new RecipeInputOreDict("dustRedstone"), -4000);
        canner.addRepairRecipe((ICustomDamageItem)Ic2Items.reactorCondensatorLap.func_77973_b(), Ic2Items.reactorCondensatorLap.func_77960_j(), new RecipeInputOreDict("gemLapis"), -40000);
        canner.registerCannerItem(Ic2Items.emptyCell.func_77946_l(), new RecipeInputItemStack(Ic2Items.hydratedCoalClump.func_77946_l()), Ic2Items.hydratedCoalCell.func_77946_l());
        canner.registerCannerItem(Ic2Items.emptyCell.func_77946_l(), new RecipeInputItemStack(Ic2Items.compressedPlantBall.func_77946_l()), Ic2Items.bioCell.func_77946_l());
        canner.registerCannerItem(Ic2Items.emptyCell.func_77946_l(), new RecipeInputItemStack(new ItemStack((Block)Blocks.field_150355_j)), Ic2Items.waterCell.func_77946_l());
        canner.registerCannerItem(Ic2Items.emptyCell.func_77946_l(), new RecipeInputItemStack(new ItemStack((Block)Blocks.field_150353_l)), Ic2Items.lavaCell.func_77946_l());
        for (IUranium uran : ItemReactorUraniumRod.types) {
            if (uran.isReEnrichedUran() && IC2.config.getFlag("HardEnrichedUran")) continue;
            canner.registerCannerItem(Ic2Items.emptyCell.func_77946_l(), new RecipeInputItemStack(uran.getUraniumIngot().func_77946_l()), uran.getRodType(IUranium.RodType.SingleRod).func_77946_l());
        }
    }

    @Override
    public float getProgress() {
        return this.progress;
    }

    @Override
    public float getMaxProgress() {
        switch (this.getMode()) {
            case 1: {
                return this.getFoodValue((ItemStack)this.inventory.get(0)) * 50;
            }
            case 2: {
                return 600.0f;
            }
            case 3: {
                return 50.0f;
            }
            case 4: {
                return 50.0f;
            }
            case 5: {
                return 50.0f;
            }
        }
        return 0.0f;
    }

    public float getRecipeProgress() {
        int maxProgress = 600;
        int mode = this.getMode();
        if (mode == 1) {
            int food = this.getFoodValue((ItemStack)this.inventory.get(0));
            if (food > 0) {
                maxProgress = 50 * food;
            }
        } else if (mode == 3 || mode == 4 || mode == 5) {
            maxProgress = 50;
        }
        return (float)((double)this.progress / (double)maxProgress);
    }

    @Override
    public boolean supportsNotify() {
        return true;
    }

    public void func_73660_a() {
        this.updateNeighbors();
        int mode = this.getMode();
        boolean canWork = this.canOperate(mode);
        if (canWork) {
            this.handleChargeSlot(this.maxEnergy);
        }
        float prog = this.progress;
        boolean newActive = this.getActive();
        if (canWork && this.canProceedInMode(mode)) {
            if (mode == 1 || mode == 3 || mode == 4 || mode == 5 || this.progress >= 600.0f) {
                this.operate(false, mode);
                this.fuelQuality = 0;
                this.progress = 0.0f;
                this.fuelQuality = 0;
                newActive = false;
                this.notifyNeighbors();
            } else {
                this.operate(true, mode);
            }
        }
        if (!newActive || this.progress == 0.0f) {
            if (canWork) {
                if (this.energy >= 1) {
                    newActive = true;
                }
            } else if (this.getMode() != 2) {
                this.fuelQuality = 0;
                this.progress = 0.0f;
                this.step = 0;
            }
        } else if (!canWork || this.energy < 1) {
            if (!canWork && this.getMode() != 2) {
                this.fuelQuality = 0;
                this.progress = 0.0f;
                this.step = 0;
            }
            newActive = false;
        }
        if (newActive) {
            this.progress += this.recipeSpeed;
            this.useEnergy(1);
        }
        if (newActive != this.getActive()) {
            this.setActive(newActive);
        }
        if (this.progress != prog) {
            this.getNetwork().updateTileGuiField(this, "progress");
        }
        for (int i = 0; i < 4; ++i) {
            ItemStack item = (ItemStack)this.inventory.get(i + this.inventory.size() - 4);
            if (!(item.func_77973_b() instanceof IMachineUpgradeItem)) continue;
            ((IMachineUpgradeItem)item.func_77973_b()).onTick(item, this);
        }
        this.updateComparators();
    }

    public boolean canProceedInMode(int mode) {
        switch (mode) {
            case 1: {
                return this.progress >= (float)(this.getFoodValue((ItemStack)this.inventory.get(0)) * 50);
            }
            case 2: {
                return this.progress > 0.0f && (int)(this.progress / 100.0f) > this.step;
            }
            case 3: {
                return this.progress >= 50.0f;
            }
            case 4: {
                return this.progress >= 50.0f;
            }
            case 5: {
                return this.progress >= 50.0f;
            }
        }
        return false;
    }

    public void operate(boolean incremental, int mode) {
        if (mode == 1) {
            int food = this.getFoodValue((ItemStack)this.inventory.get(0));
            int meta = this.getFoodMeta((ItemStack)this.inventory.get(0));
            if (((ItemStack)this.inventory.get(0)).func_77973_b().hasContainerItem((ItemStack)this.inventory.get(0))) {
                this.inventory.set(0, (Object)((ItemStack)this.inventory.get(0)).func_77973_b().getContainerItem((ItemStack)this.inventory.get(0)));
            } else if (((ItemStack)this.inventory.get(0)).func_77973_b() instanceof ItemSoup) {
                this.inventory.set(0, (Object)new ItemStack(Items.field_151054_z));
            } else {
                ((ItemStack)this.inventory.get(0)).func_190918_g(1);
            }
            ((ItemStack)this.inventory.get(3)).func_190918_g(food);
            if (((ItemStack)this.inventory.get(2)).func_190926_b()) {
                this.inventory.set(2, (Object)StackUtil.copyWithDamageAndSize(Ic2Items.filledTinCan, meta, food));
            } else {
                ((ItemStack)this.inventory.get(2)).func_190917_f(food);
            }
        } else if (mode == 2) {
            int fuel = this.getFuelValue((ItemStack)this.inventory.get(0));
            ((ItemStack)this.inventory.get(0)).func_190918_g(1);
            this.fuelQuality += fuel;
            ++this.step;
            if (incremental) {
                return;
            }
            this.step = 0;
            if (!(((ItemStack)this.inventory.get(3)).func_77973_b() instanceof IFuelableItem)) {
                return;
            }
            IFuelableItem item = (IFuelableItem)((ItemStack)this.inventory.get(3)).func_77973_b();
            ItemStack newItem = item.fill(((ItemStack)this.inventory.get(3)).func_77946_l(), this.fuelQuality);
            if (((ItemStack)this.inventory.get(3)).func_77973_b().hasContainerItem((ItemStack)this.inventory.get(3))) {
                this.inventory.set(3, (Object)ItemStack.field_190927_a);
            } else {
                ((ItemStack)this.inventory.get(3)).func_190918_g(1);
            }
            this.inventory.set(2, (Object)newItem);
        } else if (mode == 3) {
            int amount = this.getPelletValue((ItemStack)this.inventory.get(0));
            ((ItemStack)this.inventory.get(0)).func_190918_g(1);
            IFoamProvider prov = (IFoamProvider)((ItemStack)this.inventory.get(3)).func_77973_b();
            prov.fillFoam((ItemStack)this.inventory.get(3), amount);
            int left = prov.getFreeRoom((ItemStack)this.inventory.get(3));
            if (left < amount) {
                this.inventory.set(2, this.inventory.get(3));
                this.inventory.set(3, (Object)ItemStack.field_190927_a);
            }
        } else if (mode == 4) {
            boolean full;
            Tuple<IRecipeInput, Integer> result = ClassicRecipes.canningMachine.getRepairResult((ItemStack)this.inventory.get(3), (ItemStack)this.inventory.get(0), false);
            ItemStack toRepair = (ItemStack)this.inventory.get(3);
            if (result == null || toRepair == null || !(toRepair.func_77973_b() instanceof ICustomDamageItem)) {
                return;
            }
            ((ItemStack)this.inventory.get(0)).func_190918_g(((IRecipeInput)result.func_76341_a()).getAmount());
            ICustomDamageItem item = (ICustomDamageItem)toRepair.func_77973_b();
            int change = (Integer)result.func_76340_b();
            int max = item.getMaxCustomDamage(toRepair);
            int current = item.getCustomDamage(toRepair);
            boolean bl = change > 0 ? current >= max : (full = (current += change) <= 0);
            if (current > max) {
                current = max;
            } else if (current < 0) {
                current = 0;
            }
            item.setCustomDamage(toRepair, current);
            if (full) {
                this.inventory.set(2, this.inventory.get(3));
                this.inventory.set(3, (Object)ItemStack.field_190927_a);
            }
        } else if (mode == 5) {
            Tuple<IRecipeInput, ItemStack> result = ClassicRecipes.canningMachine.getCanningResult((ItemStack)this.inventory.get(3), (ItemStack)this.inventory.get(0), true);
            if (result == null) {
                return;
            }
            ((ItemStack)this.inventory.get(3)).func_190918_g(1);
            ((ItemStack)this.inventory.get(0)).func_190918_g(((IRecipeInput)result.func_76341_a()).getAmount());
            if (((ItemStack)this.inventory.get(2)).func_190926_b()) {
                this.inventory.set(2, (Object)((ItemStack)result.func_76340_b()).func_77946_l());
            } else if (StackUtil.isStackEqual((ItemStack)this.inventory.get(2), (ItemStack)result.func_76340_b(), false, false)) {
                ((ItemStack)this.inventory.get(2)).func_190917_f(((ItemStack)result.func_76340_b()).func_190916_E());
            }
        }
        for (int i = 0; i < 4; ++i) {
            ItemStack item = (ItemStack)this.inventory.get(i + this.inventory.size() - 4);
            if (!(item.func_77973_b() instanceof IMachineUpgradeItem)) continue;
            ((IMachineUpgradeItem)item.func_77973_b()).onProcessFinished(item, this);
        }
    }

    @Override
    public boolean isValidInput(ItemStack par1) {
        if (par1.func_190926_b()) {
            return false;
        }
        int mode = this.getMode();
        if (mode == 1) {
            return this.getFoodValue(par1) > 0;
        }
        if (mode == 2) {
            ICannerRegistry.FuelInfo info = ClassicRecipes.canningMachine.getFuelInfo(par1);
            if (info == null) {
                return false;
            }
            return info.getAmount() > 0 || info.getMultiplier() > 0.0f;
        }
        if (mode == 3) {
            return this.getPelletValue(par1) > 0;
        }
        if (mode == 4) {
            return ClassicRecipes.canningMachine.getRepairResult((ItemStack)this.inventory.get(3), par1, true) != null;
        }
        if (mode == 5) {
            return ClassicRecipes.canningMachine.getCanningResult((ItemStack)this.inventory.get(3), par1, true) != null;
        }
        return false;
    }

    public boolean canOperate(int mode) {
        if (((ItemStack)this.inventory.get(0)).func_190926_b()) {
            return false;
        }
        if (mode == 0) {
            return false;
        }
        if (mode == 1) {
            int food = this.getFoodValue((ItemStack)this.inventory.get(0));
            return food > 0 && food <= ((ItemStack)this.inventory.get(3)).func_190916_E() && (((ItemStack)this.inventory.get(2)).func_190926_b() || ((ItemStack)this.inventory.get(2)).func_77973_b() == Ic2Items.filledTinCan.func_77973_b() && ((ItemStack)this.inventory.get(2)).func_77952_i() == this.getFoodMeta((ItemStack)this.inventory.get(0)) && ((ItemStack)this.inventory.get(2)).func_190916_E() + food <= ((ItemStack)this.inventory.get(2)).func_77976_d());
        }
        if (mode == 2) {
            return this.getFuelValue((ItemStack)this.inventory.get(0)) > 0 && ((ItemStack)this.inventory.get(2)).func_190926_b();
        }
        if (mode == 3) {
            int amount = this.getPelletValue((ItemStack)this.inventory.get(0));
            if (amount > 0 && ((IFoamProvider)((ItemStack)this.inventory.get(3)).func_77973_b()).getFreeRoom((ItemStack)this.inventory.get(3)) >= amount && ((ItemStack)this.inventory.get(2)).func_190926_b()) {
                return true;
            }
        } else {
            if (mode == 4) {
                return ((ItemStack)this.inventory.get(2)).func_190926_b() && ClassicRecipes.canningMachine.getRepairResult((ItemStack)this.inventory.get(3), (ItemStack)this.inventory.get(0), false) != null;
            }
            if (mode == 5) {
                Tuple<IRecipeInput, ItemStack> result = ClassicRecipes.canningMachine.getCanningResult((ItemStack)this.inventory.get(3), (ItemStack)this.inventory.get(0), false);
                if (result == null) {
                    return false;
                }
                if (((ItemStack)this.inventory.get(2)).func_190926_b() || StackUtil.isStackEqual((ItemStack)this.inventory.get(2), (ItemStack)result.func_76340_b(), false, false) && ((ItemStack)this.inventory.get(2)).func_190916_E() + ((ItemStack)result.func_76340_b()).func_190916_E() <= ((ItemStack)this.inventory.get(2)).func_77976_d()) {
                    return true;
                }
            }
        }
        return false;
    }

    public int getMode() {
        if (((ItemStack)this.inventory.get(3)).func_190926_b()) {
            return 0;
        }
        if (StackUtil.isStackEqual((ItemStack)this.inventory.get(3), Ic2Items.tinCan)) {
            return 1;
        }
        if (((ItemStack)this.inventory.get(3)).func_77973_b() instanceof IFuelableItem && ((IFuelableItem)((ItemStack)this.inventory.get(3)).func_77973_b()).canFill((ItemStack)this.inventory.get(3))) {
            return 2;
        }
        if (((ItemStack)this.inventory.get(3)).func_77973_b() instanceof IFoamProvider) {
            return 3;
        }
        if (((ItemStack)this.inventory.get(3)).func_77973_b() instanceof ICustomDamageItem) {
            return 4;
        }
        if (ClassicRecipes.canningMachine.hasCanningContainer((ItemStack)this.inventory.get(3))) {
            return 5;
        }
        return 0;
    }

    public int getFoodValue(ItemStack item) {
        if (item.func_190926_b()) {
            return 0;
        }
        if (item.func_77973_b() instanceof ItemFood) {
            return (int)Math.ceil((double)((ItemFood)item.func_77973_b()).func_150905_g(item) / 2.0);
        }
        if (item.func_77973_b() == Items.field_151105_aU || item.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150414_aQ)) {
            return 6;
        }
        return 0;
    }

    public int getFoodMeta(ItemStack item) {
        if (item.func_190926_b()) {
            return 0;
        }
        return ClassicRecipes.canningMachine.getEffectForItem(item);
    }

    public int getFuelValue(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        ICannerRegistry.FuelInfo info = ClassicRecipes.canningMachine.getFuelInfo(stack);
        if (info == null) {
            return 0;
        }
        if (info.getAmount() > 0) {
            return info.getAmount();
        }
        if ((double)info.getMultiplier() > 0.0) {
            return (int)((double)this.fuelQuality * (double)info.getMultiplier());
        }
        return 0;
    }

    public int getPelletValue(ItemStack item) {
        if (item.func_190926_b()) {
            return 0;
        }
        if (StackUtil.isStackEqual(item, Ic2Items.constructionFoamPellet)) {
            return 26;
        }
        return 0;
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerCanner(player.field_71071_by, this);
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return MachineGui.CannerGui.class;
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return !this.func_145837_r();
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return true;
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.canner;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.isSimulating()) {
            this.setOverclockRates();
        }
    }

    public void setOverclockRates() {
        int extraProcessSpeed = 0;
        double processingSpeedMultiplier = 1.0;
        int extraEnergyDemand = 0;
        double energyDemandMultiplier = 1.0;
        int extraEnergyStorage = 0;
        double energyStorageMultiplier = 1.0;
        int extraTier = 0;
        for (int i = 0; i < 4; ++i) {
            ItemStack item = (ItemStack)this.inventory.get(i + this.inventory.size() - 4);
            if (!(item.func_77973_b() instanceof IMachineUpgradeItem)) continue;
            IMachineUpgradeItem upgrade = (IMachineUpgradeItem)item.func_77973_b();
            upgrade.onInstalling(item, this);
            extraProcessSpeed += upgrade.getExtraProcessSpeed(item, this) * item.func_190916_E();
            processingSpeedMultiplier *= Math.pow(upgrade.getProcessSpeedMultiplier(item, this), item.func_190916_E());
            extraEnergyDemand += upgrade.getExtraEnergyDemand(item, this) * item.func_190916_E();
            energyDemandMultiplier *= Math.pow(upgrade.getEnergyDemandMultiplier(item, this), item.func_190916_E());
            extraEnergyStorage += upgrade.getExtraEnergyStorage(item, this) * item.func_190916_E();
            energyStorageMultiplier *= Math.pow(upgrade.getEnergyStorageMultiplier(item, this), item.func_190916_E());
            extraTier += upgrade.getExtraTier(item, this) * item.func_190916_E();
        }
        this.recipeSpeed = (int)TileEntityCanner.applyFloatModifier(1, extraProcessSpeed, processingSpeedMultiplier);
        this.energyConsumtion = TileEntityCanner.applyModifier(1, extraEnergyDemand, energyDemandMultiplier);
        this.setMaxEnergy(TileEntityCanner.applyModifier(200, extraEnergyStorage, energyStorageMultiplier));
        this.tier = this.baseTier + extraTier;
        if (this.tier > 13) {
            this.tier = 13;
        }
        this.maxInput = (int)EnergyNet.instance.getPowerFromTier(this.tier);
        if (this.energy > this.maxEnergy) {
            this.energy = this.maxEnergy;
        }
        if (this.recipeSpeed < 0.01f) {
            this.recipeSpeed = 0.01f;
        }
        if (this.energyConsumtion < 1) {
            this.energyConsumtion = 1;
        }
        this.getNetwork().updateTileGuiField(this, "energyConsume");
        this.getNetwork().updateTileGuiField(this, "maxInput");
        this.getNetwork().updateTileGuiField(this, "energy");
    }

    static int applyModifier(int base, int extra, double multiplier) {
        long ret = Math.round((double)(base + extra) * multiplier);
        return ret > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)ret;
    }

    static float applyFloatModifier(int base, int extra, double multiplier) {
        double ret = Math.round((double)(base + extra) * multiplier);
        return ret > 2.147483648E9 ? 2.1474836E9f : (float)ret;
    }

    @Override
    public double getEnergy() {
        return this.energy;
    }

    @Override
    public boolean useEnergy(double amount, boolean simulate) {
        boolean result;
        boolean bl = result = (double)this.energy >= amount;
        if (!simulate) {
            this.useEnergy((int)amount);
        }
        return result;
    }

    @Override
    public void setRedstoneSensitive(boolean active) {
    }

    @Override
    public boolean isRedstoneSensitive() {
        return false;
    }

    @Override
    public boolean isProcessing() {
        return this.getActive();
    }

    @Override
    public IHasInventory getOutputInventory() {
        return new RangedInventoryWrapper(this, 2);
    }

    @Override
    public IHasInventory getInputInventory() {
        return new RangedInventoryWrapper(this, 0, 3).addFilters(new IFilter[]{this.filter, CommonFilters.CannerInput});
    }

    @Override
    public Set<IMachineUpgradeItem.UpgradeType> getSupportedTypes() {
        EnumSet<IMachineUpgradeItem.UpgradeType> types = EnumSet.allOf(IMachineUpgradeItem.UpgradeType.class);
        types.remove((Object)IMachineUpgradeItem.UpgradeType.Sounds);
        types.remove((Object)IMachineUpgradeItem.UpgradeType.RedstoneControl);
        return types;
    }

    @Override
    public World getMachineWorld() {
        return this.func_145831_w();
    }

    @Override
    public BlockPos getMachinePos() {
        return this.func_174877_v();
    }
}

