/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.low;

import ic2.api.classic.network.adv.IBitLevelOverride;
import ic2.api.classic.network.adv.NetworkField;
import ic2.api.classic.recipe.ClassicRecipes;
import ic2.api.classic.tile.machine.IProgressMachine;
import ic2.api.classic.tile.machine.ISecondaryProgressMachine;
import ic2.core.RotationList;
import ic2.core.block.base.tile.TileEntityElecMachine;
import ic2.core.block.base.util.comparator.ComparatorManager;
import ic2.core.block.base.util.comparator.comparators.ComparatorProgress;
import ic2.core.block.base.util.comparator.comparators.ComparatorSecondaryProgress;
import ic2.core.block.base.util.info.ProgressInfo;
import ic2.core.block.base.util.info.SecondaryProgressInfo;
import ic2.core.block.machine.low.container.ContainerRareEarthExtractor;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.filters.ArrayFilter;
import ic2.core.inventory.filters.BasicItemFilter;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.inventory.gui.custom.MachineGui;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.inventory.management.SlotType;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.misc.StackUtil;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;

public class TileEntityRareEarthExtractor
extends TileEntityElecMachine
implements ITickable,
IProgressMachine,
ISecondaryProgressMachine,
IHasGui,
IBitLevelOverride {
    @NetworkField(index=7, compression=NetworkField.BitLevel.Bit8)
    public int progress = 0;
    @NetworkField(index=8)
    public float rareEarth = 0.0f;

    public TileEntityRareEarthExtractor() {
        super(3, 32);
        this.addGuiFields("progress", "rareEarth");
        this.setFuelSlot(0);
        this.maxEnergy = 1120;
        this.addInfos(new ProgressInfo(this), new SecondaryProgressInfo(this));
    }

    @Override
    protected void addSlots(InventoryHandler handler) {
        handler.registerDefaultSideAccess(AccessRule.Both, RotationList.ALL);
        handler.registerDefaultSlotAccess(AccessRule.Both, 0);
        handler.registerDefaultSlotAccess(AccessRule.Import, 1);
        handler.registerDefaultSlotAccess(AccessRule.Export, 2);
        handler.registerDefaultSlotsForSide(RotationList.UP.invert(), 0, 2);
        handler.registerDefaultSlotsForSide(RotationList.DOWN.invert(), 1);
        handler.registerInputFilter(new ArrayFilter(CommonFilters.DischargeEU, new BasicItemFilter(Items.field_151137_ax), new BasicItemFilter(Ic2Items.suBattery)), 0);
        handler.registerOutputFilter(CommonFilters.NotDischargeEU, 0);
        handler.registerInputFilter(CommonFilters.rareEarth, 1);
        handler.registerSlotType(SlotType.Discharge, 0);
        handler.registerSlotType(SlotType.Input, 1);
        handler.registerSlotType(SlotType.Output, 2);
    }

    @Override
    protected void addComparators(ComparatorManager manager) {
        super.addComparators(manager);
        manager.addComparatorMode(new ComparatorProgress(this));
        manager.addComparatorMode(new ComparatorSecondaryProgress(this));
    }

    @Override
    public NetworkField.BitLevel getOverride(int fieldID, String fieldName) {
        return NetworkField.BitLevel.Bit16;
    }

    @Override
    public boolean hasOverride(int fieldID, String fieldName) {
        return fieldID == 3 || fieldID == 4;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.progress = nbt.func_74762_e("Progress");
        this.rareEarth = nbt.func_74760_g("Earth");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("Progress", this.progress);
        nbt.func_74776_a("Earth", this.rareEarth);
        return nbt;
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerRareEarthExtractor(player.field_71071_by, this);
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return MachineGui.RareEarthGui.class;
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return !this.func_145837_r();
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return true;
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.rareEarthExtractor;
    }

    public float getRecipeValue(ItemStack input) {
        return ClassicRecipes.earthExtractor.getEarthValue(input);
    }

    @Override
    public float getProgress() {
        return this.progress;
    }

    @Override
    public float getMaxProgress() {
        return 35.0f;
    }

    @Override
    public float getSecondaryProgress() {
        return this.rareEarth;
    }

    @Override
    public float getMaxSecondaryProgress() {
        return 1000.0f;
    }

    @Override
    public boolean supportsNotify() {
        return true;
    }

    public void func_73660_a() {
        this.updateNeighbors();
        this.handleChargeSlot(1120);
        if (!((ItemStack)this.inventory.get(1)).func_190926_b()) {
            if (this.hasEnergy(1)) {
                float value = this.getRecipeValue((ItemStack)this.inventory.get(1));
                if (value > 0.0f && this.canAdd(value)) {
                    this.setActive(true);
                    ++this.progress;
                    this.useEnergy(1);
                    if (this.progress >= 35) {
                        this.rareEarth += value;
                        this.progress = 0;
                        ItemStack stack = (ItemStack)this.inventory.get(1);
                        if (stack.func_77973_b().hasContainerItem(stack)) {
                            this.inventory.set(1, (Object)stack.func_77973_b().getContainerItem(stack));
                        } else {
                            stack.func_190918_g(1);
                        }
                        if (this.rareEarth >= 1000.0f) {
                            this.rareEarth -= 1000.0f;
                            if (((ItemStack)this.inventory.get(2)).func_190926_b()) {
                                this.inventory.set(2, (Object)Ic2Items.rareEarthDust.func_77946_l());
                            } else {
                                ((ItemStack)this.inventory.get(2)).func_190917_f(1);
                            }
                        }
                        this.getNetwork().updateTileGuiField(this, "rareEarth");
                        this.notifyNeighbors();
                    }
                    this.getNetwork().updateTileGuiField(this, "progress");
                } else if (value <= 0.0f) {
                    this.setActive(false);
                    if (this.progress != 0) {
                        this.progress = 0;
                        this.getNetwork().updateTileGuiField(this, "progress");
                    }
                }
            } else {
                this.setActive(false);
            }
        } else {
            this.setActive(false);
            if (this.progress != 0) {
                this.progress = 0;
                this.getNetwork().updateTileGuiField(this, "progress");
            }
        }
        this.updateComparators();
    }

    private boolean canAdd(float value) {
        if (this.rareEarth + value < 1000.0f) {
            return true;
        }
        if (((ItemStack)this.inventory.get(2)).func_190926_b()) {
            return true;
        }
        if (StackUtil.isStackEqual((ItemStack)this.inventory.get(2), Ic2Items.rareEarthDust)) {
            return ((ItemStack)this.inventory.get(2)).func_190916_E() < ((ItemStack)this.inventory.get(2)).func_77976_d();
        }
        return false;
    }

    public static void init() {
        TileEntityRareEarthExtractor.addItems(3.125f, new ItemStack(Blocks.field_150347_e));
        TileEntityRareEarthExtractor.addItems(3.125f, new ItemStack(Blocks.field_150348_b, 1, 1));
        TileEntityRareEarthExtractor.addItems(3.125f, new ItemStack(Blocks.field_150348_b, 1, 3));
        TileEntityRareEarthExtractor.addItems(3.125f, new ItemStack(Blocks.field_150348_b, 1, 5));
        TileEntityRareEarthExtractor.addItems(7.8125f, new ItemStack(Blocks.field_150424_aL));
        TileEntityRareEarthExtractor.addItems(15.25f, new ItemStack((Block)Blocks.field_150391_bh));
        TileEntityRareEarthExtractor.addItems(20.84f, new ItemStack(Items.field_151119_aD));
        TileEntityRareEarthExtractor.addItems(100.0f, new ItemStack(Blocks.field_150343_Z), new ItemStack(Blocks.field_150425_aM));
    }

    public static void addItems(float value, ItemStack ... items) {
        ClassicRecipes.earthExtractor.registerValue(value, items);
    }
}

