/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.low;

import ic2.api.classic.network.adv.NetworkField;
import ic2.api.classic.tile.machine.IFuelMachine;
import ic2.api.classic.tile.machine.IProgressMachine;
import ic2.api.info.Info;
import ic2.core.RotationList;
import ic2.core.block.base.tile.TileEntityMachine;
import ic2.core.block.base.util.comparator.ComparatorManager;
import ic2.core.block.base.util.comparator.comparators.ComparatorFuelMachine;
import ic2.core.block.base.util.comparator.comparators.ComparatorProgress;
import ic2.core.block.base.util.info.FuelMachineInfo;
import ic2.core.block.base.util.info.ProgressInfo;
import ic2.core.block.base.util.info.misc.IPumpTile;
import ic2.core.block.machine.low.container.ContainerWoodGasser;
import ic2.core.fluid.IC2Fluid;
import ic2.core.fluid.IC2Tank;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.filters.BasicItemFilter;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.inventory.filters.OreFilter;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.inventory.management.SlotType;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ITankListener;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class TileEntityWoodGasser
extends TileEntityMachine
implements ITickable,
IProgressMachine,
IFuelMachine,
IHasGui,
ITankListener,
IPumpTile {
    @NetworkField(index=3)
    public IC2Tank gasTank = new IC2Tank(9000);
    public static int maxTicks = 160;
    @NetworkField(index=4, compression=NetworkField.BitLevel.Bit8)
    public int ticksLeft = 0;
    @NetworkField(index=5)
    public int fuel = 0;
    @NetworkField(index=6)
    public int maxFuel = 0;

    public TileEntityWoodGasser() {
        super(4);
        this.addGuiFields("ticksLeft", "fuel", "maxFuel", "gasTank");
        this.gasTank.setCanFill(false);
        this.gasTank.addListener(this);
        this.addInfos(new FuelMachineInfo(this), new ProgressInfo(this));
    }

    @Override
    protected void addComparators(ComparatorManager manager) {
        super.addComparators(manager);
        manager.addComparatorMode(new ComparatorProgress(this));
        manager.addComparatorMode(new ComparatorFuelMachine(this));
    }

    @Override
    protected void addSlots(InventoryHandler handler) {
        handler.registerDefaultSideAccess(AccessRule.Both, RotationList.ALL);
        handler.registerDefaultSlotAccess(AccessRule.Both, 0);
        handler.registerDefaultSlotAccess(AccessRule.Import, 1, 3);
        handler.registerDefaultSlotAccess(AccessRule.Export, 2);
        handler.registerDefaultSlotsForSide(RotationList.UP.invert(), 0, 2);
        handler.registerDefaultSlotsForSide(RotationList.DOWN.invert(), 1, 3);
        handler.registerInputFilter(CommonFilters.IronFurnaceFuelWithLava, 0);
        handler.registerOutputFilter(CommonFilters.NotIronFurnaceFuelWithLava, 0);
        handler.registerInputFilter(new OreFilter("logWood"), 1);
        handler.registerInputFilter(new BasicItemFilter(Ic2Items.emptyCell.func_77946_l()), 3);
        handler.registerSlotType(SlotType.Fuel, 0);
        handler.registerSlotType(SlotType.Input, 1, 3);
        handler.registerSlotType(SlotType.Output, 2);
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerWoodGasser(player.field_71071_by, this);
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiComponentContainer.class;
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return true;
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return !this.func_145837_r();
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.woodGasser;
    }

    @Override
    public float getProgress() {
        if (this.ticksLeft == 0) {
            return 0.0f;
        }
        return maxTicks - this.ticksLeft;
    }

    @Override
    public float getMaxProgress() {
        return maxTicks;
    }

    @Override
    public float getFuel() {
        return this.fuel;
    }

    @Override
    public float getMaxFuel() {
        return this.maxFuel;
    }

    @Override
    public int getPumpCharge() {
        return this.gasTank.getFluidAmount();
    }

    @Override
    public int getMaxPumpCharge() {
        return this.gasTank.getCapacity();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.gasTank.readFromNBT(nbt.func_74775_l("Tank"));
        this.ticksLeft = nbt.func_74762_e("TicksLeft");
        this.fuel = nbt.func_74762_e("Fuel");
        this.maxFuel = nbt.func_74762_e("MaxFuel");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.gasTank.writeToNBT(this.getTag(nbt, "Tank"));
        nbt.func_74768_a("TicksLeft", this.ticksLeft);
        nbt.func_74768_a("Fuel", this.fuel);
        nbt.func_74768_a("MaxFuel", this.maxFuel);
        return nbt;
    }

    public void func_73660_a() {
        if (this.fuel <= 0 && this.canBurn() && !((ItemStack)this.inventory.get(0)).func_190926_b() && this.gasTank.getFluidAmount() <= 8000 && this.hasCharcoalRoom()) {
            int newValue = Info.itemInfo.getFuelValue((ItemStack)this.inventory.get(0), true);
            this.fuel += newValue;
            this.maxFuel = newValue;
            this.getNetwork().updateTileGuiField(this, "maxFuel");
            this.getNetwork().updateTileGuiField(this, "fuel");
            if (this.fuel > 0) {
                if (((ItemStack)this.inventory.get(0)).func_77973_b().hasContainerItem((ItemStack)this.inventory.get(0))) {
                    this.inventory.set(0, (Object)((ItemStack)this.inventory.get(0)).func_77973_b().getContainerItem((ItemStack)this.inventory.get(0)));
                } else {
                    ((ItemStack)this.inventory.get(0)).func_190918_g(1);
                }
            }
            this.setActive(this.fuel > 0);
        }
        if (this.isBurning()) {
            if (this.ticksLeft <= 0 && this.gasTank.getFluidAmount() <= 8000 && !((ItemStack)this.inventory.get(1)).func_190926_b() && StackUtil.hasOreTag("logWood", (ItemStack)this.inventory.get(1)) && this.hasCharcoalRoom()) {
                this.ticksLeft = 160;
                this.getNetwork().updateTileGuiField(this, "ticksLeft");
                ((ItemStack)this.inventory.get(1)).func_190918_g(1);
            }
            if (this.ticksLeft > 0 && (this.ticksLeft >= 2 || this.ticksLeft <= 1 && this.hasCharcoalRoom())) {
                --this.ticksLeft;
                this.getNetwork().updateTileGuiField(this, "ticksLeft");
                this.gasTank.fillInternal(IC2Fluid.getFluidStack("woodgas", 6), true);
                if (this.ticksLeft <= 0) {
                    this.gasTank.fillInternal(IC2Fluid.getFluidStack("woodgas", 40), true);
                    if (((ItemStack)this.inventory.get(2)).func_190926_b()) {
                        this.inventory.set(2, (Object)new ItemStack(Items.field_151044_h, 1, 1));
                    } else if (StackUtil.isStackEqual((ItemStack)this.inventory.get(2), new ItemStack(Items.field_151044_h, 1, 1))) {
                        ((ItemStack)this.inventory.get(2)).func_190917_f(1);
                    }
                }
            }
            --this.fuel;
            this.getNetwork().updateTileGuiField(this, "fuel");
        }
        if (this.getActive() != this.isBurning()) {
            this.setActive(false);
        }
        if (this.field_145850_b.func_82737_E() % 10L == 0L) {
            this.processCell();
        }
        this.updateComparators();
    }

    public void processCell() {
        if (this.gasTank.getFluidAmount() < 1000) {
            return;
        }
        if (!StackUtil.isStackEqual((ItemStack)this.inventory.get(3), Ic2Items.emptyCell)) {
            return;
        }
        if (!this.hasCellRoom()) {
            return;
        }
        this.gasTank.drain(1000, true);
        ((ItemStack)this.inventory.get(3)).func_190918_g(1);
        if (((ItemStack)this.inventory.get(2)).func_190926_b()) {
            this.inventory.set(2, (Object)Ic2Items.woodGasCell.func_77946_l());
        } else {
            ((ItemStack)this.inventory.get(2)).func_190917_f(1);
        }
    }

    public boolean isBurning() {
        return this.fuel > 0;
    }

    public boolean canBurn() {
        if (this.ticksLeft > 0) {
            return true;
        }
        if (((ItemStack)this.inventory.get(1)).func_190926_b()) {
            return false;
        }
        return StackUtil.hasOreTag("logWood", (ItemStack)this.inventory.get(1));
    }

    public boolean hasCharcoalRoom() {
        if (((ItemStack)this.inventory.get(2)).func_190926_b()) {
            return true;
        }
        if (StackUtil.isStackEqual((ItemStack)this.inventory.get(2), new ItemStack(Items.field_151044_h, 1, 1))) {
            return ((ItemStack)this.inventory.get(2)).func_190916_E() < ((ItemStack)this.inventory.get(2)).func_77976_d();
        }
        return false;
    }

    public boolean hasCellRoom() {
        if (((ItemStack)this.inventory.get(2)).func_190926_b()) {
            return true;
        }
        if (StackUtil.isStackEqual((ItemStack)this.inventory.get(2), Ic2Items.woodGasCell)) {
            return ((ItemStack)this.inventory.get(2)).func_190916_E() < ((ItemStack)this.inventory.get(2)).func_77976_d();
        }
        return false;
    }

    @Override
    public void onTankChanged(IFluidTank tank) {
        this.getNetwork().updateTileGuiField(this, "gasTank");
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.gasTank;
        }
        return super.getCapability(capability, facing);
    }
}

