/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.misc;

import ic2.api.classic.energy.tile.IEnergyConductorColored;
import ic2.core.block.misc.tile.TileEntityTexturedWall;
import ic2.core.block.render.model.BlockCopyModel;
import ic2.core.platform.lang.ILocaleBlock;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2States;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.platform.textures.models.BaseModel;
import ic2.core.platform.textures.obj.ICustomModeledBlock;
import ic2.core.util.helpers.BlockStateContainerIC2;
import ic2.core.util.obj.IBootable;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTexturedWall
extends BlockContainer
implements ICustomModeledBlock,
IBootable,
ILocaleBlock {
    public BlockTexturedWall() {
        super(Material.field_151576_e);
        this.func_149711_c(3.0f);
        this.func_149752_b(30.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.setHarvestLevel("pickaxe", 0);
    }

    public String func_149739_a() {
        return this.getName().getUnlocalized();
    }

    public String func_149732_F() {
        return this.getName().getLocalized();
    }

    @Override
    public LocaleComp getName() {
        return Ic2BlockLang.texturedWall;
    }

    @Override
    public void onLoad() {
        Ic2States.texturedWall = this.func_176203_a(0);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityTexturedWall();
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    protected ItemStack func_180643_i(IBlockState state) {
        return ItemStack.field_190927_a;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityTexturedWall) {
            TileEntityTexturedWall textured = (TileEntityTexturedWall)tile;
            try {
                IBlockState realState = textured.storage.getEntry(target.field_178784_b.func_176745_a()).getModelState();
                return realState.func_177230_c().getPickBlock(realState, target, world, pos, player);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Ic2Items.constructionFoam.func_77946_l();
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityTexturedWall) {
            return new BlockStateContainerIC2.IC2BlockState(state, ((TileEntityTexturedWall)tile).getStorage().getQuads());
        }
        return state;
    }

    public boolean recolorBlock(World world, BlockPos pos, EnumFacing side, EnumDyeColor color) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityTexturedWall) {
            TileEntityTexturedWall text = (TileEntityTexturedWall)tile;
            if (side == null) {
                world.func_175656_a(pos, Ic2States.cfWallBlack.func_177230_c().func_176203_a(color.func_176767_b()));
                return true;
            }
            return text.changeColor(IEnergyConductorColored.WireColor.values()[color.func_176767_b() + 1], side);
        }
        return false;
    }

    @Override
    public List<IBlockState> getValidModelStates() {
        return Arrays.asList(this.func_176203_a(0));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BaseModel getModelFromState(IBlockState state) {
        return BlockCopyModel.getFoamModel(Ic2Icons.getTextures("bcable")[195]);
    }

    @Override
    public IBlockState getStateFromStack(ItemStack stack) {
        return null;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }
}

