/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring.cables.types;

import ic2.api.classic.energy.tile.IEnergyConductorColored;
import ic2.core.block.wiring.cables.types.CableBase;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Items;
import net.minecraft.item.ItemStack;

public class IronCable
extends CableBase {
    @Override
    public int getMaxInsulationTypes() {
        return 3;
    }

    @Override
    public double getConductorLoss(int insulation) {
        switch (insulation) {
            case 0: {
                return 1.0;
            }
            case 1: {
                return 0.95;
            }
            case 2: {
                return 0.9;
            }
            case 3: {
                return 0.8;
            }
        }
        return 0.0;
    }

    @Override
    public double getInsulationEnergyAbsorption(int insulation) {
        switch (insulation) {
            case 0: {
                return 0.0;
            }
            case 1: {
                return 128.0;
            }
            case 2: {
                return 512.0;
            }
            case 3: {
                return 9001.0;
            }
        }
        return 0.0;
    }

    @Override
    public double getInsulationBreakdownEnergy(int insulation) {
        return 9001.0;
    }

    @Override
    public double getConductorBreakdownEnergy(int insulation) {
        return 2049.0;
    }

    @Override
    public double getConductorThickness(int insulation) {
        switch (insulation) {
            case 0: {
                return 6.0;
            }
            case 1: {
                return 8.0;
            }
            case 2: {
                return 10.0;
            }
            case 3: {
                return 12.0;
            }
        }
        return 0.0;
    }

    @Override
    public int getTexture(int insulation, IEnergyConductorColored.WireColor color, boolean active) {
        switch (insulation) {
            case 0: {
                return 85 + color.ordinal();
            }
            case 1: {
                return 102 + color.ordinal();
            }
            case 2: {
                return 119 + color.ordinal();
            }
            case 3: {
                return 136 + color.ordinal();
            }
        }
        return 85;
    }

    @Override
    public int getItemIcon(int insulation) {
        return 101 + insulation;
    }

    @Override
    public LocaleComp getName(int insulation) {
        switch (insulation) {
            case 0: {
                return Ic2ItemLang.ironCable;
            }
            case 1: {
                return Ic2ItemLang.ironCableInsulated;
            }
            case 2: {
                return Ic2ItemLang.ironCableDoubleInsulated;
            }
            case 3: {
                return Ic2ItemLang.ironCableTripleInsulated;
            }
        }
        return super.getName(insulation);
    }

    @Override
    public ItemStack getDrops(int insulation) {
        switch (insulation) {
            case 1: {
                return Ic2Items.insulatedIronCable.func_77946_l();
            }
            case 2: {
                return Ic2Items.doubleInsulatedIronCable.func_77946_l();
            }
            case 3: {
                return Ic2Items.tribbleInsulatedIronCable.func_77946_l();
            }
        }
        return Ic2Items.ironCable.func_77946_l();
    }

    @Override
    public boolean canProvideRedstone() {
        return false;
    }
}

