/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.inventory.gui.components.reactorPlanner;

import ic2.core.IC2;
import ic2.core.block.machine.med.TileEntityReactorPlanner;
import ic2.core.block.machine.med.logic.encoder.ByteShifter;
import ic2.core.inventory.gui.GuiIC2;
import ic2.core.inventory.gui.components.GuiComponent;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.util.math.Box2D;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public abstract class ReactorPlannerTypeBaseComp
extends GuiComponent {
    ItemStack display;
    TileEntityReactorPlanner planner;
    boolean steam;

    public ReactorPlannerTypeBaseComp(Box2D box, boolean isSteam, ItemStack stack, TileEntityReactorPlanner tile) {
        super(box);
        this.display = stack;
        this.steam = isSteam;
        this.planner = tile;
    }

    public abstract LocaleComp getName();

    @Override
    public List<GuiComponent.ActionRequest> getNeededRequests() {
        return Arrays.asList(GuiComponent.ActionRequest.BackgroundDraw, GuiComponent.ActionRequest.MouseClick, GuiComponent.ActionRequest.GuiInit, GuiComponent.ActionRequest.ToolTip);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(GuiIC2 gui, int mouseX, int mouseY, float particalTicks) {
        Box2D box = this.getPosition();
        this.drawTopTab(gui, box.getX(), box.getY(), this.display, this.planner.isSteamReactor == this.steam);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onToolTipCollecting(GuiIC2 gui, int mouseX, int mouseY, List<String> tooltips) {
        if (this.isMouseOver(mouseX, mouseY)) {
            tooltips.add(this.getName().getLocalized());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onMouseClick(GuiIC2 gui, int mouseX, int mouseY, int mouseButton) {
        if (this.planner.isSteamReactor == this.steam) {
            return false;
        }
        IC2.audioManager.playOnce(this.planner, SoundEvents.field_187909_gi.func_187503_a());
        ByteShifter shifter = new ByteShifter();
        shifter.writeInteger(1, 1);
        shifter.writeInteger(3, 3);
        this.planner.getNetwork().initiateClientTileEntityEvent(this.planner, shifter.getEncodedData(), this.steam ? 1 : 0);
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    private void drawTopTab(GuiIC2 gui, int xOffset, int yOffset, ItemStack item, boolean enabled) {
        int x = gui.getXOffset();
        int y = gui.getYOffset();
        RenderItem render = gui.getRenderItem();
        GL11.glPushMatrix();
        gui.func_73729_b(x + xOffset, y + yOffset, enabled ? 46 : 18, 212, 28, enabled ? 31 : 28);
        RenderHelper.func_74520_c();
        gui.setZLevel(200);
        render.field_77023_b = 200.0f;
        render.func_180450_b(item, x + xOffset + 6, y + yOffset + 8);
        gui.setZLevel(0);
        render.field_77023_b = 0.0f;
        RenderHelper.func_74518_a();
        GL11.glPopMatrix();
        GlStateManager.func_179144_i((int)gui.getTextureObject().func_110552_b());
    }
}

