/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.reactor;

import ic2.core.block.machine.high.TileEntityUraniumEnricher;
import ic2.core.item.reactor.base.ItemUraniumRodBase;
import ic2.core.item.reactor.uranTypes.BlazeUranium;
import ic2.core.item.reactor.uranTypes.CharcoalUranium;
import ic2.core.item.reactor.uranTypes.EnderUranium;
import ic2.core.item.reactor.uranTypes.IUranium;
import ic2.core.item.reactor.uranTypes.NetherStarUranium;
import ic2.core.item.reactor.uranTypes.RedstoneUranium;
import ic2.core.item.reactor.uranTypes.StandartUranium;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.obj.IBootable;
import java.util.Arrays;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class ItemReactorUraniumRod
extends ItemUraniumRodBase
implements IBootable {
    public static int[] numberOfCells = new int[]{1, 2, 4};
    public static String[] stringOfCells = new String[]{"Simple", "Dual", "Quad"};
    public static IUranium[] types = new IUranium[0];

    public ItemReactorUraniumRod() {
        this.setUnlocalizedName(Ic2ItemLang.uraniumRod);
        this.func_77627_a(true);
    }

    @Override
    public void onLoad() {
        types = new IUranium[6];
        ItemReactorUraniumRod.types[0] = new StandartUranium();
        ItemReactorUraniumRod.types[1] = new RedstoneUranium();
        ItemReactorUraniumRod.types[2] = new BlazeUranium();
        ItemReactorUraniumRod.types[3] = new EnderUranium();
        ItemReactorUraniumRod.types[4] = new NetherStarUranium();
        ItemReactorUraniumRod.types[5] = new CharcoalUranium();
        TileEntityUraniumEnricher.RECIPE_LIST.addAll(Arrays.asList(types));
        Ic2Items.reactorUraniumRodSingle = new ItemStack((Item)this, 1, 0);
        Ic2Items.reactorUraniumRodDual = new ItemStack((Item)this, 1, 1);
        Ic2Items.reactorUraniumRodQuad = new ItemStack((Item)this, 1, 2);
        Ic2Items.reactorRedstoneUraniumRodSingle = new ItemStack((Item)this, 1, 3);
        Ic2Items.reactorRedstoneUraniumRodDual = new ItemStack((Item)this, 1, 4);
        Ic2Items.reactorRedstoneUraniumRodQuad = new ItemStack((Item)this, 1, 5);
        Ic2Items.reactorBlazeUraniumRodSingle = new ItemStack((Item)this, 1, 6);
        Ic2Items.reactorBlazeUraniumRodDual = new ItemStack((Item)this, 1, 7);
        Ic2Items.reactorBlazeUraniumRodQuad = new ItemStack((Item)this, 1, 8);
        Ic2Items.reactorEnderPearlUraniumRodSingle = new ItemStack((Item)this, 1, 9);
        Ic2Items.reactorEnderPearlUraniumRodDual = new ItemStack((Item)this, 1, 10);
        Ic2Items.reactorEnderPearlUraniumRodQuad = new ItemStack((Item)this, 1, 11);
        Ic2Items.reactorNetherStarUraniumRodSingle = new ItemStack((Item)this, 1, 12);
        Ic2Items.reactorNetherStarUraniumRodDual = new ItemStack((Item)this, 1, 13);
        Ic2Items.reactorNetherStarUraniumRodQuad = new ItemStack((Item)this, 1, 14);
        Ic2Items.reactorCharcoalUraniumRodSingle = new ItemStack((Item)this, 1, 15);
        Ic2Items.reactorCharcoalUraniumRodDual = new ItemStack((Item)this, 1, 16);
        Ic2Items.reactorCharcoalUraniumRodQuad = new ItemStack((Item)this, 1, 17);
    }

    @Override
    public List<Integer> getValidVariants() {
        return Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17);
    }

    @Override
    public int getTextureEntry(int meta) {
        return 0;
    }

    @Override
    public IUranium getUranium(ItemStack stack) {
        return this.getUranium(stack.func_77960_j());
    }

    @Override
    public IUranium.RodType getRodType(ItemStack stack) {
        return this.getRodType(stack.func_77960_j());
    }

    @Override
    public int getRodAmount(ItemStack stack) {
        return numberOfCells[stack.func_77960_j() % 3];
    }

    @Override
    public IUranium getUranium(int metadata) {
        return ItemReactorUraniumRod.getUran(metadata / 3);
    }

    @Override
    public IUranium.RodType getRodType(int metadata) {
        switch (metadata % 3) {
            case 1: {
                return IUranium.RodType.DualRod;
            }
            case 2: {
                return IUranium.RodType.QuadRod;
            }
        }
        return IUranium.RodType.SingleRod;
    }

    public static IUranium getUran(int type) {
        if (type >= types.length) {
            return types[0];
        }
        return types[type];
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (IUranium.RodType rod : Arrays.asList(IUranium.RodType.SingleRod, IUranium.RodType.DualRod, IUranium.RodType.QuadRod)) {
            for (int i = 0; i < types.length; ++i) {
                IUranium uran = types[i];
                if (uran == null) continue;
                items.add((Object)uran.getRodType(rod));
            }
        }
    }

    @Override
    public ItemStack[] getSubParts() {
        ItemStack[] items = new ItemStack[types.length * 3];
        IUranium.RodType[] rodTypes = new IUranium.RodType[]{IUranium.RodType.SingleRod, IUranium.RodType.DualRod, IUranium.RodType.QuadRod};
        for (int i = 0; i < types.length; ++i) {
            int step = i * 3;
            for (int x = 0; x < rodTypes.length; ++x) {
                items[step + x] = types[i].getRodType(rodTypes[x]);
            }
        }
        return items;
    }

    @Override
    public boolean hasSubParts() {
        return true;
    }

    @Override
    public ItemStack getReactorPart() {
        return ItemStack.field_190927_a;
    }
}

