/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.compat.jei;

import cubex2.cs4.api.TileEntityModuleSupplier;
import cubex2.cs4.plugins.jei.JEIRecipe;
import cubex2.cs4.plugins.vanilla.ContentGuiContainer;
import cubex2.cs4.plugins.vanilla.ContentTileEntityBase;
import cubex2.cs4.plugins.vanilla.TileEntityRegistry;
import cubex2.cs4.plugins.vanilla.gui.FluidDisplay;
import cubex2.cs4.plugins.vanilla.gui.SlotData;
import cubex2.cs4.plugins.vanilla.tileentity.TileEntityModuleTank;
import java.util.Map;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import org.apache.commons.lang3.tuple.Pair;

public abstract class BaseRecipeCategory<R extends JEIRecipe, T extends IRecipeWrapper, M extends TileEntityModuleSupplier>
implements IRecipeCategory<T> {
    private final String uid;
    private final String title;
    private final IDrawable background;
    private final ContentGuiContainer gui;
    protected final ContentTileEntityBase tileEntity;
    protected final M module;
    private final String moduleName;
    private final R recipe;

    protected BaseRecipeCategory(R recipe, IGuiHelper guiHelper, Class<M> moduleClass) {
        this.recipe = recipe;
        this.uid = ((JEIRecipe)recipe).getUid();
        this.title = ((JEIRecipe)recipe).title;
        this.gui = ((JEIRecipe)recipe).getGui();
        this.tileEntity = TileEntityRegistry.getContent(((JEIRecipe)recipe).tileEntity);
        Pair<String, M> pair = this.getModule(moduleClass);
        this.moduleName = (String)pair.getLeft();
        this.module = (TileEntityModuleSupplier)pair.getRight();
        this.background = guiHelper.createDrawable(this.gui.bg, ((JEIRecipe)recipe).bgX, ((JEIRecipe)recipe).bgY, ((JEIRecipe)recipe).bgWidth, ((JEIRecipe)recipe).bgHeight);
    }

    public R getRecipe() {
        return this.recipe;
    }

    public String getModName() {
        return ((JEIRecipe)this.recipe).getModId();
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public M getModule() {
        return this.module;
    }

    private Pair<String, M> getModule(Class<M> clazz) {
        if (((JEIRecipe)this.recipe).module == null) {
            for (Map.Entry<String, TileEntityModuleSupplier> entry : this.tileEntity.modules.entrySet()) {
                if (!clazz.isAssignableFrom(entry.getValue().getClass())) continue;
                return Pair.of((Object)entry.getKey(), (Object)entry.getValue());
            }
        } else {
            return Pair.of((Object)((JEIRecipe)this.recipe).module, (Object)this.tileEntity.modules.get(((JEIRecipe)this.recipe).module));
        }
        throw new RuntimeException("No machine module found");
    }

    public String getUid() {
        return this.uid;
    }

    public String getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, T recipeWrapper, IIngredients ingredients) {
        if (((JEIRecipe)this.recipe).transferButtonX >= 0 && ((JEIRecipe)this.recipe).transferButtonY >= 0) {
            recipeLayout.setRecipeTransferButton(((JEIRecipe)this.recipe).transferButtonX - ((JEIRecipe)this.recipe).bgX, ((JEIRecipe)this.recipe).transferButtonY - ((JEIRecipe)this.recipe).bgY);
        }
    }

    protected void initFluids(IGuiFluidStackGroup fluids, boolean input, String[] tanks, int startSlot) {
        for (int i = 0; i < tanks.length; ++i) {
            TileEntityModuleTank.Supplier tank = this.findTank(tanks[i]);
            FluidDisplay display = this.findFluidDisplay(tanks[i]);
            if (tank == null || display == null) continue;
            fluids.init(startSlot + i, input, display.x - ((JEIRecipe)this.recipe).bgX, display.y - ((JEIRecipe)this.recipe).bgY, display.width, display.height, tank.capacity, false, null);
        }
    }

    protected void initItems(IGuiItemStackGroup stacks, boolean input, int slots, int startSlot) {
        for (int i = 0; i < slots; ++i) {
            SlotData data = this.findModuleSlot(startSlot + i);
            if (data == null) continue;
            stacks.init(startSlot + i, input, data.getX(data.getColumn(i)) - ((JEIRecipe)this.recipe).bgX - 1, data.getY(data.getRow(i)) - ((JEIRecipe)this.recipe).bgY - 1);
        }
    }

    @Nullable
    private SlotData findModuleSlot(int index) {
        for (SlotData data : this.gui.slots) {
            if (!data.name.equals(this.moduleName) || !data.containsIndex(index)) continue;
            return data;
        }
        return null;
    }

    @Nullable
    private TileEntityModuleTank.Supplier findTank(String name) {
        TileEntityModuleSupplier module = this.tileEntity.modules.get(name);
        if (module instanceof TileEntityModuleTank.Supplier) {
            return (TileEntityModuleTank.Supplier)module;
        }
        return null;
    }

    @Nullable
    private FluidDisplay findFluidDisplay(String name) {
        for (FluidDisplay display : this.gui.fluidDisplays) {
            if (!display.source.equals(name)) continue;
            return display;
        }
        return null;
    }
}

