/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.plugins.vanilla;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;

class NamedMapDeserializer<T>
implements JsonDeserializer<Map<String, T>> {
    private final Class<T> clazz;

    NamedMapDeserializer(Class<T> clazz) {
        this.clazz = clazz;
    }

    public Map<String, T> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        LinkedHashMap map = Maps.newLinkedHashMap();
        JsonArray array = json.getAsJsonArray();
        for (JsonElement element : array) {
            JsonObject object = element.getAsJsonObject();
            String name = object.get("name").getAsString();
            map.put(name, context.deserialize(element, this.clazz));
        }
        return map;
    }
}

