/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.features.zpm;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.yaml.YAMLConfigurationLoader;
import org.yaml.snakeyaml.DumperOptions;

public final class ZPMMultiplierRegistry {
    private static final Map<String, Map<String, Double>> multipliers = new HashMap<String, Map<String, Double>>();
    private static final String WORLDS_NODE = "worlds";

    public static ConfigurationNode createRootNode(Path path) throws IOException {
        YAMLConfigurationLoader loader = ((YAMLConfigurationLoader.Builder)YAMLConfigurationLoader.builder().setPath(path)).setFlowStyle(DumperOptions.FlowStyle.BLOCK).build();
        if (Files.notExists(path, new LinkOption[0])) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.createFile(path, new FileAttribute[0]);
            ConfigurationNode node = loader.createEmptyNode(ConfigurationOptions.defaults());
            node.getNode(WORLDS_NODE, "world", "DIM-1").setValue(0);
            node.getNode(WORLDS_NODE, "world", "DIM1").setValue(1);
            loader.save(node);
        }
        return loader.load(ConfigurationOptions.defaults());
    }

    public static void populateMultipliers(ConfigurationNode root) {
        Preconditions.checkNotNull((Object)root);
        multipliers.clear();
        ConfigurationNode worldsRoot = root.getNode(WORLDS_NODE);
        for (Map.Entry<Object, ? extends ConfigurationNode> fromEntry : worldsRoot.getChildrenMap().entrySet()) {
            String from = fromEntry.getKey().toString().toLowerCase();
            ConfigurationNode fromNode = fromEntry.getValue();
            Map fromMultipliers = multipliers.computeIfAbsent(from, k -> new HashMap());
            for (Map.Entry<Object, ? extends ConfigurationNode> toEntry : fromNode.getChildrenMap().entrySet()) {
                String to = toEntry.getKey().toString().toLowerCase();
                double multiplier = toEntry.getValue().getDouble(0.0);
                fromMultipliers.put(to, multiplier);
            }
        }
    }

    public static Optional<Double> getMultiplierFrom(String from, String to) {
        Preconditions.checkNotNull((Object)from);
        Preconditions.checkNotNull((Object)to);
        Map<String, Double> toMultipliers = multipliers.get(from.toLowerCase());
        if (toMultipliers == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(toMultipliers.get(to.toLowerCase()));
    }
}

