/*
 * Decompiled with CFR 0.152.
 */
package net.modcrafters.mclib.inventory.implementations;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.modcrafters.mclib.ingredients.IFluidIngredient;
import net.modcrafters.mclib.ingredients.IItemIngredient;
import net.modcrafters.mclib.ingredients.IMachineIngredient;
import net.modcrafters.mclib.ingredients.IngredientAmountMatch;
import net.modcrafters.mclib.inventory.IItemInventory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lnet/modcrafters/mclib/inventory/implementations/ItemInventory;", "Lnet/modcrafters/mclib/inventory/IItemInventory;", "key", "", "handler", "Lnet/minecraftforge/items/IItemHandler;", "(Ljava/lang/String;Lnet/minecraftforge/items/IItemHandler;)V", "getKey", "()Ljava/lang/String;", "slots", "", "getSlots", "()I", "extractStack", "Lnet/minecraft/item/ItemStack;", "ingredient", "Lnet/modcrafters/mclib/ingredients/IMachineIngredient;", "fromSlot", "simulate", "", "getSlotContent", "slot", "tesla-core-lib"})
public class ItemInventory
implements IItemInventory {
    @NotNull
    private final String key;
    private final IItemHandler handler;

    @Override
    @NotNull
    public ItemStack extractStack(@NotNull IMachineIngredient ingredient, int fromSlot, boolean simulate) {
        IMachineIngredient iMachineIngredient;
        Intrinsics.checkParameterIsNotNull((Object)ingredient, (String)"ingredient");
        ItemStack source = this.getSlotContent(fromSlot);
        if (!ingredient.isMatch(this, fromSlot, IngredientAmountMatch.BE_ENOUGH) || (iMachineIngredient = ingredient) instanceof IItemIngredient || iMachineIngredient instanceof IFluidIngredient) {
            // empty if block
        }
        ItemStack itemStack = ItemStack.field_190927_a;
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"ItemStack.EMPTY");
        return itemStack;
    }

    @Override
    public int getSlots() {
        return this.handler.getSlots();
    }

    @Override
    @NotNull
    public ItemStack getSlotContent(int slot) {
        return this.handler.getStackInSlot(slot);
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    public ItemInventory(@NotNull String key, @NotNull IItemHandler handler) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        this.key = key;
        this.handler = handler;
    }

    @Override
    public int extract(@NotNull IMachineIngredient ingredient, int fromSlot, boolean simulate) {
        Intrinsics.checkParameterIsNotNull((Object)ingredient, (String)"ingredient");
        return IItemInventory.DefaultImpls.extract(this, ingredient, fromSlot, simulate);
    }

    @Override
    @NotNull
    public IMachineIngredient getIngredient(int slot) {
        return IItemInventory.DefaultImpls.getIngredient(this, slot);
    }
}

