/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.melee.item;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.client.particle.Particles;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.SwordCore;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.tools.TinkerTools;

public class LongSword
extends SwordCore {
    public static final float DURABILITY_MODIFIER = 1.05f;

    public LongSword() {
        super(PartMaterialType.handle(TinkerTools.toolRod), PartMaterialType.head(TinkerTools.swordBlade), PartMaterialType.extra(TinkerTools.handGuard));
        this.addCategory(Category.WEAPON);
    }

    @Override
    public float damagePotential() {
        return 1.1f;
    }

    @Override
    public double attackSpeed() {
        return 1.4;
    }

    @Override
    public float damageCutoff() {
        return 18.0f;
    }

    @Nonnull
    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 200;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        if (playerIn.func_184613_cA()) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStackIn);
        }
        playerIn.func_184598_c(hand);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    @Override
    public boolean dealDamage(ItemStack stack, EntityLivingBase player, Entity entity, float damage) {
        boolean hit = super.dealDamage(stack, player, entity, damage);
        if (hit && this.readyForSpecialAttack(player)) {
            TinkerTools.proxy.spawnAttackParticle(Particles.LONGSWORD_ATTACK, (Entity)player, 0.7);
        }
        return hit;
    }

    @Override
    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        this.preventSlowDown(entityIn, 0.9f);
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase player, int timeLeft) {
        int time = this.func_77626_a(stack) - timeLeft;
        if (time > 5) {
            if (player instanceof EntityPlayer) {
                EntityPlayer entityPlayer = (EntityPlayer)player;
                entityPlayer.func_71020_j(0.2f);
                entityPlayer.func_184811_cZ().func_185145_a(stack.func_77973_b(), 3);
            }
            player.func_70031_b(true);
            float increase = (float)(0.02 * (double)time + 0.2);
            if (increase > 0.56f) {
                increase = 0.56f;
            }
            player.field_70181_x += (double)increase;
            float speed = 0.05f * (float)time;
            if (speed > 0.925f) {
                speed = 0.925f;
            }
            player.field_70159_w = -MathHelper.func_76126_a((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI)) * speed;
            player.field_70179_y = MathHelper.func_76134_b((float)(player.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(player.field_70125_A / 180.0f * (float)Math.PI)) * speed;
        }
        super.func_77615_a(stack, world, player, timeLeft);
    }

    @Override
    public float getRepairModifierForPart(int index) {
        return 1.05f;
    }

    @Override
    public ToolNBT buildTagData(List<Material> materials) {
        ToolNBT data = this.buildDefaultTag(materials);
        data.attack += 0.5f;
        data.durability = (int)((float)data.durability * 1.05f);
        return data;
    }
}

