/*
 * Decompiled with CFR 0.152.
 */
package fluxnetworks.client;

import fluxnetworks.api.gui.EnumFeedbackInfo;
import fluxnetworks.api.translate.FluxTranslate;
import fluxnetworks.client.FluxColorHandler;
import fluxnetworks.client.render.FluxStorageModel;
import fluxnetworks.client.render.TileFluxStorageRenderer;
import fluxnetworks.common.CommonProxy;
import fluxnetworks.common.connection.FluxNetworkCache;
import fluxnetworks.common.handler.LocalizationHandler;
import fluxnetworks.common.registry.RegistryBlocks;
import fluxnetworks.common.registry.RegistryItems;
import fluxnetworks.common.tileentity.TileFluxStorage;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.Tuple;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ClientProxy
extends CommonProxy {
    private LocalizationHandler localizationHandler = new LocalizationHandler();
    private EnumFeedbackInfo feedbackInfo = EnumFeedbackInfo.NONE;
    private EnumFeedbackInfo feedbackInfoSuccess = EnumFeedbackInfo.NONE;
    private int feedbackTimer = 0;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        ClientRegistry.bindTileEntitySpecialRenderer(TileFluxStorage.class, (TileEntitySpecialRenderer)new TileFluxStorageRenderer());
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)FluxStorageModel.INSTANCE);
        IResourceManager manager = Minecraft.func_71410_x().func_110442_L();
        if (manager instanceof SimpleReloadableResourceManager) {
            SimpleReloadableResourceManager resources = (SimpleReloadableResourceManager)manager;
            resources.func_110542_a((IResourceManagerReloadListener)this.localizationHandler);
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        this.localizationHandler.add(FluxTranslate.INSTANCE);
    }

    @Override
    public void onServerStopped() {
        super.onServerStopped();
        FluxColorHandler.reset();
        FluxNetworkCache.instance.clearClientCache();
    }

    @Override
    public void registerItemModel(Item item, int meta, String variant) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), variant));
    }

    @SubscribeEvent
    public void clientFlux(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        this.onServerStopped();
    }

    @SubscribeEvent
    public void registerBlockColor(ColorHandlerEvent.Block event) {
        event.getBlockColors().func_186722_a((IBlockColor)FluxColorHandler.INSTANCE, new Block[]{RegistryBlocks.FLUX_CONTROLLER, RegistryBlocks.FLUX_POINT, RegistryBlocks.FLUX_PLUG, RegistryBlocks.FLUX_STORAGE_1, RegistryBlocks.FLUX_STORAGE_2, RegistryBlocks.FLUX_STORAGE_3});
    }

    @SubscribeEvent
    public void registerItemColor(ColorHandlerEvent.Item event) {
        event.getItemColors().func_186731_a((IItemColor)FluxColorHandler.INSTANCE, new Block[]{RegistryBlocks.FLUX_CONTROLLER, RegistryBlocks.FLUX_POINT, RegistryBlocks.FLUX_PLUG, RegistryBlocks.FLUX_STORAGE_1, RegistryBlocks.FLUX_STORAGE_2, RegistryBlocks.FLUX_STORAGE_3});
        event.getItemColors().func_186730_a(FluxColorHandler::colorMultiplierForConfigurator, new Item[]{RegistryItems.FLUX_CONFIGURATOR});
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        FluxColorHandler.sendRequests();
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && this.feedbackInfo.hasFeedback()) {
            ++this.feedbackTimer;
            if (this.feedbackTimer >= 60) {
                this.feedbackTimer = 0;
                this.setFeedback(EnumFeedbackInfo.NONE, false);
            }
        }
    }

    @Override
    public EnumFeedbackInfo getFeedback(boolean operation) {
        return operation ? this.feedbackInfoSuccess : this.feedbackInfo;
    }

    @Override
    public void setFeedback(EnumFeedbackInfo info, boolean operation) {
        if (operation) {
            this.feedbackInfoSuccess = info;
        } else {
            this.feedbackInfo = info;
        }
        this.feedbackTimer = 0;
    }

    @Override
    public void receiveColorCache(Map<Integer, Tuple<Integer, String>> cache) {
        FluxColorHandler.receiveCache(cache);
    }

    @Override
    public EntityPlayer getPlayer(MessageContext ctx) {
        return ctx.side.isServer() ? super.getPlayer(ctx) : Minecraft.func_71410_x().field_71439_g;
    }
}

