/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.common.block;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import sonar.core.api.blocks.IConnectedBlock;
import sonar.core.common.block.SonarBlock;
import sonar.core.common.block.SonarMaterials;
import sonar.core.utils.ISpecialTooltip;

public abstract class ConnectedTile
extends SonarBlock
implements IConnectedBlock,
ITileEntityProvider,
ISpecialTooltip {
    public int target;
    public static final PropertySonarFacing NORTH = PropertySonarFacing.create("north", EnumFacing.NORTH);
    public static final PropertySonarFacing EAST = PropertySonarFacing.create("east", EnumFacing.EAST);
    public static final PropertySonarFacing SOUTH = PropertySonarFacing.create("south", EnumFacing.SOUTH);
    public static final PropertySonarFacing WEST = PropertySonarFacing.create("west", EnumFacing.WEST);
    public static final PropertySonarFacing DOWN = PropertySonarFacing.create("down", EnumFacing.DOWN);
    public static final PropertySonarFacing UP = PropertySonarFacing.create("up", EnumFacing.UP);
    public static final ArrayList<PropertySonarFacing> faces = Lists.newArrayList((Object[])new PropertySonarFacing[]{DOWN, UP, NORTH, SOUTH, WEST, EAST});
    public static final ArrayList<PropertySonarFacing> horizontals = Lists.newArrayList((Object[])new PropertySonarFacing[]{NORTH, SOUTH, WEST, EAST});

    protected ConnectedTile(int target) {
        super(SonarMaterials.machine, false);
        this.target = target;
    }

    public boolean checkBlockInDirection(IBlockAccess world, int x, int y, int z, EnumFacing side) {
        IBlockState state = world.func_180495_p(new BlockPos(x, y, z));
        IBlockState block = world.func_180495_p(new BlockPos(x + side.func_82601_c(), y + side.func_96559_d(), z + side.func_82599_e()));
        int meta = state.func_177230_c().func_176201_c(state);
        return ConnectedTile.type(state, block, meta, block.func_177230_c().func_176201_c(block));
    }

    public static boolean type(IBlockState state1, IBlockState state2, int m1, int m2) {
        Block block1 = state1.func_177230_c();
        Block block2 = state2.func_177230_c();
        if (!(block1 instanceof IConnectedBlock && block2 instanceof IConnectedBlock && m1 != m2 || !(block1 instanceof IConnectedBlock))) {
            IConnectedBlock c1 = (IConnectedBlock)block1;
            int[] connections1 = ((IConnectedBlock)block1).getConnections();
            if (block2 instanceof IConnectedBlock) {
                int[] connections2 = ((IConnectedBlock)block2).getConnections();
                for (int aConnections1 : connections1) {
                    for (int aConnections2 : connections2) {
                        if (aConnections1 != aConnections2) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess w, BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.checkBlockInDirection(w, x, y, z, EnumFacing.NORTH))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.checkBlockInDirection(w, x, y, z, EnumFacing.SOUTH))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.checkBlockInDirection(w, x, y, z, EnumFacing.WEST))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.checkBlockInDirection(w, x, y, z, EnumFacing.EAST))).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(this.checkBlockInDirection(w, x, y, z, EnumFacing.UP))).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(this.checkBlockInDirection(w, x, y, z, EnumFacing.DOWN)));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, EAST, SOUTH, WEST, DOWN, UP});
    }

    @Override
    public int[] getConnections() {
        return new int[]{this.target};
    }

    public static class PropertySonarFacing
    extends PropertyBool {
        public EnumFacing facing;

        protected PropertySonarFacing(String name, EnumFacing facing) {
            super(name);
            this.facing = facing;
        }

        public static PropertySonarFacing create(String name, EnumFacing facing) {
            return new PropertySonarFacing(name, facing);
        }
    }
}

