/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.handlers.inventories.containers;

import com.google.common.collect.Lists;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import sonar.core.common.tileentity.TileEntityLargeInventory;
import sonar.core.handlers.inventories.SonarLargeInventory;
import sonar.core.handlers.inventories.containers.ContainerSync;
import sonar.core.handlers.inventories.handling.ItemTransferHelper;
import sonar.core.handlers.inventories.handling.SlotSonarFiltered;
import sonar.core.handlers.inventories.slots.SlotChangeableStack;

public class ContainerLargeInventory
extends ContainerSync {
    public TileEntityLargeInventory tile;

    public ContainerLargeInventory(TileEntityLargeInventory tile) {
        super(tile, tile);
        this.tile = tile;
    }

    public boolean addToInventory(ItemStack stack) {
        ItemStack inserted = ItemHandlerHelper.insertItemStacked((IItemHandler)this.tile.inv, (ItemStack)stack.func_77946_l(), (boolean)false);
        if (inserted.func_190916_E() != stack.func_190916_E()) {
            stack.func_190918_g(stack.func_190916_E() - inserted.func_190916_E());
            this.func_75142_b();
            return true;
        }
        return false;
    }

    public boolean removeToPlayer(EntityPlayer player, ItemStack stack, int targetSlot) {
        int before = this.tile.inv.getStackInSlot(targetSlot).func_190916_E();
        ItemTransferHelper.doTransferFromSlot((IItemHandler)this.tile.inv, Lists.newArrayList((Object[])new IItemHandler[]{ItemTransferHelper.getMainInventoryHandler(player)}), targetSlot);
        if (before != this.tile.inv.getStackInSlot(targetSlot).func_190916_E()) {
            this.func_75142_b();
            return true;
        }
        return false;
    }

    public boolean slotHasStack(Slot slot) {
        return slot instanceof SlotSonarFiltered ? ((SonarLargeInventory.InventoryLargeSlot)this.tile.inv.slots.get(slot.getSlotIndex())).getActualStored() > 0L : slot.func_75216_d();
    }

    public ItemStack getRemovalStack(Slot slot) {
        return slot instanceof SlotSonarFiltered ? ((SonarLargeInventory.InventoryLargeSlot)this.tile.inv.slots.get(slot.getSlotIndex())).getLargeStack().getFullStack() : slot.func_75211_c();
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer player, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && this.slotHasStack(slot)) {
            ItemStack itemstack1 = this.getRemovalStack(slot);
            itemstack = itemstack1.func_77946_l();
            if (index < this.tile.inv.getSlots()) {
                this.removeToPlayer(player, itemstack1, index);
                return ItemStack.field_190927_a;
            }
            if (!this.addToInventory(itemstack1)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        this.tile.func_174886_c(player);
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        Slot slot;
        Slot slot2 = slot = slotId >= 0 && slotId < this.field_75151_b.size() ? (Slot)this.field_75151_b.get(slotId) : null;
        if (slot instanceof SlotChangeableStack && (clickTypeIn == ClickType.PICKUP || clickTypeIn == ClickType.PICKUP_ALL) && this.slotHasStack(slot)) {
            return ItemStack.field_190927_a;
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }
}

