/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.api;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.TreeSet;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import thelm.jaopca.api.EnumEntryType;
import thelm.jaopca.api.EnumOreType;
import thelm.jaopca.api.IItemRequest;
import thelm.jaopca.api.IProperties;
import thelm.jaopca.api.ModuleBase;
import thelm.jaopca.api.block.BlockProperties;
import thelm.jaopca.api.fluid.FluidProperties;
import thelm.jaopca.api.item.ItemProperties;

public class ItemEntry
implements IItemRequest {
    public String name;
    public String prefix;
    public EnumEntryType type;
    public EnumSet<EnumOreType> oreTypes = EnumSet.of(EnumOreType.INGOT);
    public ModelResourceLocation itemModelLocation;
    public final TreeSet<String> blacklist = Sets.newTreeSet((Comparator)String.CASE_INSENSITIVE_ORDER);
    public final ArrayList<ModuleBase> moduleList = Lists.newArrayList();
    public IProperties properties;
    public boolean skipWhenGrouped = false;

    public ItemEntry(EnumEntryType type, String name, String oreDictPrefix, ModelResourceLocation itemModelLocation) {
        this.type = type;
        this.name = name;
        this.prefix = oreDictPrefix;
        this.itemModelLocation = itemModelLocation;
        this.properties = type.defaultPpt;
    }

    public ItemEntry(EnumEntryType type, String name, String oreDictPrefix, ModelResourceLocation itemModelLocation, Collection<String> blacklist) {
        this(type, name, oreDictPrefix, itemModelLocation);
        this.blacklist.addAll(blacklist);
    }

    public ItemEntry(EnumEntryType type, String name, ModelResourceLocation itemModelLocation) {
        this(type, name, name, itemModelLocation);
    }

    public ItemEntry(EnumEntryType type, String name, ModelResourceLocation itemModelLocation, Collection<String> blacklist) {
        this(type, name, name, itemModelLocation, blacklist);
    }

    @Deprecated
    public ItemEntry setBlockProperties(BlockProperties blockProperties) {
        return this.setProperties(blockProperties);
    }

    @Deprecated
    public ItemEntry setItemProperties(ItemProperties itemProperties) {
        return this.setProperties(itemProperties);
    }

    @Deprecated
    public ItemEntry setFluidProperties(FluidProperties fluidProperties) {
        return this.setProperties(fluidProperties);
    }

    public ItemEntry setProperties(IProperties properties) {
        if (properties.getType() != this.type) {
            throw new IllegalArgumentException("property type and entry type do not match");
        }
        this.properties = properties;
        return this;
    }

    public ItemEntry setOreTypes(EnumOreType ... types) {
        this.oreTypes = EnumSet.copyOf(Arrays.asList(types));
        return this;
    }

    public ItemEntry skipWhenGrouped(boolean does) {
        this.skipWhenGrouped = does;
        return this;
    }

    public boolean equals(Object other) {
        if (other instanceof ItemEntry) {
            ItemEntry entry = (ItemEntry)other;
            return entry.name.equals(this.name) && entry.prefix.equals(this.prefix) && entry.type.equals((Object)this.type);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode() & this.prefix.hashCode() ^ this.type.hashCode();
    }
}

