/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api.transmission.grid;

import java.util.HashSet;
import java.util.Set;
import micdoodle8.mods.galacticraft.api.transmission.grid.IPathCallBack;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;

public class Pathfinder {
    public IPathCallBack callBackCheck;
    public Set<BlockVec3> closedSet;
    public Set<BlockVec3> results;

    public Pathfinder(IPathCallBack callBack) {
        this.callBackCheck = callBack;
        this.reset();
    }

    public boolean findNodes(BlockVec3 currentNode) {
        this.closedSet.add(currentNode);
        if (this.callBackCheck.onSearch(this, currentNode)) {
            return false;
        }
        for (BlockVec3 node : this.callBackCheck.getConnectedNodes(this, currentNode)) {
            if (this.closedSet.contains(node) || !this.findNodes(node)) continue;
            return true;
        }
        return false;
    }

    public Pathfinder init(BlockVec3 startNode) {
        this.findNodes(startNode);
        return this;
    }

    public Pathfinder reset() {
        this.closedSet = new HashSet<BlockVec3>();
        this.results = new HashSet<BlockVec3>();
        return this;
    }
}

