/*
 * Decompiled with CFR 0.152.
 */
package com.pam.harvestcraft.addons;

import com.pam.harvestcraft.blocks.growables.BlockPamCrop;
import com.pam.harvestcraft.blocks.growables.BlockPamFruit;
import com.pam.harvestcraft.blocks.growables.BlockPamFruitLog;
import com.pam.harvestcraft.blocks.growables.PamCropGrowable;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import mcp.mobius.waila.cbcore.LangUtil;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WailaPamHandler
implements IWailaDataProvider {
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (accessor.getBlock() instanceof BlockPamCrop) {
            BlockPamCrop crop = (BlockPamCrop)accessor.getBlock();
            return new ItemStack(crop.func_149865_P());
        }
        if (accessor.getBlock() instanceof BlockPamFruit) {
            BlockPamFruit fruit = (BlockPamFruit)accessor.getBlock();
            return new ItemStack(fruit.getFruitItem());
        }
        return ItemStack.field_190927_a;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (!config.getConfig("general.showcrop") || accessor.getBlock() == null || !(accessor.getBlock() instanceof PamCropGrowable)) {
            return currenttip;
        }
        currenttip.clear();
        float matureAge = ((PamCropGrowable)accessor.getBlock()).getMatureAge();
        int growthStage = accessor.getMetadata();
        float growthValue = (float)growthStage / matureAge * 100.0f;
        if ((double)growthValue < 100.0) {
            currenttip.add(String.format("%s : %.0f %%", LangUtil.translateG((String)"hud.msg.growth", (Object[])new Object[0]), Float.valueOf(growthValue)));
        } else {
            currenttip.add(String.format("%s : %s", LangUtil.translateG((String)"hud.msg.growth", (Object[])new Object[0]), LangUtil.translateG((String)"hud.msg.mature", (Object[])new Object[0])));
        }
        return currenttip;
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        if (te != null) {
            te.deserializeNBT(tag);
        }
        return tag;
    }

    public static void callbackRegister(IWailaRegistrar registrar) {
        registrar.registerBodyProvider((IWailaDataProvider)new WailaPamHandler(), BlockPamCrop.class);
        registrar.registerBodyProvider((IWailaDataProvider)new WailaPamHandler(), BlockPamFruit.class);
        registrar.registerBodyProvider((IWailaDataProvider)new WailaPamHandler(), BlockPamFruitLog.class);
    }
}

