/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.robit;

import java.io.IOException;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.entity.EntityRobit;
import mekanism.common.network.PacketRobit;
import mekanism.common.util.MekanismUtils;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public abstract class GuiRobit
extends GuiMekanism {
    protected final EntityRobit robit;

    protected GuiRobit(EntityRobit robit, Container container) {
        super(container);
        this.robit = robit;
        this.field_146999_f += 25;
    }

    @Override
    protected ResourceLocation getGuiLocation() {
        return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, this.getBackgroundImage());
    }

    protected abstract String getBackgroundImage();

    @Override
    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        super.func_146976_a(partialTick, mouseX, mouseY);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(this.getGuiLocation());
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.field_146999_f, this.field_147000_g);
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        boolean correctX = xAxis >= 179 && xAxis <= 197;
        this.drawRect(correctX, yAxis, guiWidth, guiHeight, 10, 0);
        this.drawRect(correctX, yAxis, guiWidth, guiHeight, 30, 36);
        this.drawRect(correctX, yAxis, guiWidth, guiHeight, 50, 72);
        this.drawRect(correctX, yAxis, guiWidth, guiHeight, 70, 108);
        this.drawRect(correctX, yAxis, guiWidth, guiHeight, 90, 144);
    }

    private void drawRect(boolean correctX, int yAxis, int guiWidth, int guiHeight, int heightBonus, int textureY) {
        int yBonus = correctX && yAxis >= heightBonus && yAxis <= heightBonus + 18 ? 0 : 18;
        this.func_73729_b(guiWidth + 179, guiHeight + heightBonus, 201, textureY + yBonus, 18, 18);
    }

    private void buttonClicked(int id) {
        SoundHandler.playSound(SoundEvents.field_187909_gi);
        if (this.openGui(id)) {
            Mekanism.packetHandler.sendToServer(new PacketRobit.RobitMessage(PacketRobit.RobitPacketType.GUI, id, this.robit.func_145782_y(), null));
            this.field_146297_k.field_71439_g.openGui((Object)Mekanism.instance, 21 + id, (World)this.field_146297_k.field_71441_e, this.robit.func_145782_y(), 0, 0);
        }
    }

    protected abstract boolean openGui(int var1);

    protected void extraClickListeners(int mouseX, int mouseY, int button) {
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        super.func_73864_a(mouseX, mouseY, button);
        this.extraClickListeners(mouseX, mouseY, button);
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        if (button == 0 && xAxis >= 179 && xAxis <= 197) {
            int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
            if (yAxis >= 10 && yAxis <= 28) {
                this.buttonClicked(0);
            } else if (yAxis >= 30 && yAxis <= 48) {
                this.buttonClicked(1);
            } else if (yAxis >= 50 && yAxis <= 68) {
                this.buttonClicked(2);
            } else if (yAxis >= 70 && yAxis <= 88) {
                this.buttonClicked(3);
            } else if (yAxis >= 90 && yAxis <= 108) {
                this.buttonClicked(4);
            }
        }
    }
}

