/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Coord4D;
import mekanism.api.IConfigurable;
import mekanism.api.TileNetworkList;
import mekanism.common.Mekanism;
import mekanism.common.base.FluidHandlerWrapper;
import mekanism.common.base.IActiveState;
import mekanism.common.base.IComparatorSupport;
import mekanism.common.base.IFluidContainerManager;
import mekanism.common.base.IFluidHandlerWrapper;
import mekanism.common.base.ISustainedTank;
import mekanism.common.base.ITankManager;
import mekanism.common.base.ITierUpgradeable;
import mekanism.common.base.ITieredTile;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tier.BaseTier;
import mekanism.common.tier.FluidTankTier;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.FluidContainerUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.PipeUtils;
import mekanism.common.util.TileUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityFluidTank
extends TileEntityContainerBlock
implements IActiveState,
IConfigurable,
IFluidHandlerWrapper,
ISustainedTank,
IFluidContainerManager,
ITankManager,
ISecurityTile,
ITierUpgradeable,
ITieredTile,
IComparatorSupport {
    public boolean isActive;
    public boolean clientActive;
    public FluidTank fluidTank;
    public FluidContainerUtils.ContainerEditMode editMode = FluidContainerUtils.ContainerEditMode.BOTH;
    public FluidTankTier tier = FluidTankTier.BASIC;
    public int updateDelay;
    public int prevAmount;
    public int valve;
    public FluidStack valveFluid;
    public float prevScale;
    public boolean needsPacket;
    public int currentRedstoneLevel;
    public TileComponentSecurity securityComponent = new TileComponentSecurity(this);

    public TileEntityFluidTank() {
        super("FluidTank");
        this.fluidTank = new FluidTank(this.tier.getStorage());
        this.inventory = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    }

    @Override
    public boolean upgrade(BaseTier upgradeTier) {
        if (upgradeTier.ordinal() != this.tier.ordinal() + 1) {
            return false;
        }
        this.tier = FluidTankTier.values()[upgradeTier.ordinal()];
        this.fluidTank.setCapacity(this.tier.getStorage());
        Mekanism.packetHandler.sendUpdatePacket(this);
        this.func_70296_d();
        return true;
    }

    @Override
    public boolean canSetFacing(int facing) {
        return false;
    }

    @Override
    public void onUpdate() {
        if (this.field_145850_b.field_72995_K) {
            float targetScale;
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                    this.isActive = this.clientActive;
                    MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
                }
            }
            if ((double)Math.abs(this.prevScale - (targetScale = (float)(this.fluidTank.getFluid() != null ? this.fluidTank.getFluid().amount : 0) / (float)this.fluidTank.getCapacity())) > 0.01) {
                this.prevScale = (9.0f * this.prevScale + targetScale) / 10.0f;
            }
        } else {
            int newRedstoneLevel;
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                    this.needsPacket = true;
                }
            }
            if (this.valve > 0) {
                --this.valve;
                if (this.valve == 0) {
                    this.valveFluid = null;
                    this.needsPacket = true;
                }
            }
            if (this.fluidTank.getFluidAmount() != this.prevAmount) {
                MekanismUtils.saveChunk(this);
                this.needsPacket = true;
            }
            this.prevAmount = this.fluidTank.getFluidAmount();
            if (!((ItemStack)this.inventory.get(0)).func_190926_b()) {
                this.manageInventory();
            }
            if (this.isActive) {
                this.activeEmit();
            }
            if ((newRedstoneLevel = this.getRedstoneLevel()) != this.currentRedstoneLevel) {
                this.func_70296_d();
                this.currentRedstoneLevel = newRedstoneLevel;
            }
            if (this.needsPacket) {
                Mekanism.packetHandler.sendToAllAround(new PacketTileEntity.TileEntityMessage(this), Coord4D.get(this).getTargetPoint(50.0));
            }
            this.needsPacket = false;
        }
    }

    @Override
    @Nonnull
    public String func_70005_c_() {
        return LangUtils.localize("tile.FluidTank" + this.tier.getBaseTier().getSimpleName() + ".name");
    }

    private void activeEmit() {
        TileEntity tileEntity;
        if (this.fluidTank.getFluid() != null && CapabilityUtils.hasCapability((ICapabilityProvider)(tileEntity = Coord4D.get(this).offset(EnumFacing.DOWN).getTileEntity((IBlockAccess)this.field_145850_b)), CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.UP)) {
            IFluidHandler handler = (IFluidHandler)CapabilityUtils.getCapability((ICapabilityProvider)tileEntity, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.UP);
            FluidStack toDrain = new FluidStack(this.fluidTank.getFluid(), Math.min(this.tier.getOutput(), this.fluidTank.getFluidAmount()));
            this.fluidTank.drain(handler.fill(toDrain, true), this.tier != FluidTankTier.CREATIVE);
        }
    }

    private void manageInventory() {
        if (FluidContainerUtils.isFluidContainer((ItemStack)this.inventory.get(0))) {
            FluidStack ret = FluidContainerUtils.handleContainerItem(this, (NonNullList<ItemStack>)this.inventory, this.editMode, this.fluidTank.getFluid(), this.getCurrentNeeded(), 0, 1, null);
            if (ret != null) {
                this.fluidTank.setFluid(PipeUtils.copy(ret, Math.min(this.fluidTank.getCapacity(), ret.amount)));
                if (this.tier == FluidTankTier.CREATIVE) {
                    FluidStack fluid = this.fluidTank.getFluid();
                    if (fluid != null) {
                        fluid.amount = Integer.MAX_VALUE;
                    }
                } else {
                    int rejects = Math.max(0, ret.amount - this.fluidTank.getCapacity());
                    if (rejects > 0) {
                        this.pushUp(PipeUtils.copy(ret, rejects), true);
                    }
                }
            } else if (this.tier != FluidTankTier.CREATIVE) {
                this.fluidTank.setFluid(null);
            }
        }
    }

    public int pushUp(FluidStack fluid, boolean doFill) {
        IFluidHandler handler;
        Coord4D up = Coord4D.get(this).offset(EnumFacing.UP);
        TileEntity tileEntity = up.getTileEntity((IBlockAccess)this.field_145850_b);
        if (tileEntity instanceof TileEntityFluidTank && PipeUtils.canFill(handler = (IFluidHandler)CapabilityUtils.getCapability((ICapabilityProvider)tileEntity, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.DOWN), fluid)) {
            return handler.fill(fluid, doFill);
        }
        return 0;
    }

    @Override
    public boolean func_180461_b(int slotID, @Nonnull ItemStack itemstack, @Nonnull EnumFacing side) {
        return slotID == 1;
    }

    @Override
    public boolean func_94041_b(int slotID, @Nonnull ItemStack itemstack) {
        if (slotID == 0) {
            return FluidContainerUtils.isFluidContainer(itemstack);
        }
        return false;
    }

    @Override
    @Nonnull
    public int[] func_180463_a(@Nonnull EnumFacing side) {
        if (side == EnumFacing.DOWN) {
            return new int[]{1};
        }
        if (side == EnumFacing.UP) {
            return new int[]{0};
        }
        return InventoryUtils.EMPTY;
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74768_a("tier", this.tier.ordinal());
        nbtTags.func_74757_a("isActive", this.isActive);
        nbtTags.func_74768_a("editMode", this.editMode.ordinal());
        if (this.fluidTank.getFluid() != null) {
            nbtTags.func_74782_a("fluidTank", (NBTBase)this.fluidTank.writeToNBT(new NBTTagCompound()));
        }
        return nbtTags;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.tier = FluidTankTier.values()[nbtTags.func_74762_e("tier")];
        this.clientActive = this.isActive = nbtTags.func_74767_n("isActive");
        this.editMode = FluidContainerUtils.ContainerEditMode.values()[nbtTags.func_74762_e("editMode")];
        this.fluidTank.setCapacity(this.tier.getStorage());
        if (nbtTags.func_74764_b("fluidTank")) {
            this.fluidTank.readFromNBT(nbtTags.func_74775_l("fluidTank"));
        }
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            FluidTankTier prevTier = this.tier;
            this.tier = FluidTankTier.values()[dataStream.readInt()];
            this.fluidTank.setCapacity(this.tier.getStorage());
            this.clientActive = dataStream.readBoolean();
            this.valve = dataStream.readInt();
            this.editMode = FluidContainerUtils.ContainerEditMode.values()[dataStream.readInt()];
            this.valveFluid = this.valve > 0 ? TileUtils.readFluidStack(dataStream) : null;
            TileUtils.readTankData(dataStream, this.fluidTank);
            if (prevTier != this.tier || this.updateDelay == 0 && this.clientActive != this.isActive) {
                this.updateDelay = MekanismConfig.current().general.UPDATE_DELAY.val();
                this.isActive = this.clientActive;
                MekanismUtils.updateBlock(this.field_145850_b, this.func_174877_v());
            }
        }
    }

    @Override
    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents(this.fluidTank.getFluidAmount(), this.fluidTank.getCapacity());
    }

    public int getCurrentNeeded() {
        int needed = this.fluidTank.getCapacity() - this.fluidTank.getFluidAmount();
        if (this.tier == FluidTankTier.CREATIVE) {
            return Integer.MAX_VALUE;
        }
        Coord4D top = Coord4D.get(this).offset(EnumFacing.UP);
        TileEntity topTile = top.getTileEntity((IBlockAccess)this.field_145850_b);
        if (topTile instanceof TileEntityFluidTank) {
            TileEntityFluidTank topTank = (TileEntityFluidTank)topTile;
            if (this.fluidTank.getFluid() != null && topTank.fluidTank.getFluid() != null && this.fluidTank.getFluid().getFluid() != topTank.fluidTank.getFluid().getFluid()) {
                return needed;
            }
            needed += topTank.getCurrentNeeded();
        }
        return needed;
    }

    @Override
    public TileNetworkList getNetworkedData(TileNetworkList data) {
        super.getNetworkedData(data);
        data.add(this.tier.ordinal());
        data.add(this.isActive);
        data.add(this.valve);
        data.add(this.editMode.ordinal());
        if (this.valve > 0) {
            TileUtils.addFluidStack(data, this.valveFluid);
        }
        TileUtils.addTankData(data, this.fluidTank);
        return data;
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.clientActive != active && this.updateDelay == 0) {
            Mekanism.packetHandler.sendUpdatePacket(this);
            this.updateDelay = 10;
            this.clientActive = active;
        }
    }

    @Override
    public boolean renderUpdate() {
        return true;
    }

    @Override
    public boolean lightUpdate() {
        return true;
    }

    @Override
    public EnumActionResult onSneakRightClick(EntityPlayer player, EnumFacing side) {
        if (!this.field_145850_b.field_72995_K) {
            this.setActive(!this.getActive());
            this.field_145850_b.func_184148_a(null, (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), SoundEvents.field_187909_gi, SoundCategory.BLOCKS, 0.3f, 1.0f);
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public EnumActionResult onRightClick(EntityPlayer player, EnumFacing side) {
        return EnumActionResult.PASS;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return false;
        }
        return capability == Capabilities.CONFIGURABLE_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing side) {
        if (this.isCapabilityDisabled(capability, side)) {
            return null;
        }
        if (capability == Capabilities.CONFIGURABLE_CAPABILITY) {
            return (T)Capabilities.CONFIGURABLE_CAPABILITY.cast((Object)this);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new FluidHandlerWrapper(this, side));
        }
        return super.getCapability(capability, side);
    }

    @Override
    public boolean isCapabilityDisabled(@Nonnull Capability<?> capability, EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return side != null && side != EnumFacing.DOWN && side != EnumFacing.UP;
        }
        return super.isCapabilityDisabled(capability, side);
    }

    @Override
    public int fill(EnumFacing from, @Nonnull FluidStack resource, boolean doFill) {
        if (this.tier == FluidTankTier.CREATIVE) {
            return resource.amount;
        }
        int filled = this.fluidTank.fill(resource, doFill);
        if (filled < resource.amount && !this.isActive) {
            filled += this.pushUp(PipeUtils.copy(resource, resource.amount - filled), doFill);
        }
        if (filled > 0 && from == EnumFacing.UP) {
            if (this.valve == 0) {
                this.needsPacket = true;
            }
            this.valve = 20;
            this.valveFluid = new FluidStack(resource, 1);
        }
        return filled;
    }

    @Override
    @Nullable
    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return this.fluidTank.drain(maxDrain, this.tier != FluidTankTier.CREATIVE && doDrain);
    }

    @Override
    public boolean canFill(EnumFacing from, @Nonnull FluidStack fluid) {
        TileEntity tile = MekanismUtils.getTileEntity(this.field_145850_b, this.func_174877_v().func_177972_a(EnumFacing.DOWN));
        if (from == EnumFacing.DOWN && this.isActive && !(tile instanceof TileEntityFluidTank)) {
            return false;
        }
        if (this.tier == FluidTankTier.CREATIVE) {
            return true;
        }
        if (this.isActive && tile instanceof TileEntityFluidTank) {
            return this.fluidTank.getFluid() == null ? ((TileEntityFluidTank)tile).canFill(EnumFacing.UP, fluid) : this.fluidTank.getFluid().isFluidEqual(fluid);
        }
        return FluidContainerUtils.canFill(this.fluidTank.getFluid(), fluid);
    }

    @Override
    public boolean canDrain(EnumFacing from, @Nullable FluidStack fluid) {
        return this.fluidTank != null && FluidContainerUtils.canDrain(this.fluidTank.getFluid(), fluid) && !this.isActive || from != EnumFacing.DOWN;
    }

    @Override
    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return new FluidTankInfo[]{this.fluidTank.getInfo()};
    }

    @Override
    public FluidTankInfo[] getAllTanks() {
        return this.getTankInfo(null);
    }

    @Override
    public void setFluidStack(FluidStack fluidStack, Object ... data) {
        this.fluidTank.setFluid(fluidStack);
    }

    @Override
    public FluidStack getFluidStack(Object ... data) {
        return this.fluidTank.getFluid();
    }

    @Override
    public boolean hasTank(Object ... data) {
        return true;
    }

    @Override
    public FluidContainerUtils.ContainerEditMode getContainerEditMode() {
        return this.editMode;
    }

    @Override
    public void setContainerEditMode(FluidContainerUtils.ContainerEditMode mode) {
        this.editMode = mode;
    }

    @Override
    public Object[] getTanks() {
        return new Object[]{this.fluidTank};
    }

    @Override
    public TileComponentSecurity getSecurity() {
        return this.securityComponent;
    }

    @Override
    public BaseTier getTier() {
        return this.tier.getBaseTier();
    }
}

