/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.command.delete;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.chunk.storage.RegionFileCache;
import pregenerator.impl.command.CompleterHelper;
import pregenerator.impl.command.base.BasePregenCommand;
import pregenerator.impl.command.base.CommandContainer;
import pregenerator.impl.misc.FilePos;

public class DeleteRegionSubCommand
extends BasePregenCommand {
    public DeleteRegionSubCommand() {
        super(3);
        this.addDescription(0, "X Position: The ChunkX Position of the File that should be deleted. (if 'b' infront of the number or after ~ means block position)");
        this.addDescription(1, "Z Position: The ChunkZ Position of the File that should be deleted. (if 'b' infront of the number or after ~ means block position)");
        this.addDescription(2, "(Optional) Dimension: The Dimension the Deletion should be happening in");
        this.addSuggestion("deleteRegion 100 200", "Deletes the Region File that is at Chunk Position X100, Z200");
    }

    @Override
    public String getName() {
        return "deleteRegion";
    }

    @Override
    public String getDescription() {
        return "Deletes a full 1024 Chunk Set out of the World Directory";
    }

    @Override
    public int getRequiredParameterCount() {
        return 2;
    }

    @Override
    public void execute(CommandContainer container, String[] args) {
        block8: {
            if (args.length >= 2) {
                FilePos position = DeleteRegionSubCommand.getChunkPos(args[0], args[1], container.getPlayerPos());
                int dimension = DeleteRegionSubCommand.getDimension(container, DeleteRegionSubCommand.getArg(args, 2));
                if (!DeleteRegionSubCommand.isDimensionValid(dimension)) {
                    container.sendChatMessage("Dimension " + dimension + " is not Registered!");
                    return;
                }
                File file = new File(container.getWorld(dimension).getChunkSaveLocation(), "region");
                if (!file.exists()) {
                    container.sendChatMessage("RegionFolder doesn't exist");
                    return;
                }
                File chunk = new File(file, "r." + position.x + "." + position.z + ".mca");
                if (!chunk.exists()) {
                    container.sendChatMessage("Region File: [" + position + "] doesn't exist");
                    return;
                }
                try {
                    RegionFileCache.func_76551_a();
                    if (chunk.delete()) {
                        container.sendChatMessage("Successfully deleted Region File");
                        break block8;
                    }
                    container.sendChatMessage("Couldn't delete the Region File");
                }
                catch (Exception e) {
                    container.sendChatMessage("Deletion Region File Failed. Reason: " + e.getMessage());
                }
            } else {
                this.throwErrors(container, args.length);
            }
        }
    }

    @Override
    public List<String> getAutoCompleteOption(String[] args, int argLayer, int commandIndex) {
        if (commandIndex == 0 || commandIndex == 1) {
            return DeleteRegionSubCommand.getBestMatch(args, "0", "~");
        }
        if (commandIndex == 2) {
            return DeleteRegionSubCommand.getBestMatch(args, CompleterHelper.DIMENSION);
        }
        return new ArrayList<String>();
    }
}

