/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.impl.network.packets.chunkRequest;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import pregenerator.ChunkPregenerator;
import pregenerator.base.api.network.IReadableBuffer;
import pregenerator.base.api.network.IWriteableBuffer;
import pregenerator.base.api.network.PregenPacket;
import pregenerator.impl.network.packets.chunkRequest.StructureAnswerPacket;
import pregenerator.impl.structure.StructureData;
import pregenerator.impl.structure.StructureManager;

public class StructureRequestPacket
extends PregenPacket {
    int dimensionID;

    public StructureRequestPacket() {
    }

    public StructureRequestPacket(int dim) {
        this.dimensionID = dim;
    }

    @Override
    public void read(IReadableBuffer buffer) {
        this.dimensionID = buffer.readInt();
    }

    @Override
    public void write(IWriteableBuffer buffer) {
        buffer.writeInt(this.dimensionID);
    }

    @Override
    public void handle(final EntityPlayer player) {
        MinecraftServer server = ChunkPregenerator.getServer();
        if (!server.func_152345_ab()) {
            server.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    StructureRequestPacket.this.process(player);
                }
            });
            return;
        }
        this.process(player);
    }

    public void process(EntityPlayer player) {
        List<StructureData> entry = StructureManager.instance.getStructures(this.dimensionID);
        if (entry.isEmpty()) {
            StructureAnswerPacket packet = new StructureAnswerPacket();
            packet.setType(-1);
            ChunkPregenerator.networking.sendPacketToPlayer(packet, player);
            return;
        }
        int bytesLeft = 30000;
        ArrayList<StructureAnswerPacket> toSend = new ArrayList<StructureAnswerPacket>();
        StructureAnswerPacket packet = new StructureAnswerPacket();
        for (StructureData structureData : entry) {
            int bytes = structureData.getBytes();
            if (bytes > bytesLeft) {
                toSend.add(packet);
                packet = new StructureAnswerPacket();
            }
            packet.addData(structureData);
            bytesLeft -= bytes;
        }
        if (packet.hasData()) {
            toSend.add(packet);
        }
        for (int i = 0; i < toSend.size(); ++i) {
            StructureAnswerPacket structureAnswerPacket = (StructureAnswerPacket)toSend.get(i);
            structureAnswerPacket.setType(toSend.size() - (i + 1));
            ChunkPregenerator.networking.sendPacketToPlayer(structureAnswerPacket, player);
        }
    }
}

