/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.configs;

import asmodeuscore.AsmodeusCore;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Level;

public class AsmodeusConfig {
    public static boolean loaded;
    static Configuration config;
    public static boolean enableCheckVersion;
    public static boolean enableRenderAtmosphere;
    public static int speedTimeTravel;
    public static boolean enableNewGalaxyMap;
    public static boolean enableNewTierSystem;
    public static boolean enable2DGalaxyMap;
    public static boolean enableImgOnGalaxyMap;
    public static boolean enableTimeTravelSystem;
    public static boolean enableRequiredEquip;
    public static boolean enableDynamicImgOnGalaxyMap;
    public static boolean enableRotateStars;
    public static boolean enableColorStars;

    public AsmodeusConfig(File file) {
        if (!loaded) {
            config = new Configuration(file);
            AsmodeusConfig.syncConfig(true);
        }
    }

    private static void setConfigBoolean(Property prop, List<String> propOrder, String category, String confname, String desc, boolean conf, boolean def) {
        prop = config.get(category, confname, def);
        prop.setComment(desc);
        prop.setLanguageKey("ac.configgui." + confname).setRequiresMcRestart(true);
        conf = prop.getBoolean(def);
        propOrder.add(prop.getName());
    }

    public static void syncConfig(boolean load) {
        ArrayList<String> propOrder = new ArrayList<String>();
        try {
            Property prop = null;
            if (!AsmodeusConfig.config.isChild && load) {
                config.load();
            }
            AsmodeusConfig.setConfigBoolean(prop, propOrder, "general", "enableRequiredEquip", "Enable/Disable required equipement on Galaxy map. (If false - you can travel on planet without equip.)", enableRequiredEquip, false);
            if (AsmodeusCore.HAS_GALACTICRAFT) {
                prop = config.get("general", "speedTimeTravel", speedTimeTravel);
                prop.setComment("Time Travel speed factor.");
                prop.setLanguageKey("ac.configgui.speedTimeTravel");
                speedTimeTravel = prop.getInt();
                propOrder.add(prop.getName());
                prop = config.get("general", "enableNewGalaxyMap", true);
                prop.setComment("Enable/Disable New Galaxy Map.");
                prop.setLanguageKey("ac.configgui.enableNewGalaxyMap");
                enableNewGalaxyMap = prop.getBoolean(true);
                propOrder.add(prop.getName());
                prop = config.get("general", "enableNewTierSystem", true);
                prop.setComment("Enable/Disable New Tier System.");
                prop.setLanguageKey("ac.configgui.enableNewTierSystem").setRequiresMcRestart(true);
                enableNewTierSystem = prop.getBoolean(true);
                propOrder.add(prop.getName());
                prop = config.get("general", "enable2DGalaxyMap", false);
                prop.setComment("Enable/Disable 2D Galaxy Map. (like in GC2)");
                prop.setLanguageKey("ac.configgui.enable2DGalaxyMap");
                enable2DGalaxyMap = prop.getBoolean(false);
                propOrder.add(prop.getName());
                prop = config.get("general", "enableImgOnGalaxyMap", true);
                prop.setComment("Enable/Disable background image on Galaxy Map. (If false, returned black color and grid)");
                prop.setLanguageKey("ac.configgui.enableImgOnGalaxyMap");
                enableImgOnGalaxyMap = prop.getBoolean(true);
                propOrder.add(prop.getName());
                prop = config.get("general", "enableTimeTravelSystem", true);
                prop.setComment("Enable/Disable Time Travel System on Galaxy Map.");
                prop.setLanguageKey("ac.configgui.enableTimeTravelSystem");
                enableTimeTravelSystem = prop.getBoolean(true);
                propOrder.add(prop.getName());
                prop = config.get("general", "enableDynamicImgOnGalaxyMap", true);
                prop.setComment("Enable/Disable dynamic image on map. (If disabled, image will static)");
                prop.setLanguageKey("ac.configgui.enableDynamicImgOnGalaxyMap");
                enableDynamicImgOnGalaxyMap = prop.getBoolean(true);
                propOrder.add(prop.getName());
            }
            prop = config.get("general", "enableRenderAtmosphere", true);
            prop.setComment("Enable/Disable render planet atmosphere on sky.");
            prop.setLanguageKey("ac.configgui.enableRenderAtmosphere").setRequiresMcRestart(true);
            enableRenderAtmosphere = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("general", "enableRotateStars", true);
            prop.setComment("Enable/Disable rotate stars on sky.");
            prop.setLanguageKey("ac.configgui.enableRotateStars");
            enableRotateStars = prop.getBoolean(true);
            propOrder.add(prop.getName());
            prop = config.get("general", "enableColorStars", false);
            prop.setComment("Enable/Disable render color stars on sky.");
            prop.setLanguageKey("ac.configgui.enableColorStars");
            enableColorStars = prop.getBoolean(false);
            propOrder.add(prop.getName());
            config.setCategoryPropertyOrder("general", propOrder);
            if (config.hasChanged()) {
                config.save();
            }
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"Asmodeus Core has a problem loading it's config", (Object[])new Object[0]);
        }
    }

    static {
        speedTimeTravel = 1;
        enableNewGalaxyMap = true;
        enableNewTierSystem = true;
        enable2DGalaxyMap = false;
        enableImgOnGalaxyMap = true;
        enableTimeTravelSystem = true;
        enableRequiredEquip = false;
        enableDynamicImgOnGalaxyMap = true;
        enableRotateStars = false;
        enableColorStars = false;
    }
}

