/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items.gadgets;

import com.direwolf20.buildinggadgets.client.events.EventTooltip;
import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.blocks.ConstructionBlock;
import com.direwolf20.buildinggadgets.common.blocks.ConstructionBlockTileEntity;
import com.direwolf20.buildinggadgets.common.config.SyncedConfig;
import com.direwolf20.buildinggadgets.common.entities.BlockBuildEntity;
import com.direwolf20.buildinggadgets.common.items.ITemplate;
import com.direwolf20.buildinggadgets.common.items.ModItems;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetGeneric;
import com.direwolf20.buildinggadgets.common.network.PacketBlockMap;
import com.direwolf20.buildinggadgets.common.network.PacketHandler;
import com.direwolf20.buildinggadgets.common.network.PacketRotateMirror;
import com.direwolf20.buildinggadgets.common.tools.BlockMap;
import com.direwolf20.buildinggadgets.common.tools.BlockMapIntState;
import com.direwolf20.buildinggadgets.common.tools.GadgetUtils;
import com.direwolf20.buildinggadgets.common.tools.InventoryManipulation;
import com.direwolf20.buildinggadgets.common.tools.NetworkIO;
import com.direwolf20.buildinggadgets.common.tools.ToolRenders;
import com.direwolf20.buildinggadgets.common.tools.UniqueItem;
import com.direwolf20.buildinggadgets.common.tools.VectorTools;
import com.direwolf20.buildinggadgets.common.tools.WorldSave;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class GadgetCopyPaste
extends GadgetGeneric
implements ITemplate {
    public GadgetCopyPaste() {
        super("copypastetool");
        this.func_77656_e(SyncedConfig.durabilityCopyPaste);
    }

    public int getMaxDamage(ItemStack stack) {
        return SyncedConfig.poweredByFE ? 0 : SyncedConfig.durabilityCopyPaste;
    }

    @Override
    public int getEnergyCost(ItemStack tool) {
        return SyncedConfig.energyCostCopyPaste;
    }

    @Override
    public int getDamageCost(ItemStack tool) {
        return SyncedConfig.damageCostCopyPaste;
    }

    private static void setAnchor(ItemStack stack, BlockPos anchorPos) {
        GadgetUtils.writePOSToNBT(stack, anchorPos, "anchor");
    }

    public static void setX(ItemStack stack, int horz) {
        GadgetUtils.writeIntToNBT(stack, horz, "X");
    }

    public static void setY(ItemStack stack, int vert) {
        GadgetUtils.writeIntToNBT(stack, vert, "Y");
    }

    public static void setZ(ItemStack stack, int depth) {
        GadgetUtils.writeIntToNBT(stack, depth, "Z");
    }

    public static int getX(ItemStack stack) {
        return GadgetUtils.getIntFromNBT(stack, "X");
    }

    public static int getY(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return 1;
        }
        if (!tagCompound.func_74764_b("Y")) {
            return 1;
        }
        Integer tagInt = tagCompound.func_74762_e("Y");
        return tagInt;
    }

    public static int getZ(ItemStack stack) {
        return GadgetUtils.getIntFromNBT(stack, "Z");
    }

    public static BlockPos getAnchor(ItemStack stack) {
        return GadgetUtils.getPOSFromNBT(stack, "anchor");
    }

    @Override
    public WorldSave getWorldSave(World world) {
        return WorldSave.getWorldSave(world);
    }

    @Override
    @Nullable
    public String getUUID(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return null;
        }
        String uuid = tagCompound.func_74779_i("UUID");
        if (uuid.isEmpty()) {
            if (this.getStartPos(stack) == null && this.getEndPos(stack) == null) {
                return null;
            }
            UUID uid = UUID.randomUUID();
            tagCompound.func_74778_a("UUID", uid.toString());
            stack.func_77982_d(tagCompound);
            uuid = uid.toString();
        }
        return uuid;
    }

    public static String getOwner(ItemStack stack) {
        return GadgetUtils.getStackTag(stack).func_74779_i("owner");
    }

    public static void setOwner(ItemStack stack, String owner) {
        NBTTagCompound tagCompound = GadgetUtils.getStackTag(stack);
        tagCompound.func_74778_a("owner", owner);
        stack.func_77982_d(tagCompound);
    }

    private static void setLastBuild(ItemStack stack, BlockPos anchorPos, Integer dim) {
        GadgetUtils.writePOSToNBT(stack, anchorPos, "lastBuild", dim);
    }

    private static BlockPos getLastBuild(ItemStack stack) {
        return GadgetUtils.getPOSFromNBT(stack, "lastBuild");
    }

    private static Integer getLastBuildDim(ItemStack stack) {
        return GadgetUtils.getDIMFromNBT(stack, "lastBuild");
    }

    public static List<BlockMap> getBlockMapList(@Nullable NBTTagCompound tagCompound) {
        return GadgetCopyPaste.getBlockMapList(tagCompound, GadgetUtils.getPOSFromNBT(tagCompound, "startPos"));
    }

    private static List<BlockMap> getBlockMapList(@Nullable NBTTagCompound tagCompound, BlockPos startBlock) {
        NBTTagList MapIntStateTag;
        ArrayList<BlockMap> blockMap = new ArrayList<BlockMap>();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        if ((MapIntStateTag = (NBTTagList)tagCompound.func_74781_a("mapIntState")) == null) {
            MapIntStateTag = new NBTTagList();
        }
        BlockMapIntState MapIntState = new BlockMapIntState();
        MapIntState.getIntStateMapFromNBT(MapIntStateTag);
        int[] posIntArray = tagCompound.func_74759_k("posIntArray");
        int[] stateIntArray = tagCompound.func_74759_k("stateIntArray");
        for (int i = 0; i < posIntArray.length; ++i) {
            int p = posIntArray[i];
            BlockPos pos = GadgetUtils.relIntToPos(startBlock, p);
            short IntState = (short)stateIntArray[i];
            blockMap.add(new BlockMap(pos, MapIntState.getStateFromSlot(IntState), (byte)((p & 0xFF0000) >> 16), (byte)((p & 0xFF00) >> 8), (byte)(p & 0xFF)));
        }
        return blockMap;
    }

    public static BlockMapIntState getBlockMapIntState(@Nullable NBTTagCompound tagCompound) {
        NBTTagList MapIntStackTag;
        NBTTagList MapIntStateTag;
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        if ((MapIntStateTag = (NBTTagList)tagCompound.func_74781_a("mapIntState")) == null) {
            MapIntStateTag = new NBTTagList();
        }
        if ((MapIntStackTag = (NBTTagList)tagCompound.func_74781_a("mapIntStack")) == null) {
            MapIntStackTag = new NBTTagList();
        }
        BlockMapIntState MapIntState = new BlockMapIntState();
        MapIntState.getIntStateMapFromNBT(MapIntStateTag);
        MapIntState.getIntStackMapFromNBT(MapIntStackTag);
        return MapIntState;
    }

    private static void setToolMode(ItemStack stack, ToolMode mode) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        tagCompound.func_74778_a("mode", mode.name());
        stack.func_77982_d(tagCompound);
    }

    public static ToolMode getToolMode(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        ToolMode mode = ToolMode.Copy;
        if (tagCompound == null) {
            GadgetCopyPaste.setToolMode(stack, mode);
            return mode;
        }
        try {
            mode = ToolMode.valueOf(tagCompound.func_74779_i("mode"));
        }
        catch (Exception e) {
            GadgetCopyPaste.setToolMode(stack, mode);
        }
        return mode;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag b) {
        super.func_77624_a(stack, world, list, b);
        list.add(TextFormatting.AQUA + I18n.func_135052_a((String)"tooltip.gadget.mode", (Object[])new Object[0]) + ": " + (Object)((Object)GadgetCopyPaste.getToolMode(stack)));
        GadgetCopyPaste.addInformationRayTraceFluid(list, stack);
        this.addEnergyInformation(list, stack);
        EventTooltip.addTemplatePadding(stack, list);
    }

    public void setMode(ItemStack heldItem, int modeInt) {
        ToolMode mode = ToolMode.values()[modeInt];
        GadgetCopyPaste.setToolMode(heldItem, mode);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        player.func_184598_c(hand);
        BlockPos pos = VectorTools.getPosLookingAt(player, stack);
        if (!world.field_72995_K) {
            if (pos != null && player.func_70093_af() && GadgetUtils.setRemoteInventory(stack, player, world, pos, false) == EnumActionResult.SUCCESS) {
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
            if (GadgetCopyPaste.getToolMode(stack) == ToolMode.Copy) {
                if (pos == null) {
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
                }
                if (player.func_70093_af()) {
                    if (this.getStartPos(stack) != null) {
                        GadgetCopyPaste.copyBlocks(stack, player, world, this.getStartPos(stack), pos);
                    } else {
                        this.setEndPos(stack, pos);
                    }
                } else if (this.getEndPos(stack) != null) {
                    GadgetCopyPaste.copyBlocks(stack, player, world, pos, this.getEndPos(stack));
                } else {
                    this.setStartPos(stack, pos);
                }
            } else if (GadgetCopyPaste.getToolMode(stack) == ToolMode.Paste && !player.func_70093_af()) {
                if (GadgetCopyPaste.getAnchor(stack) == null) {
                    if (pos == null) {
                        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
                    }
                    this.buildBlockMap(world, pos, stack, player);
                } else {
                    BlockPos startPos = GadgetCopyPaste.getAnchor(stack);
                    this.buildBlockMap(world, startPos, stack, player);
                }
            }
        } else {
            if (pos != null && player.func_70093_af() && GadgetUtils.getRemoteInventory(pos, world, player, NetworkIO.Operation.EXTRACT) != null) {
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            }
            if (GadgetCopyPaste.getToolMode(stack) == ToolMode.Copy) {
                if (pos == null && player.func_70093_af()) {
                    player.openGui((Object)BuildingGadgets.instance, 0, world, hand.ordinal(), 0, 0);
                }
            } else if (player.func_70093_af()) {
                player.openGui((Object)BuildingGadgets.instance, 2, world, hand.ordinal(), 0, 0);
            } else {
                ToolRenders.updateInventoryCache();
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public static void rotateOrMirrorBlocks(ItemStack stack, EntityPlayer player, PacketRotateMirror.Operation operation) {
        if (GadgetCopyPaste.getToolMode(stack) != ToolMode.Paste) {
            return;
        }
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        GadgetCopyPaste tool = ModItems.gadgetCopyPaste;
        List<Object> blockMapList = new ArrayList();
        WorldSave worldSave = WorldSave.getWorldSave(player.field_70170_p);
        NBTTagCompound tagCompound = worldSave.getCompoundFromUUID(tool.getUUID(stack));
        BlockPos startPos = tool.getStartPos(stack);
        if (startPos == null) {
            return;
        }
        blockMapList = GadgetCopyPaste.getBlockMapList(tagCompound);
        ArrayList<Integer> posIntArrayList = new ArrayList<Integer>();
        ArrayList<Integer> stateIntArrayList = new ArrayList<Integer>();
        BlockMapIntState blockMapIntState = new BlockMapIntState();
        for (BlockMap blockMap : blockMapList) {
            int nz;
            int nx;
            BlockPos tempPos = blockMap.pos;
            int px = tempPos.func_177958_n() - startPos.func_177958_n();
            int pz = tempPos.func_177952_p() - startPos.func_177952_p();
            IBlockState alteredState = GadgetUtils.rotateOrMirrorBlock(player, operation, blockMap.state);
            if (operation == PacketRotateMirror.Operation.MIRROR) {
                if (player.func_174811_aO().func_176740_k() == EnumFacing.Axis.X) {
                    nx = px;
                    nz = -pz;
                } else {
                    nx = -px;
                    nz = pz;
                }
            } else {
                nx = -pz;
                nz = px;
            }
            BlockPos newPos = new BlockPos(startPos.func_177958_n() + nx, tempPos.func_177956_o(), startPos.func_177952_p() + nz);
            posIntArrayList.add(GadgetUtils.relPosToInt(startPos, newPos));
            blockMapIntState.addToMap(alteredState);
            stateIntArrayList.add(Integer.valueOf(blockMapIntState.findSlot(alteredState).shortValue()));
            UniqueItem uniqueItem = BlockMapIntState.blockStateToUniqueItem(alteredState, player, tempPos);
            blockMapIntState.addToStackMap(uniqueItem, alteredState);
        }
        int[] posIntArray = posIntArrayList.stream().mapToInt(i -> i).toArray();
        int[] nArray = stateIntArrayList.stream().mapToInt(i -> i).toArray();
        tagCompound.func_74782_a("mapIntState", (NBTBase)blockMapIntState.putIntStateMapIntoNBT());
        tagCompound.func_74782_a("mapIntStack", (NBTBase)blockMapIntState.putIntStackMapIntoNBT());
        tagCompound.func_74783_a("posIntArray", posIntArray);
        tagCompound.func_74783_a("stateIntArray", nArray);
        tool.incrementCopyCounter(stack);
        tagCompound.func_74768_a("copycounter", tool.getCopyCounter(stack));
        worldSave.addToMap(tool.getUUID(stack), tagCompound);
        worldSave.markForSaving();
        PacketHandler.INSTANCE.sendTo((IMessage)new PacketBlockMap(tagCompound), (EntityPlayerMP)player);
        player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.AQUA + new TextComponentTranslation("message.gadget." + (player.func_70093_af() ? "mirrored" : "rotated"), new Object[0]).func_150261_e()), true);
    }

    public static void copyBlocks(ItemStack stack, EntityPlayer player, World world, BlockPos startPos, BlockPos endPos) {
        GadgetCopyPaste tool;
        if (startPos != null && endPos != null && GadgetCopyPaste.findBlocks(world, startPos, endPos, stack, player, tool = ModItems.gadgetCopyPaste)) {
            tool.setStartPos(stack, startPos);
            tool.setEndPos(stack, endPos);
        }
    }

    private static boolean findBlocks(World world, BlockPos start, BlockPos end, ItemStack stack, EntityPlayer player, GadgetCopyPaste tool) {
        GadgetCopyPaste.setLastBuild(stack, null, 0);
        int foundTE = 0;
        int startX = start.func_177958_n();
        int startY = start.func_177956_o();
        int startZ = start.func_177952_p();
        int endX = end.func_177958_n();
        int endY = end.func_177956_o();
        int endZ = end.func_177952_p();
        if (Math.abs(startX - endX) >= 125 || Math.abs(startY - endY) >= 125 || Math.abs(startZ - endZ) >= 125) {
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + new TextComponentTranslation("message.gadget.toobigarea", new Object[0]).func_150261_e()), true);
            return false;
        }
        int iStartX = startX < endX ? startX : endX;
        int iStartY = startY < endY ? startY : endY;
        int iStartZ = startZ < endZ ? startZ : endZ;
        int iEndX = startX < endX ? endX : startX;
        int iEndY = startY < endY ? endY : startY;
        int iEndZ = startZ < endZ ? endZ : startZ;
        WorldSave worldSave = WorldSave.getWorldSave(world);
        NBTTagCompound tagCompound = new NBTTagCompound();
        ArrayList<Integer> posIntArrayList = new ArrayList<Integer>();
        ArrayList<Integer> stateIntArrayList = new ArrayList<Integer>();
        BlockMapIntState blockMapIntState = new BlockMapIntState();
        HashMultiset itemCountMap = HashMultiset.create();
        int blockCount = 0;
        for (int x = iStartX; x <= iEndX; ++x) {
            for (int y = iStartY; y <= iEndY; ++y) {
                for (int z = iStartZ; z <= iEndZ; ++z) {
                    BlockPos tempPos = new BlockPos(x, y, z);
                    IBlockState tempState = world.func_180495_p(tempPos);
                    if (!(tempState == Blocks.field_150350_a.func_176223_P() || world.func_175625_s(tempPos) != null && !(world.func_175625_s(tempPos) instanceof ConstructionBlockTileEntity) || tempState.func_185904_a().func_76224_d() || SyncedConfig.blockBlacklist.contains((IForgeRegistryEntry<?>)tempState.func_177230_c()))) {
                        TileEntity te = world.func_175625_s(tempPos);
                        IBlockState assignState = InventoryManipulation.getSpecificStates(tempState, world, player, tempPos, stack);
                        IBlockState actualState = assignState.func_185899_b((IBlockAccess)world, tempPos);
                        if (te instanceof ConstructionBlockTileEntity) {
                            actualState = ((ConstructionBlockTileEntity)te).getActualBlockState();
                        }
                        if (actualState == null) continue;
                        UniqueItem uniqueItem = BlockMapIntState.blockStateToUniqueItem(actualState, player, tempPos);
                        if (uniqueItem.item == Items.field_190931_a) continue;
                        posIntArrayList.add(GadgetUtils.relPosToInt(start, tempPos));
                        blockMapIntState.addToMap(actualState);
                        stateIntArrayList.add(Integer.valueOf(blockMapIntState.findSlot(actualState).shortValue()));
                        blockMapIntState.addToStackMap(uniqueItem, actualState);
                        if (++blockCount > 32768) {
                            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + new TextComponentTranslation("message.gadget.toomanyblocks", new Object[0]).func_150261_e()), true);
                            return false;
                        }
                        NonNullList drops = NonNullList.func_191196_a();
                        if (actualState != null) {
                            actualState.func_177230_c().getDrops(drops, (IBlockAccess)world, new BlockPos(0, 0, 0), actualState, 0);
                        }
                        int neededItems = 0;
                        for (ItemStack drop : drops) {
                            if (!drop.func_77973_b().equals(uniqueItem.item)) continue;
                            ++neededItems;
                        }
                        if (neededItems == 0) {
                            neededItems = 1;
                        }
                        itemCountMap.add((Object)uniqueItem, neededItems);
                        continue;
                    }
                    if (world.func_175625_s(tempPos) == null || world.func_175625_s(tempPos) instanceof ConstructionBlockTileEntity) continue;
                    ++foundTE;
                }
            }
        }
        tool.setItemCountMap(stack, (Multiset)itemCountMap);
        tagCompound.func_74782_a("mapIntState", (NBTBase)blockMapIntState.putIntStateMapIntoNBT());
        tagCompound.func_74782_a("mapIntStack", (NBTBase)blockMapIntState.putIntStackMapIntoNBT());
        int[] posIntArray = posIntArrayList.stream().mapToInt(i -> i).toArray();
        int[] stateIntArray = stateIntArrayList.stream().mapToInt(i -> i).toArray();
        tagCompound.func_74783_a("posIntArray", posIntArray);
        tagCompound.func_74783_a("stateIntArray", stateIntArray);
        tagCompound.func_74782_a("startPos", (NBTBase)NBTUtil.func_186859_a((BlockPos)start));
        tagCompound.func_74782_a("endPos", (NBTBase)NBTUtil.func_186859_a((BlockPos)end));
        tagCompound.func_74768_a("dim", player.field_71093_bK);
        tagCompound.func_74778_a("UUID", tool.getUUID(stack));
        tagCompound.func_74778_a("owner", player.func_70005_c_());
        tool.incrementCopyCounter(stack);
        tagCompound.func_74768_a("copycounter", tool.getCopyCounter(stack));
        worldSave.addToMap(tool.getUUID(stack), tagCompound);
        worldSave.markForSaving();
        PacketHandler.INSTANCE.sendTo((IMessage)new PacketBlockMap(tagCompound), (EntityPlayerMP)player);
        if (foundTE > 0) {
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.YELLOW + new TextComponentTranslation("message.gadget.TEinCopy", new Object[0]).func_150261_e() + ": " + foundTE), true);
        } else {
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.AQUA + new TextComponentTranslation("message.gadget.copied", new Object[0]).func_150261_e()), true);
        }
        return true;
    }

    private void buildBlockMap(World world, BlockPos startPos, ItemStack stack, EntityPlayer player) {
        BlockPos anchorPos = GadgetCopyPaste.getAnchor(stack);
        BlockPos pos = anchorPos == null ? startPos : anchorPos;
        NBTTagCompound tagCompound = WorldSave.getWorldSave(world).getCompoundFromUUID(this.getUUID(stack));
        pos = pos.func_177981_b(GadgetCopyPaste.getY(stack));
        pos = pos.func_177965_g(GadgetCopyPaste.getX(stack));
        pos = pos.func_177970_e(GadgetCopyPaste.getZ(stack));
        List<BlockMap> blockMapList = GadgetCopyPaste.getBlockMapList(tagCompound, pos);
        GadgetCopyPaste.setLastBuild(stack, pos, player.field_71093_bK);
        for (BlockMap blockMap : blockMapList) {
            this.placeBlock(world, blockMap.pos, player, blockMap.state, GadgetCopyPaste.getBlockMapIntState(tagCompound).getIntStackMap());
        }
        GadgetUtils.clearCachedRemoteInventory();
        GadgetCopyPaste.setAnchor(stack, null);
    }

    private void placeBlock(World world, BlockPos pos, EntityPlayer player, IBlockState state, Map<IBlockState, UniqueItem> IntStackMap) {
        IBlockState testState = world.func_180495_p(pos);
        if (SyncedConfig.canOverwriteBlocks && !testState.func_177230_c().func_176200_f((IBlockAccess)world, pos) || !SyncedConfig.canOverwriteBlocks && testState.func_177230_c().isAir(testState, (IBlockAccess)world, pos)) {
            return;
        }
        if (pos.func_177956_o() < 0 || state.equals(Blocks.field_150350_a.func_176223_P()) || !player.func_175142_cm()) {
            return;
        }
        ItemStack heldItem = GadgetCopyPaste.getGadget(player);
        if (heldItem.func_190926_b()) {
            return;
        }
        if (ModItems.gadgetCopyPaste.getStartPos(heldItem) == null || ModItems.gadgetCopyPaste.getEndPos(heldItem) == null) {
            return;
        }
        UniqueItem uniqueItem = IntStackMap.get(state);
        if (uniqueItem == null) {
            return;
        }
        ItemStack itemStack = new ItemStack(uniqueItem.item, 1, uniqueItem.meta);
        NonNullList drops = NonNullList.func_191196_a();
        state.func_177230_c().getDrops(drops, (IBlockAccess)world, pos, state, 0);
        int neededItems = 0;
        for (ItemStack drop : drops) {
            if (!drop.func_77973_b().equals(itemStack.func_77973_b())) continue;
            ++neededItems;
        }
        if (neededItems == 0) {
            neededItems = 1;
        }
        if (!world.func_175660_a(player, pos)) {
            return;
        }
        BlockSnapshot blockSnapshot = BlockSnapshot.getBlockSnapshot((World)world, (BlockPos)pos);
        if (!GadgetGeneric.EmitEvent.placeBlock(player, blockSnapshot, EnumFacing.UP, EnumHand.MAIN_HAND)) {
            return;
        }
        ItemStack constructionPaste = new ItemStack((Item)ModItems.constructionPaste);
        boolean useConstructionPaste = false;
        if (InventoryManipulation.countItem(itemStack, player, world) < neededItems) {
            if (InventoryManipulation.countPaste(player) < neededItems) {
                return;
            }
            itemStack = constructionPaste.func_77946_l();
            useConstructionPaste = true;
        }
        if (!this.canUse(heldItem, player)) {
            return;
        }
        this.applyDamage(heldItem, player);
        boolean useItemSuccess = useConstructionPaste ? InventoryManipulation.usePaste(player, 1) : InventoryManipulation.useItem(itemStack, player, neededItems, world);
        if (useItemSuccess) {
            world.func_72838_d((Entity)new BlockBuildEntity(world, pos, (EntityLivingBase)player, state, 1, state, useConstructionPaste));
        }
    }

    public static void anchorBlocks(EntityPlayer player, ItemStack stack) {
        BlockPos currentAnchor = GadgetCopyPaste.getAnchor(stack);
        if (currentAnchor == null) {
            RayTraceResult lookingAt = VectorTools.getLookingAt(player, stack);
            if (lookingAt == null) {
                return;
            }
            currentAnchor = lookingAt.func_178782_a();
            GadgetCopyPaste.setAnchor(stack, currentAnchor);
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.AQUA + new TextComponentTranslation("message.gadget.anchorrender", new Object[0]).func_150261_e()), true);
        } else {
            GadgetCopyPaste.setAnchor(stack, null);
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.AQUA + new TextComponentTranslation("message.gadget.anchorremove", new Object[0]).func_150261_e()), true);
        }
    }

    public void undoBuild(EntityPlayer player, ItemStack heldItem) {
        NBTTagCompound tagCompound = WorldSave.getWorldSave(player.field_70170_p).getCompoundFromUUID(ModItems.gadgetCopyPaste.getUUID(heldItem));
        World world = player.field_70170_p;
        if (world.field_72995_K) {
            return;
        }
        BlockPos startPos = GadgetCopyPaste.getLastBuild(heldItem);
        if (startPos == null) {
            return;
        }
        Integer dimension = GadgetCopyPaste.getLastBuildDim(heldItem);
        ItemStack silkTool = heldItem.func_77946_l();
        silkTool.func_77966_a(Enchantments.field_185306_r, 1);
        List<BlockMap> blockMapList = GadgetCopyPaste.getBlockMapList(tagCompound, startPos);
        boolean success = true;
        for (BlockMap blockMap : blockMapList) {
            boolean cancelled;
            double distance = blockMap.pos.func_185332_f(player.func_180425_c().func_177958_n(), player.func_180425_c().func_177956_o(), player.func_180425_c().func_177952_p());
            boolean sameDim = player.field_71093_bK == dimension;
            IBlockState currentBlock = world.func_180495_p(blockMap.pos);
            boolean bl = cancelled = !GadgetGeneric.EmitEvent.breakBlock(world, blockMap.pos, currentBlock, player);
            if (distance < 256.0 && !cancelled && sameDim) {
                if (currentBlock.func_177230_c() != blockMap.state.func_177230_c() && !(currentBlock.func_177230_c() instanceof ConstructionBlock) || !(currentBlock.func_185887_b(world, blockMap.pos) >= 0.0f)) continue;
                currentBlock.func_177230_c().func_180657_a(world, player, blockMap.pos, currentBlock, world.func_175625_s(blockMap.pos), silkTool);
                world.func_72838_d((Entity)new BlockBuildEntity(world, blockMap.pos, (EntityLivingBase)player, currentBlock, 2, currentBlock, false));
                continue;
            }
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + new TextComponentTranslation("message.gadget.undofailed", new Object[0]).func_150261_e()), true);
            success = false;
        }
        if (success) {
            GadgetCopyPaste.setLastBuild(heldItem, null, 0);
        }
    }

    public static ItemStack getGadget(EntityPlayer player) {
        ItemStack stack = GadgetGeneric.getGadget(player);
        if (!(stack.func_77973_b() instanceof GadgetCopyPaste)) {
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    public static enum ToolMode {
        Copy,
        Paste;

        private static ToolMode[] vals;

        public ToolMode next() {
            return vals[(this.ordinal() + 1) % vals.length];
        }

        static {
            vals = ToolMode.values();
        }
    }
}

