/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tools;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;

public class BlockPosState {
    private static final String NBT_BLOCK_POS = "block_pos";
    private static final String NBT_BLOCK_STATE = "block_state";
    private static final String NBT_BLOCK_PASTE = "block_is_paste";
    private BlockPos pos;
    private IBlockState state;
    private boolean isPaste;

    public BlockPosState(BlockPos pos, IBlockState state, boolean isPaste) {
        this.pos = pos;
        this.state = state;
        this.isPaste = isPaste;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public IBlockState getState() {
        return this.state;
    }

    public boolean isPaste() {
        return this.isPaste;
    }

    public NBTTagCompound toCompound() {
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagCompound stateCompound = new NBTTagCompound();
        NBTTagCompound posCompound = NBTUtil.func_186859_a((BlockPos)this.pos);
        NBTUtil.func_190009_a((NBTTagCompound)stateCompound, (IBlockState)this.state);
        compound.func_74782_a(NBT_BLOCK_POS, (NBTBase)posCompound);
        compound.func_74782_a(NBT_BLOCK_STATE, (NBTBase)stateCompound);
        compound.func_74757_a(NBT_BLOCK_PASTE, this.isPaste);
        return compound;
    }

    @Nullable
    public static BlockPosState fromCompound(NBTTagCompound compound) {
        if (!compound.func_74764_b(NBT_BLOCK_POS)) {
            return null;
        }
        return new BlockPosState(NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l(NBT_BLOCK_POS)), NBTUtil.func_190008_d((NBTTagCompound)compound.func_74775_l(NBT_BLOCK_STATE)), compound.func_74767_n(NBT_BLOCK_PASTE));
    }
}

